/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import net.domixcze.domixscreatures.config.ModConfig;
import net.domixcze.domixscreatures.entity.ModEntities;
import net.domixcze.domixscreatures.entity.ai.FireSalamanderMagmaBallAttackGoal;
import net.domixcze.domixscreatures.entity.ai.FireSalamanderMeleeAttackGoal;
import net.domixcze.domixscreatures.entity.client.fire_salamander.FireSalamanderVariants;
import net.domixcze.domixscreatures.sound.ModSounds;
import net.minecraft.class_124;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1324;
import net.minecraft.class_1333;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import net.minecraft.class_7;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FireSalamanderEntity
extends class_1321
implements GeoEntity {
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(FireSalamanderEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SITTING = class_2945.method_12791(FireSalamanderEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_CHARGING = class_2945.method_12791(FireSalamanderEntity.class, (class_2941)class_2943.field_13323);
    private int magmaBallChargeTime = 0;
    private int magmaBallCooldown = 0;
    private static final int SMELTING_COOLDOWN = 300;
    private int smeltingTimer = 0;
    private class_1799 smeltingItem = class_1799.field_8037;
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public FireSalamanderEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_14, 0.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, -1.0f);
        this.field_6206 = new SalamanderLookControl((class_1308)this);
    }

    public boolean method_5753() {
        return true;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new FireSalamanderMagmaBallAttackGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_1350((class_1321)this, 1.0, 10.0f, 2.0f));
        this.field_6201.method_6277(2, (class_1352)new FireSalamanderMeleeAttackGoal(this, 1.0, false));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 0.75, 1.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1321.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23723, 2.0).method_26868(class_5134.field_23722, 1.0).method_26868(class_5134.field_23719, (double)0.2f);
    }

    public boolean method_6121(class_1297 target) {
        boolean success = super.method_6121(target);
        if (success) {
            target.method_5639(5.0f);
        }
        return success;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)ModEntities.FIRE_SALAMANDER.method_5883((class_1937)world);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        entityData = super.method_5943(world, difficulty, spawnReason, entityData);
        this.setVariant(FireSalamanderVariants.MAGMA);
        return entityData;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)FireSalamanderVariants.MAGMA.getId());
        builder.method_56912(SITTING, (Object)false);
        builder.method_56912(IS_CHARGING, (Object)false);
    }

    public FireSalamanderVariants getVariant() {
        return FireSalamanderVariants.byId((Integer)this.field_6011.method_12789(VARIANT));
    }

    public void setVariant(FireSalamanderVariants variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public boolean isObsidianVariant() {
        return this.getVariant() == FireSalamanderVariants.OBSIDIAN;
    }

    public boolean method_24345() {
        return (Boolean)this.field_6011.method_12789(SITTING);
    }

    public void setSit(class_1657 player, boolean sitting) {
        if (player == this.method_35057()) {
            this.field_6011.method_12778(SITTING, (Object)sitting);
            super.method_24346(sitting);
        }
    }

    public int getMagmaBallCooldown() {
        return this.magmaBallCooldown;
    }

    public void setMagmaBallCooldown(int cooldown) {
        this.magmaBallCooldown = cooldown;
    }

    public int getMagmaBallChargeTime() {
        return this.magmaBallChargeTime;
    }

    public void setMagmaBallChargeTime(int time) {
        this.magmaBallChargeTime = time;
    }

    public boolean isCharging() {
        return (Boolean)this.field_6011.method_12789(IS_CHARGING);
    }

    public void setCharging(boolean charging) {
        this.field_6011.method_12778(IS_CHARGING, (Object)charging);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("MagmaBallChargeTime", this.magmaBallChargeTime);
        nbt.method_10569("MagmaBallCooldown", this.magmaBallCooldown);
        nbt.method_10569("Variant", this.getVariant().getId());
        if (this.method_35057() != null) {
            nbt.method_25927("Owner", this.method_6139());
        }
        nbt.method_10556("isSitting", ((Boolean)this.field_6011.method_12789(SITTING)).booleanValue());
        nbt.method_10556("isCharging", ((Boolean)this.field_6011.method_12789(IS_CHARGING)).booleanValue());
        if (!this.smeltingItem.method_7960()) {
            nbt.method_10566("SmeltingItem", (class_2520)class_1799.field_24671.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.smeltingItem).resultOrPartial(error -> {}).orElse(new class_2487()));
        }
        nbt.method_10569("SmeltingTimer", this.smeltingTimer);
    }

    public void method_5749(class_2487 nbt) {
        UUID ownerUUID;
        super.method_5749(nbt);
        this.magmaBallChargeTime = nbt.method_10550("MagmaBallChargeTime");
        this.magmaBallCooldown = nbt.method_10550("MagmaBallCooldown");
        this.setVariant(FireSalamanderVariants.byId(nbt.method_10550("Variant")));
        UUID uUID = ownerUUID = nbt.method_10545("Owner") ? nbt.method_25926("Owner") : null;
        if (ownerUUID != null) {
            this.method_6174(ownerUUID);
        }
        this.field_6011.method_12778(SITTING, (Object)nbt.method_10577("isSitting"));
        this.field_6011.method_12778(IS_CHARGING, (Object)nbt.method_10577("isCharging"));
        this.smeltingItem = nbt.method_10545("SmeltingItem") ? class_1799.field_24671.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("SmeltingItem")).resultOrPartial(error -> {}).orElse(class_1799.field_8037) : class_1799.field_8037;
        this.smeltingTimer = nbt.method_10550("SmeltingTimer");
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public void method_6007() {
        super.method_6007();
        class_1324 movementSpeed = this.method_5996(class_5134.field_23719);
        if (movementSpeed != null) {
            if (this.method_5771()) {
                movementSpeed.method_6192(1.5);
            } else {
                movementSpeed.method_6192((double)0.2f);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController landController = new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate);
        landController.triggerableAnim("attack", RawAnimation.begin().then("animation.fire_salamander.attack", Animation.LoopType.PLAY_ONCE));
        controllers.add(landController);
        controllers.add(new AnimationController((GeoAnimatable)this, "lava_controller", 5, this::lavaPredicate));
    }

    private <T extends GeoAnimatable> PlayState landPredicate(AnimationState<T> state) {
        if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.fire_salamander.walk", Animation.LoopType.LOOP));
        } else if (this.method_24345()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.fire_salamander.sit", Animation.LoopType.LOOP));
        } else if (this.isCharging()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.fire_salamander.charge", Animation.LoopType.PLAY_ONCE));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.fire_salamander.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState lavaPredicate(AnimationState<T> state) {
        if (!this.method_5771()) {
            return PlayState.STOP;
        }
        if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.fire_salamander.swim", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.fire_salamander.idle_swim", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    public void method_5773() {
        super.method_5773();
        if (this.magmaBallCooldown > 0) {
            --this.magmaBallCooldown;
        }
        if (this.method_5637() && !this.isObsidianVariant()) {
            this.setVariant(FireSalamanderVariants.OBSIDIAN);
        }
        if (ModConfig.INSTANCE.enableFireSalamanderSmelting && !this.smeltingItem.method_7960()) {
            if (this.smeltingTimer > 0) {
                --this.smeltingTimer;
            } else {
                this.smeltItem();
            }
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7909() == class_1802.field_8135 && !this.method_6181() && this.isObsidianVariant()) {
            if (this.method_37908().method_8608()) {
                return class_1269.field_21466;
            }
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            if (!this.method_37908().method_8608()) {
                super.method_6170(player);
                this.field_6189.method_6356();
                this.method_5980(null);
                this.method_37908().method_8421((class_1297)this, (byte)7);
            }
            this.method_5783(class_3417.field_20614, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        if (this.method_6181() && !this.method_37908().method_8608()) {
            if (itemStack.method_7909() == class_1802.field_8894 && hand == class_1268.field_5808) {
                this.setSit(player, !this.method_24345());
                class_2561 entityName = this.method_5476();
                class_5250 action = class_2561.method_43471((String)(this.method_24345() ? "message.domixs-creatures.action.sitting" : "message.domixs-creatures.action.following"));
                class_5250 message = class_2561.method_43470((String)(entityName.getString() + " ")).method_10852((class_2561)action).method_27693(".").method_27694(style -> style.method_10977(class_124.field_1060));
                player.method_7353((class_2561)message, true);
                return class_1269.field_5811;
            }
            if (ModConfig.INSTANCE.enableFireSalamanderSmelting && this.canSmelt(itemStack) && this.smeltingItem.method_7960()) {
                this.startSmelting(itemStack);
                if (!player.method_31549().field_7477) {
                    itemStack.method_7934(1);
                }
                return class_1269.field_5812;
            }
        }
        return super.method_5992(player, hand);
    }

    private boolean canSmelt(class_1799 stack) {
        class_9696 input = new class_9696(stack);
        return this.method_37908().method_8433().method_8132(class_3956.field_17546, (class_9695)input, this.method_37908()).isPresent();
    }

    private void startSmelting(class_1799 stack) {
        this.smeltingItem = stack.method_7972();
        this.smeltingTimer = 300;
    }

    private void smeltItem() {
        class_1937 class_19372;
        if (!this.smeltingItem.method_7960() && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_9696 input = new class_9696(this.smeltingItem);
            Optional recipe = serverWorld.method_8433().method_8132(class_3956.field_17546, (class_9695)input, (class_1937)serverWorld);
            if (recipe.isPresent()) {
                class_1799 result = ((class_3861)((class_8786)recipe.get()).comp_1933()).method_8110((class_7225.class_7874)serverWorld.method_30349()).method_7972();
                this.method_5775(result);
            }
            this.smeltingItem = class_1799.field_8037;
        }
    }

    public boolean method_5931() {
        return false;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.FIRE_SALAMANDER_HURT;
    }

    protected class_3414 method_6002() {
        return ModSounds.FIRE_SALAMANDER_DEATH;
    }

    class SalamanderLookControl
    extends class_1333 {
        public SalamanderLookControl(class_1308 entity) {
            super(entity);
        }

        public void method_6231() {
            if (!FireSalamanderEntity.this.isCharging()) {
                super.method_6231();
            }
        }
    }
}

