/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import net.domixcze.domixscreatures.config.ModConfig;
import net.domixcze.domixscreatures.effect.ModEffects;
import net.domixcze.domixscreatures.entity.client.hermit_crab.HermitCrabShapes;
import net.domixcze.domixscreatures.entity.client.hermit_crab.HermitCrabVariants;
import net.domixcze.domixscreatures.util.ModTags;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1391;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2619;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HermitCrabEntity
extends class_1429
implements GeoEntity {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(HermitCrabEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> SHAPE = class_2945.method_12791(HermitCrabEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_HIDDEN = class_2945.method_12791(HermitCrabEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_DANCING = class_2945.method_12791(HermitCrabEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2960 HERMIT_CRAB_BARTERING_LOOT_TABLE_ID = class_2960.method_60655((String)"domixs-creatures", (String)"gameplay/hermit_crab_bartering");
    private int hideCooldown;
    private static final int HIDE_DISTANCE_SQ = 36;
    private int tradeCount;
    private int tradeCooldown;
    private static final int TRADE_COOLDOWN = 24000;

    public HermitCrabEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23724, 4.0).method_26868(class_5134.field_51578, 0.5).method_26868(class_5134.field_23721, 2.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new HermitCrabDanceGoal(this));
        this.field_6201.method_6277(0, (class_1352)new HermitCrabHideGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_1391((class_1314)this, 1.0, stack -> stack.method_31573(ModTags.Items.HERMIT_CRAB_TEMPT), false));
        this.field_6201.method_6277(2, (class_1352)new class_1379((class_1314)this, 0.75, 1));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
    }

    public boolean method_5931() {
        return false;
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        entityData = super.method_5943(world, difficulty, spawnReason, entityData);
        if (spawnReason == class_3730.field_16459 || spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16472 || spawnReason == class_3730.field_16466) {
            class_6880 biomeEntry = world.method_23753(this.method_24515());
            if (biomeEntry.method_40220(ModTags.Biomes.HERMIT_CRAB_SPAWNS_IN)) {
                this.setVariant(this.field_5974.method_43056() ? HermitCrabVariants.BLUE : HermitCrabVariants.PINK);
            } else {
                this.setVariant(HermitCrabVariants.PINK);
            }
            this.setShape(this.field_5974.method_43056() ? HermitCrabShapes.ROUND : HermitCrabShapes.POINTY);
        }
        return entityData;
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 5, this::Predicate));
    }

    private <T extends GeoAnimatable> PlayState Predicate(AnimationState<T> state) {
        if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.hermit_crab.walk", Animation.LoopType.LOOP));
        } else if (this.isHidden()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.hermit_crab.hide", Animation.LoopType.HOLD_ON_LAST_FRAME));
        } else if (this.isDancing()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.hermit_crab.dance", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.hermit_crab.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)HermitCrabVariants.PINK.getId());
        builder.method_56912(SHAPE, (Object)HermitCrabShapes.ROUND.getId());
        builder.method_56912(IS_HIDDEN, (Object)false);
        builder.method_56912(IS_DANCING, (Object)false);
    }

    public HermitCrabVariants getVariant() {
        return HermitCrabVariants.byId((Integer)this.field_6011.method_12789(VARIANT));
    }

    public void setVariant(HermitCrabVariants variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public HermitCrabShapes getShape() {
        return HermitCrabShapes.byId((Integer)this.field_6011.method_12789(SHAPE));
    }

    public void setShape(HermitCrabShapes shape) {
        this.field_6011.method_12778(SHAPE, (Object)shape.getId());
    }

    public boolean isHidden() {
        return (Boolean)this.field_6011.method_12789(IS_HIDDEN);
    }

    public void setHidden(boolean hidden) {
        this.field_6011.method_12778(IS_HIDDEN, (Object)hidden);
    }

    public boolean isDancing() {
        return (Boolean)this.field_6011.method_12789(IS_DANCING);
    }

    public void setDancing(boolean dancing) {
        this.field_6011.method_12778(IS_DANCING, (Object)dancing);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getVariant().getId());
        nbt.method_10569("Shape", this.getShape().getId());
        nbt.method_10569("TradeCount", this.tradeCount);
        nbt.method_10569("TradeCooldown", this.tradeCooldown);
        nbt.method_10556("IsHidden", this.isHidden());
        nbt.method_10569("HideCooldown", this.hideCooldown);
        nbt.method_10556("IsDancing", this.isDancing());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(HermitCrabVariants.byId(nbt.method_10550("Variant")));
        this.setShape(HermitCrabShapes.byId(nbt.method_10550("Shape")));
        this.tradeCount = nbt.method_10550("TradeCount");
        this.tradeCooldown = nbt.method_10550("TradeCooldown");
        this.setHidden(nbt.method_10577("IsHidden"));
        this.hideCooldown = nbt.method_10550("HideCooldown");
        this.setDancing(nbt.method_10577("IsDancing"));
    }

    public void method_5773() {
        boolean runningPlayerNearby;
        super.method_5773();
        if (this.method_37908().method_8608()) {
            return;
        }
        if (this.tradeCooldown > 0) {
            --this.tradeCooldown;
            if (this.tradeCooldown == 0) {
                this.tradeCount = 0;
            }
        }
        if (runningPlayerNearby = this.isRunningPlayerNearby()) {
            if (!this.isHidden()) {
                this.setHidden(true);
                this.setDancing(false);
            }
            if (this.isHidden()) {
                this.hideCooldown = 200;
            }
        } else if (this.isHidden()) {
            if (this.hideCooldown <= 0) {
                this.hideCooldown = 200;
            }
            --this.hideCooldown;
            if (this.hideCooldown == 0) {
                this.setHidden(false);
            }
        } else {
            this.hideCooldown = 0;
        }
    }

    private boolean isRunningPlayerNearby() {
        return !this.method_37908().method_8390(class_1657.class, this.method_5829().method_1014(Math.sqrt(36.0)), player -> player.method_5805() && player.method_5624()).isEmpty();
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (this.isHidden() || this.isDancing()) {
            return class_1269.field_5811;
        }
        if (itemStack.method_31573(ModTags.Items.HERMIT_CRAB_TEMPT)) {
            if (!this.method_37908().method_8608()) {
                class_3218 serverWorld = (class_3218)this.method_37908();
                int boostAmount = 0;
                class_1293 tradeBoostInstance = player.method_6112(ModEffects.OCEAN_BLESSING);
                if (tradeBoostInstance != null) {
                    boostAmount = 5 * (tradeBoostInstance.method_5578() + 1);
                }
                if (this.tradeCooldown > 0) {
                    serverWorld.method_14199((class_2394)class_2398.field_11251, this.method_23317(), this.method_23323(0.5), this.method_23321(), 5, 0.0, 0.0, 0.0, 0.1);
                    return class_1269.field_5812;
                }
                if (this.tradeCount < ModConfig.INSTANCE.hermitCrabDailyTradeLimit + boostAmount) {
                    itemStack.method_7934(1);
                    this.dropBarterLoot(player);
                    ++this.tradeCount;
                    serverWorld.method_14199((class_2394)class_2398.field_11201, this.method_23317(), this.method_23323(0.5), this.method_23321(), 1, 0.2, 0.1, 0.2, 0.1);
                    if (this.tradeCount >= ModConfig.INSTANCE.hermitCrabDailyTradeLimit + boostAmount) {
                        this.tradeCooldown = 24000;
                    }
                } else {
                    serverWorld.method_14199((class_2394)class_2398.field_11251, this.method_23317(), this.method_23323(0.5), this.method_23321(), 5, 0.0, 0.0, 0.0, 0.1);
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        return super.method_5992(player, hand);
    }

    private void dropBarterLoot(class_1657 player) {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_5321 lootTableKey = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)HERMIT_CRAB_BARTERING_LOOT_TABLE_ID);
        class_52 lootTable = serverWorld.method_8503().method_58576().method_58295(lootTableKey);
        class_8567 lootContextParameterSet = new class_8567.class_8568(serverWorld).method_51874(class_181.field_1226, (Object)this).method_51871(player.method_7292()).method_51875(class_173.field_22403);
        ObjectArrayList generatedLoot = lootTable.method_51878(lootContextParameterSet);
        for (class_1799 itemStack : generatedLoot) {
            this.method_5775(itemStack);
        }
    }

    private static class HermitCrabDanceGoal
    extends class_1352 {
        private final HermitCrabEntity crab;
        private final int searchRadius = 8;

        public HermitCrabDanceGoal(HermitCrabEntity crab) {
            this.crab = crab;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return !this.crab.isHidden() && this.isJukeboxPlayingNearby();
        }

        public boolean method_6266() {
            return !this.crab.isHidden() && this.isJukeboxPlayingNearby();
        }

        public void method_6269() {
            this.crab.setDancing(true);
            this.crab.method_5942().method_6340();
            this.crab.method_5988().method_6231();
        }

        public void method_6270() {
            this.crab.setDancing(false);
        }

        private boolean isJukeboxPlayingNearby() {
            class_2338 entityPos = this.crab.method_24515();
            for (int x = -8; x <= 8; ++x) {
                for (int y = -8; y <= 8; ++y) {
                    for (int z = -8; z <= 8; ++z) {
                        class_2619 jukeboxBlockEntity;
                        class_2586 blockEntity;
                        class_2338 currentPos = entityPos.method_10069(x, y, z);
                        class_2680 blockState = this.crab.method_37908().method_8320(currentPos);
                        if (!blockState.method_27852(class_2246.field_10223) || !((blockEntity = this.crab.method_37908().method_8321(currentPos)) instanceof class_2619) || !(jukeboxBlockEntity = (class_2619)blockEntity).method_60784().method_60754()) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static class HermitCrabHideGoal
    extends class_1352 {
        private final HermitCrabEntity crab;

        public HermitCrabHideGoal(HermitCrabEntity crab) {
            this.crab = crab;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return !this.crab.method_37908().method_8608() && (this.crab.isRunningPlayerNearby() || this.crab.isHidden() && this.crab.hideCooldown > 0);
        }

        public boolean method_6266() {
            return this.crab.isHidden() || this.crab.isRunningPlayerNearby();
        }

        public void method_6269() {
            this.crab.setHidden(true);
            this.crab.method_5942().method_6340();
            this.crab.method_5988().method_6231();
        }

        public void method_6270() {
            this.crab.setHidden(false);
        }
    }
}

