/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import java.util.EnumSet;
import net.domixcze.domixscreatures.entity.ModEntities;
import net.domixcze.domixscreatures.entity.ai.BabyFollowParentGoal;
import net.domixcze.domixscreatures.entity.ai.HippoMeleeAttackGoal;
import net.domixcze.domixscreatures.entity.ai.SleepGoal;
import net.domixcze.domixscreatures.entity.ai.Sleepy;
import net.domixcze.domixscreatures.entity.client.hippo.HippoVariants;
import net.domixcze.domixscreatures.entity.custom.CrocodileEntity;
import net.domixcze.domixscreatures.sound.ModSounds;
import net.domixcze.domixscreatures.util.ModTags;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1324;
import net.minecraft.class_1335;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1543;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5757;
import net.minecraft.class_5766;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HippoEntity
extends class_1429
implements GeoEntity,
Sleepy {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final class_2940<Boolean> SLEEPING = class_2945.method_12791(HippoEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_ROLLING_IN_MUD = class_2945.method_12791(HippoEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_MUDDY = class_2945.method_12791(HippoEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_MUD_DRY = class_2945.method_12791(HippoEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(HippoEntity.class, (class_2941)class_2943.field_13327);
    private int mudDryingTimer = 0;
    private int mudCooldown = 0;
    private int mudWashingTimer = 0;

    public HippoEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new HippoMoveControl(this);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1314.method_26828().method_26868(class_5134.field_23716, 60.0).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23719, 0.2);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SleepGoal(this, (class_1308)this, 150, true, false, false, false, 3.0, 700, 800, true, false, false, true, 3));
        this.field_6201.method_6277(1, (class_1352)new HippoMeleeAttackGoal(this, 1.0, true));
        this.field_6201.method_6277(1, (class_1352)new RollInMudGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new BabyFollowParentGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1543.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, CrocodileEntity.class, true));
    }

    protected class_1408 method_5965(class_1937 world) {
        return new class_5766((class_1308)this, world);
    }

    public void method_6005(double strength, double x, double z) {
        super.method_6005(strength * 0.1, x, z);
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5931() {
        return false;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ModTags.Items.HIPPO_FOR_BREEDING);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        entityData = super.method_5943(world, difficulty, spawnReason, entityData);
        if (world.method_8409().method_43058() < 0.05) {
            this.setVariant(HippoVariants.ALBINO);
        } else {
            this.setVariant(HippoVariants.NORMAL);
        }
        return entityData;
    }

    protected class_4048 method_55694(class_4050 pose) {
        if (this.method_6109()) {
            return class_4048.method_18385((float)1.7f, (float)1.5f);
        }
        return this.method_5864().method_18386();
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        HippoEntity baby = (HippoEntity)ModEntities.HIPPO.method_5883((class_1937)world);
        if (baby != null) {
            HippoEntity parent1 = this;
            HippoEntity parent2 = (HippoEntity)entity;
            if (parent1.getVariant() == HippoVariants.ALBINO && parent2.getVariant() == HippoVariants.ALBINO) {
                baby.setVariant(HippoVariants.ALBINO);
            } else if (parent1.getVariant() == HippoVariants.ALBINO || parent2.getVariant() == HippoVariants.ALBINO) {
                double chance = 0.25;
                if (world.method_8409().method_43058() < chance) {
                    baby.setVariant(HippoVariants.ALBINO);
                } else {
                    baby.setVariant(HippoVariants.NORMAL);
                }
            } else {
                double chance = 0.01;
                if (world.method_8409().method_43058() < chance) {
                    baby.setVariant(HippoVariants.ALBINO);
                } else {
                    baby.setVariant(HippoVariants.NORMAL);
                }
            }
        }
        return baby;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)HippoVariants.NORMAL.getId());
        builder.method_56912(SLEEPING, (Object)false);
        builder.method_56912(IS_ROLLING_IN_MUD, (Object)false);
        builder.method_56912(IS_MUDDY, (Object)false);
        builder.method_56912(IS_MUD_DRY, (Object)false);
    }

    public boolean isRollingInMud() {
        return (Boolean)this.field_6011.method_12789(IS_ROLLING_IN_MUD);
    }

    public void setRollingInMud(boolean rolling) {
        this.field_6011.method_12778(IS_ROLLING_IN_MUD, (Object)rolling);
    }

    public boolean isMuddy() {
        return (Boolean)this.field_6011.method_12789(IS_MUDDY);
    }

    public void setMuddy(boolean muddy) {
        this.field_6011.method_12778(IS_MUDDY, (Object)muddy);
    }

    public boolean isMudDry() {
        return (Boolean)this.field_6011.method_12789(IS_MUD_DRY);
    }

    public void setMudDry(boolean mudDry) {
        this.field_6011.method_12778(IS_MUD_DRY, (Object)mudDry);
    }

    @Override
    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.method_5942().method_6340();
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getVariant().getId());
        nbt.method_10556("Sleeping", this.method_6113());
        nbt.method_10569("MudCooldown", this.mudCooldown);
        nbt.method_10569("MudWashTimer", this.mudWashingTimer);
        nbt.method_10556("IsMuddy", this.isMuddy());
        nbt.method_10569("MudDryingTimer", this.mudDryingTimer);
        nbt.method_10556("IsMudDry", this.isMudDry());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(HippoVariants.byId(nbt.method_10550("Variant")));
        this.setSleeping(nbt.method_10577("Sleeping"));
        this.mudCooldown = nbt.method_10550("MudCooldown");
        this.mudWashingTimer = nbt.method_10550("MudWashTimer");
        this.setMuddy(nbt.method_10577("IsMuddy"));
        this.mudDryingTimer = nbt.method_10550("MudDryingTimer");
        this.setMudDry(nbt.method_10577("IsMudDry"));
    }

    public HippoVariants getVariant() {
        return HippoVariants.byId((Integer)this.field_6011.method_12789(VARIANT));
    }

    public void setVariant(HippoVariants variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public void method_5773() {
        class_1324 armorAttribute;
        super.method_5773();
        if (this.method_5721()) {
            if (this.isMuddy()) {
                ++this.mudWashingTimer;
                if (this.mudWashingTimer >= 200) {
                    this.setMuddy(false);
                    this.mudWashingTimer = 0;
                }
            }
        } else {
            this.mudWashingTimer = 0;
        }
        if (this.mudCooldown > 0) {
            --this.mudCooldown;
        }
        if (this.isMuddy()) {
            if (!this.isMudDry()) {
                ++this.mudDryingTimer;
                if (this.mudDryingTimer >= 600) {
                    this.setMudDry(true);
                    this.mudDryingTimer = 0;
                }
            }
        } else {
            this.mudDryingTimer = 0;
            this.setMudDry(false);
        }
        if ((armorAttribute = this.method_5996(class_5134.field_23724)) != null) {
            if (this.isMudDry()) {
                armorAttribute.method_6192(5.0);
            } else {
                armorAttribute.method_6192(0.0);
            }
        }
        if (this.method_5799()) {
            this.field_6207 = new class_5757((class_1308)this, 85, 10, 5.0f, 0.1f, true);
        } else if (this.method_24828()) {
            this.field_6207 = new HippoMoveControl(this);
        }
    }

    public void method_6007() {
        super.method_6007();
        class_1324 movementSpeed = this.method_5996(class_5134.field_23719);
        if (movementSpeed != null) {
            if (this.method_24828()) {
                movementSpeed.method_6192((double)0.2f);
            } else if (this.method_5799()) {
                movementSpeed.method_6192(1.5);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController landController = new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate);
        landController.triggerableAnim("attack", RawAnimation.begin().then("animation.hippo.attack", Animation.LoopType.PLAY_ONCE));
        controllers.add(landController);
        controllers.add(new AnimationController((GeoAnimatable)this, "water_controller", 5, this::waterPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "sleep_controller", 5, this::sleepPredicate));
    }

    private <T extends GeoAnimatable> PlayState landPredicate(AnimationState<T> state) {
        if (this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_18798().method_37268() > 1.0E-9) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.hippo.walk", Animation.LoopType.LOOP));
            } else if (this.isRollingInMud()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.hippo.roll", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.hippo.idle", Animation.LoopType.LOOP));
            }
        } else if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.hippo.walk", Animation.LoopType.LOOP));
        } else if (this.isRollingInMud()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.hippo.roll", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.hippo.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState waterPredicate(AnimationState<T> state) {
        if (!this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_18798().method_37268() > 1.0E-9) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.hippo.swim", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.hippo.idle_swim", Animation.LoopType.LOOP));
            }
        } else if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.hippo.swim", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.hippo.idle_swim", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState sleepPredicate(AnimationState<T> state) {
        if (this.method_6113()) {
            if (this.method_6109()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.hippo.sleep", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.hippo.sleep", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    protected class_3414 method_5994() {
        if (this.method_6113()) {
            return null;
        }
        return ModSounds.HIPPO_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.HIPPO_HURT;
    }

    class HippoMoveControl
    extends class_1335 {
        public HippoMoveControl(HippoEntity this$0) {
            super((class_1308)this$0);
        }
    }

    public static class RollInMudGoal
    extends class_1352 {
        private final HippoEntity hippo;
        private int rollingTime;
        private boolean fullyRolled = false;
        private int soundCooldown = 10;

        public RollInMudGoal(HippoEntity hippo) {
            this.hippo = hippo;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.hippo.mudCooldown > 0 || this.hippo.method_6113()) {
                return false;
            }
            class_2338 blockPos = this.hippo.method_24515().method_10074();
            class_2680 blockState = this.hippo.method_37908().method_8320(blockPos);
            return blockState.method_27852(class_2246.field_37576) && !this.hippo.isMuddy();
        }

        public void method_6269() {
            this.rollingTime = 400;
            this.fullyRolled = false;
            this.hippo.setRollingInMud(true);
            this.hippo.method_5942().method_6340();
        }

        public void method_6270() {
            this.hippo.setRollingInMud(false);
            if (this.fullyRolled) {
                this.hippo.setMuddy(true);
                this.hippo.mudCooldown = 600;
            }
        }

        public boolean method_6266() {
            class_2338 blockPos = this.hippo.method_24515().method_10074();
            class_2680 blockState = this.hippo.method_37908().method_8320(blockPos);
            if (!blockState.method_27852(class_2246.field_37576)) {
                this.rollingTime = 0;
                return false;
            }
            return this.rollingTime > 0;
        }

        public void method_6268() {
            --this.rollingTime;
            this.hippo.method_5942().method_6340();
            this.hippo.method_5988().method_6231();
            if (this.hippo.isRollingInMud()) {
                this.spawnMudParticles();
                if (this.soundCooldown <= 0) {
                    this.hippo.method_37908().method_43128(null, this.hippo.method_23317(), this.hippo.method_23318(), this.hippo.method_23321(), class_3417.field_37333, this.hippo.method_5634(), 1.0f, 1.0f);
                    this.soundCooldown = 10;
                } else {
                    --this.soundCooldown;
                }
            }
            if (this.rollingTime <= 0) {
                this.fullyRolled = true;
                this.method_6270();
            }
        }

        private void spawnMudParticles() {
            class_1937 class_19372 = this.hippo.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                double centerX = this.hippo.method_23317();
                double centerY = this.hippo.method_23318();
                double centerZ = this.hippo.method_23321();
                class_2388 mudParticleEffect = new class_2388(class_2398.field_11217, class_2246.field_37576.method_9564());
                for (int i = 0; i < 20; ++i) {
                    double offsetX = (this.hippo.method_59922().method_43058() - 0.5) * 1.5;
                    double offsetY = this.hippo.method_59922().method_43058() * 0.5;
                    double offsetZ = (this.hippo.method_59922().method_43058() - 0.5) * 1.5;
                    serverWorld.method_14199((class_2394)mudParticleEffect, centerX + offsetX, centerY + offsetY, centerZ + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
                }
            }
        }
    }
}

