/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import java.util.UUID;
import net.domixcze.domixscreatures.entity.ModEntities;
import net.domixcze.domixscreatures.entity.ai.BabyFollowParentGoal;
import net.domixcze.domixscreatures.entity.ai.SleepGoal;
import net.domixcze.domixscreatures.entity.ai.Sleepy;
import net.domixcze.domixscreatures.entity.ai.SnowLayerable;
import net.domixcze.domixscreatures.entity.client.iguana.IguanaVariants;
import net.domixcze.domixscreatures.util.ModTags;
import net.domixcze.domixscreatures.util.SnowLayerUtil;
import net.minecraft.class_124;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IguanaEntity
extends class_1321
implements GeoEntity,
Sleepy,
SnowLayerable {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int snowTicks = 0;
    private int snowMeltTimer = 0;
    public static final class_2940<Boolean> HAS_SNOW_LAYER = class_2945.method_12791(IguanaEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(IguanaEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SITTING = class_2945.method_12791(IguanaEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SLEEPING = class_2945.method_12791(IguanaEntity.class, (class_2941)class_2943.field_13323);

    public IguanaEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1321.method_26828().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23721, 0.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SleepGoal(this, (class_1308)this, 100, false, true, true, false, 3.0, 500, 700, true, false, true, true, 1));
        this.field_6201.method_6277(0, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1350((class_1321)this, 1.0, 10.0f, 2.0f));
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new BabyFollowParentGoal((class_1429)this, 1.25));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 0.75, 1.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
    }

    public boolean method_5931() {
        return !this.method_6113();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_SNOW_LAYER, (Object)false);
        builder.method_56912(VARIANT, (Object)IguanaVariants.GREEN.getId());
        builder.method_56912(SITTING, (Object)false);
        builder.method_56912(SLEEPING, (Object)false);
    }

    protected class_4048 method_55694(class_4050 pose) {
        if (this.method_6109()) {
            return class_4048.method_18385((float)0.4f, (float)0.3f);
        }
        return this.method_5864().method_18386();
    }

    @Override
    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.method_5942().method_6340();
            class_1309 class_13092 = this.method_35057();
            if (class_13092 instanceof class_1657) {
                class_1657 player = (class_1657)class_13092;
                if (!this.method_24345()) {
                    this.setSit(player, true);
                }
            }
        }
    }

    public IguanaVariants getVariant() {
        return IguanaVariants.byId((Integer)this.field_6011.method_12789(VARIANT));
    }

    public void setVariant(IguanaVariants variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public boolean method_24345() {
        return (Boolean)this.field_6011.method_12789(SITTING);
    }

    public void setSit(class_1657 player, boolean sitting) {
        if (player == this.method_35057()) {
            this.field_6011.method_12778(SITTING, (Object)sitting);
            super.method_24346(sitting);
        }
    }

    @Override
    public boolean hasSnowLayer() {
        return (Boolean)this.field_6011.method_12789(HAS_SNOW_LAYER);
    }

    @Override
    public void setHasSnowLayer(boolean hasSnow) {
        this.field_6011.method_12778(HAS_SNOW_LAYER, (Object)hasSnow);
    }

    @Override
    public int getSnowTicks() {
        return this.snowTicks;
    }

    @Override
    public void setSnowTicks(int ticks) {
        this.snowTicks = ticks;
    }

    @Override
    public int getSnowMeltTimer() {
        return this.snowMeltTimer;
    }

    @Override
    public void setSnowMeltTimer(int timer) {
        this.snowMeltTimer = timer;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source == this.method_48923().method_48822() && this.method_5765()) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        if (this.method_5765()) {
            return false;
        }
        return super.method_5747(fallDistance, damageMultiplier, damageSource);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        entityData = super.method_5943(world, difficulty, spawnReason, entityData);
        double randomValue = world.method_8409().method_43058();
        if (randomValue < 0.01) {
            this.setVariant(IguanaVariants.ALBINO);
        } else if (randomValue < 0.06) {
            this.setVariant(IguanaVariants.MELANISTIC);
        } else if (randomValue < 0.31) {
            this.setVariant(IguanaVariants.BLUE);
        } else {
            this.setVariant(IguanaVariants.GREEN);
        }
        return entityData;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7909() == class_1802.field_17506 && !this.method_6181()) {
            if (this.method_37908().method_8608()) {
                return class_1269.field_21466;
            }
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            if (this.field_5974.method_43048(3) == 0) {
                super.method_6170(player);
                this.field_6189.method_6356();
                this.method_5980(null);
                this.method_37908().method_8421((class_1297)this, (byte)7);
            }
            this.method_5783(class_3417.field_20614, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        if (this.method_6181() && !this.method_37908().method_8608() && itemStack.method_7909() == class_1802.field_8600 && hand == class_1268.field_5808) {
            this.setSit(player, !this.method_24345());
            class_2561 entityName = this.method_5476();
            class_5250 action = class_2561.method_43471((String)(this.method_24345() ? "message.domixs-creatures.action.sitting" : "message.domixs-creatures.action.following"));
            class_5250 message = class_2561.method_43470((String)(entityName.getString() + " ")).method_10852((class_2561)action).method_27693(".").method_27694(style -> style.method_10977(class_124.field_1060));
            player.method_7353((class_2561)message, true);
            return class_1269.field_5811;
        }
        if (this.method_6181() && !this.method_6109() && hand == class_1268.field_5808 && itemStack.method_7960() && !this.method_5765()) {
            if (player.method_7356().method_33133()) {
                if (!this.isPlayerBeingRiddenByIguana(player)) {
                    this.method_5873((class_1297)player, true);
                    return class_1269.field_5812;
                }
                return class_1269.field_5811;
            }
            return class_1269.field_5811;
        }
        if (itemStack.method_31574(class_1802.field_42716) && this.hasSnowLayer()) {
            if (!this.method_37908().field_9236) {
                this.setHasSnowLayer(false);
                this.snowMeltTimer = 0;
                int count = 3 + this.method_37908().field_9229.method_43048(2);
                this.method_5775(new class_1799((class_1935)class_1802.field_8543, count));
            }
            SnowLayerUtil.spawnSnowParticles((class_1309)this);
            this.method_5783(class_3417.field_15165, 1.0f, 1.0f);
            if (!player.method_7337()) {
                itemStack.method_7970(1, (class_1309)player, class_1304.field_6173);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    private boolean isPlayerBeingRiddenByIguana(class_1657 player) {
        for (class_1297 passenger : player.method_5685()) {
            if (!(passenger instanceof IguanaEntity)) continue;
            return true;
        }
        return false;
    }

    public void method_5773() {
        super.method_5773();
        SnowLayerUtil.handleSnowLayerTick((class_1309)this, this);
    }

    public void method_5842() {
        class_1297 vehicle;
        super.method_5842();
        if (this.method_5765() && (vehicle = this.method_5854()) instanceof class_1657) {
            class_1657 player = (class_1657)vehicle;
            float bodyYaw = player.field_6283;
            this.method_5847(bodyYaw);
            this.method_5636(bodyYaw);
            if (player.method_5869()) {
                this.method_5848();
            }
            if (!player.method_7356().method_33133()) {
                this.method_5848();
            }
            if (player.method_5715() && player.method_24828()) {
                this.method_5848();
            }
            if (player.method_6128()) {
                this.method_5848();
            }
            if (player.method_20448()) {
                this.method_5848();
            }
            float yaw = bodyYaw;
            float offsetX = 0.4f;
            float offsetY = -0.2f;
            float offsetZ = -0.1f;
            yaw = (float)Math.toRadians(yaw);
            double newX = player.method_23317() + (double)offsetX * Math.cos(yaw) - (double)offsetZ * Math.sin(yaw);
            double newZ = player.method_23321() + (double)offsetZ * Math.cos(yaw) + (double)offsetX * Math.sin(yaw);
            double newY = player.method_23318() + (double)offsetY + (double)player.method_5751();
            this.method_5814(newX, newY, newZ);
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("HasSnowLayer", this.hasSnowLayer());
        nbt.method_10569("SnowTicks", this.snowTicks);
        nbt.method_10569("SnowMeltTimer", this.snowMeltTimer);
        nbt.method_10556("isSitting", ((Boolean)this.field_6011.method_12789(SITTING)).booleanValue());
        nbt.method_10556("Sleeping", this.method_6113());
        nbt.method_10569("Variant", this.getVariant().getId());
        if (this.method_35057() != null) {
            nbt.method_25927("Owner", this.method_6139());
        }
    }

    public void method_5749(class_2487 nbt) {
        UUID ownerUUID;
        super.method_5749(nbt);
        this.setHasSnowLayer(nbt.method_10577("HasSnowLayer"));
        this.snowTicks = nbt.method_10550("SnowTicks");
        this.snowMeltTimer = nbt.method_10550("SnowMeltTimer");
        this.field_6011.method_12778(SITTING, (Object)nbt.method_10577("isSitting"));
        this.setSleeping(nbt.method_10577("Sleeping"));
        this.setVariant(IguanaVariants.byId(nbt.method_10550("Variant")));
        UUID uUID = ownerUUID = nbt.method_10545("Owner") ? nbt.method_25926("Owner") : null;
        if (ownerUUID != null) {
            this.method_6174(ownerUUID);
        }
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ModTags.Items.IGUANA_FOR_BREEDING);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "shoulder_controller", 5, this::shoulderPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "water_controller", 5, this::waterPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "sleep_controller", 5, this::sleepPredicate));
    }

    private <T extends GeoAnimatable> PlayState landPredicate(AnimationState<T> state) {
        if (this.method_18798().method_37268() > 1.0E-9) {
            if (this.method_6109()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_iguana.walk", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.iguana.walk", Animation.LoopType.LOOP));
            }
        } else if (this.method_24345() && !this.method_6113()) {
            if (this.method_6109()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_iguana.sit", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.iguana.sit", Animation.LoopType.LOOP));
            }
        } else if (this.method_6109()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.baby_iguana.idle", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.iguana.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState shoulderPredicate(AnimationState<T> state) {
        if (this.method_5765()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.iguana.shoulder", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <T extends GeoAnimatable> PlayState sleepPredicate(AnimationState<T> state) {
        if (this.method_6113()) {
            if (this.method_6109()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_iguana.sleep", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.iguana.sleep", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <T extends GeoAnimatable> PlayState waterPredicate(AnimationState<T> state) {
        if (!this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_5799()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_iguana.swim", Animation.LoopType.LOOP));
            }
        } else if (this.method_5799()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.iguana.swim", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        IguanaEntity baby = (IguanaEntity)ModEntities.IGUANA.method_5883((class_1937)world);
        if (baby != null) {
            IguanaEntity parent1 = this;
            IguanaEntity parent2 = (IguanaEntity)entity;
            if (parent2 != null) {
                if (world.method_8409().method_43056()) {
                    baby.setVariant(parent1.getVariant());
                } else {
                    baby.setVariant(parent2.getVariant());
                }
            } else {
                double randomValue = world.method_8409().method_43058();
                if (randomValue < 0.01) {
                    baby.setVariant(IguanaVariants.ALBINO);
                } else if (randomValue < 0.06) {
                    baby.setVariant(IguanaVariants.MELANISTIC);
                } else if (randomValue < 0.31) {
                    baby.setVariant(IguanaVariants.BLUE);
                } else {
                    baby.setVariant(IguanaVariants.GREEN);
                }
            }
        }
        return baby;
    }
}

