/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import java.util.EnumSet;
import java.util.Optional;
import net.domixcze.domixscreatures.block.ModBlocks;
import net.domixcze.domixscreatures.block.custom.MolehillBlock;
import net.domixcze.domixscreatures.block.entity.MolehillBlockEntity;
import net.domixcze.domixscreatures.entity.ModEntities;
import net.domixcze.domixscreatures.entity.ai.BabyFollowParentGoal;
import net.domixcze.domixscreatures.entity.ai.MoleMeleeAttackGoal;
import net.domixcze.domixscreatures.entity.ai.SnowLayerable;
import net.domixcze.domixscreatures.entity.client.mole.MoleVariants;
import net.domixcze.domixscreatures.entity.custom.WormEntity;
import net.domixcze.domixscreatures.util.ModTags;
import net.domixcze.domixscreatures.util.SnowLayerUtil;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MoleEntity
extends class_1429
implements GeoEntity,
SnowLayerable {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int snowTicks = 0;
    private int snowMeltTimer = 0;
    public static final class_2940<Boolean> HAS_SNOW_LAYER = class_2945.method_12791(MoleEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(MoleEntity.class, (class_2941)class_2943.field_13327);
    private boolean insideHill = false;
    private class_2338 currentHillPos;
    private int cooldown = 0;

    public MoleEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23721, 2.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(1, (class_1352)new MoleMeleeAttackGoal(this, 1.0, true));
        this.field_6201.method_6277(2, (class_1352)new MoleEntityAvoidanceGoal(this));
        this.field_6201.method_6277(3, (class_1352)new BabyFollowParentGoal(this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 0.75, 1.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, WormEntity.class, true));
    }

    public boolean method_5931() {
        return false;
    }

    public int method_5945() {
        return 1;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ModTags.Items.MOLE_FOR_BREEDING);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_SNOW_LAYER, (Object)false);
        builder.method_56912(VARIANT, (Object)MoleVariants.BLACK.getId());
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("HasSnowLayer", this.hasSnowLayer());
        nbt.method_10569("SnowTicks", this.snowTicks);
        nbt.method_10569("SnowMeltTimer", this.snowMeltTimer);
        nbt.method_10569("Variant", this.getVariant().getId());
        nbt.method_10556("InsideHill", this.insideHill);
        if (this.currentHillPos != null) {
            nbt.method_10544("CurrentHillPos", this.currentHillPos.method_10063());
        }
        nbt.method_10569("Cooldown", this.cooldown);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setHasSnowLayer(nbt.method_10577("HasSnowLayer"));
        this.snowTicks = nbt.method_10550("SnowTicks");
        this.snowMeltTimer = nbt.method_10550("SnowMeltTimer");
        this.setVariant(MoleVariants.byId(nbt.method_10550("Variant")));
        this.insideHill = nbt.method_10577("InsideHill");
        if (nbt.method_10545("CurrentHillPos")) {
            this.currentHillPos = class_2338.method_10092((long)nbt.method_10537("CurrentHillPos"));
        }
        if (nbt.method_10545("Cooldown")) {
            this.cooldown = nbt.method_10550("Cooldown");
        }
    }

    @Override
    public boolean hasSnowLayer() {
        return (Boolean)this.field_6011.method_12789(HAS_SNOW_LAYER);
    }

    @Override
    public void setHasSnowLayer(boolean hasSnow) {
        this.field_6011.method_12778(HAS_SNOW_LAYER, (Object)hasSnow);
    }

    @Override
    public int getSnowTicks() {
        return this.snowTicks;
    }

    @Override
    public void setSnowTicks(int ticks) {
        this.snowTicks = ticks;
    }

    @Override
    public int getSnowMeltTimer() {
        return this.snowMeltTimer;
    }

    @Override
    public void setSnowMeltTimer(int timer) {
        this.snowMeltTimer = timer;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_42716) && this.hasSnowLayer()) {
            if (!this.method_37908().field_9236) {
                this.setHasSnowLayer(false);
                this.snowMeltTimer = 0;
                int count = 3 + this.method_37908().field_9229.method_43048(2);
                this.method_5775(new class_1799((class_1935)class_1802.field_8543, count));
            }
            SnowLayerUtil.spawnSnowParticles((class_1309)this);
            this.method_5783(class_3417.field_15165, 1.0f, 1.0f);
            if (!player.method_7337()) {
                itemStack.method_7970(1, (class_1309)player, class_1304.field_6173);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public MoleVariants getVariant() {
        return MoleVariants.byId((Integer)this.field_6011.method_12789(VARIANT));
    }

    public void setVariant(MoleVariants variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        entityData = super.method_5943(world, difficulty, spawnReason, entityData);
        if (world.method_8409().method_43058() < 0.05) {
            this.setVariant(MoleVariants.ALBINO);
        } else {
            this.setVariant(MoleVariants.BLACK);
        }
        return entityData;
    }

    protected class_4048 method_55694(class_4050 pose) {
        if (this.method_6109()) {
            return class_4048.method_18385((float)0.3f, (float)0.2f);
        }
        return this.method_5864().method_18386();
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        MoleEntity baby = (MoleEntity)ModEntities.MOLE.method_5883((class_1937)world);
        if (baby != null) {
            MoleEntity parent1 = this;
            MoleEntity parent2 = (MoleEntity)entity;
            if (parent1.getVariant() == MoleVariants.ALBINO && parent2.getVariant() == MoleVariants.ALBINO) {
                baby.setVariant(MoleVariants.ALBINO);
            } else if (parent1.getVariant() == MoleVariants.ALBINO || parent2.getVariant() == MoleVariants.ALBINO) {
                double chance = 0.25;
                if (world.method_8409().method_43058() < chance) {
                    baby.setVariant(MoleVariants.ALBINO);
                } else {
                    baby.setVariant(MoleVariants.BLACK);
                }
            } else {
                double chance = 0.01;
                if (world.method_8409().method_43058() < chance) {
                    baby.setVariant(MoleVariants.ALBINO);
                } else {
                    baby.setVariant(MoleVariants.BLACK);
                }
            }
        }
        return baby;
    }

    public boolean isInsideHill() {
        return this.insideHill;
    }

    public void enterHill(MolehillBlockEntity hill) {
        this.insideHill = true;
        this.currentHillPos = hill.method_11016();
        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15211, class_3419.field_15245, 1.0f, 0.8f + this.field_5974.method_43057() * 0.4f);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public void method_5773() {
        super.method_5773();
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        SnowLayerUtil.handleSnowLayerTick((class_1309)this, this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "water_controller", 5, this::waterPredicate));
    }

    private <T extends GeoAnimatable> PlayState landPredicate(AnimationState<T> state) {
        if (this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.mole.walk", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.mole.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState waterPredicate(AnimationState<T> state) {
        if (!this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.mole.swim", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.mole.idle_swim", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    public static class MoleEntityAvoidanceGoal
    extends class_1352 {
        private final MoleEntity mole;
        private final class_1937 world;
        private static final double DETECTION_RADIUS = 5.0;

        public MoleEntityAvoidanceGoal(MoleEntity mole) {
            this.mole = mole;
            this.world = mole.method_37908();
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            boolean otherAnimalThreatNearby = !this.world.method_8390(class_1429.class, this.mole.method_5829().method_1014(5.0), entity -> entity != this.mole && !(entity instanceof MoleEntity) && !(entity instanceof WormEntity)).isEmpty();
            boolean playerThreatNearby = !this.world.method_8390(class_1657.class, this.mole.method_5829().method_1014(5.0), player -> !player.method_7325() && !player.method_7337()).isEmpty();
            boolean threatNearby = otherAnimalThreatNearby || playerThreatNearby;
            return threatNearby && !this.mole.isInsideHill() && this.mole.getCooldown() <= 0;
        }

        public void method_6268() {
            class_2338 currentPos = this.mole.method_24515();
            Optional<MolehillBlockEntity> nearbyHill = MolehillBlockEntity.findNearbyUnoccupiedHill((class_3218)this.world, currentPos);
            if (nearbyHill.isPresent()) {
                this.mole.method_5942().method_6337((double)nearbyHill.get().method_11016().method_10263(), (double)nearbyHill.get().method_11016().method_10264(), (double)nearbyHill.get().method_11016().method_10260(), 1.0);
                if (this.mole.method_24515().method_19771((class_2382)nearbyHill.get().method_11016(), 2.0)) {
                    this.mole.enterHill(nearbyHill.get());
                    this.world.method_8501(nearbyHill.get().method_11016(), (class_2680)this.world.method_8320(nearbyHill.get().method_11016()).method_11657((class_2769)MolehillBlock.OCCUPIED, (Comparable)Boolean.valueOf(true)));
                    nearbyHill.get().storeMoleData(this.mole.method_5647(new class_2487()));
                    this.mole.method_31472();
                }
            } else {
                this.createNewMolehillIfPossible(currentPos);
            }
        }

        private void createNewMolehillIfPossible(class_2338 currentPos) {
            class_2680 currentState = this.world.method_8320(currentPos);
            class_2338 belowPos = currentPos.method_10074();
            class_2680 belowState = this.world.method_8320(belowPos);
            if (currentState.method_27852(ModBlocks.MOLEHILL_BLOCK)) {
                return;
            }
            if (this.mole.method_24828() && !belowState.method_27852(ModBlocks.MOLEHILL_BLOCK) && (belowState.method_27852(class_2246.field_10219) || belowState.method_27852(class_2246.field_10566))) {
                this.world.method_8501(currentPos, ModBlocks.MOLEHILL_BLOCK.method_9564());
                MolehillBlockEntity moleHillEntity = (MolehillBlockEntity)this.world.method_8321(currentPos);
                if (moleHillEntity != null) {
                    this.mole.enterHill(moleHillEntity);
                    this.world.method_8501(currentPos, (class_2680)this.world.method_8320(currentPos).method_11657((class_2769)MolehillBlock.OCCUPIED, (Comparable)Boolean.valueOf(true)));
                    moleHillEntity.storeMoleData(this.mole.method_5647(new class_2487()));
                    this.mole.method_31472();
                }
            }
        }
    }
}

