/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import java.util.UUID;
import net.domixcze.domixscreatures.entity.client.mud_golem.MudGolemVariants;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1394;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MudGolemEntity
extends class_1321
implements GeoEntity {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Boolean> SITTING = class_2945.method_12791(MudGolemEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(MudGolemEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> WET_STATE = class_2945.method_12791(MudGolemEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> HAS_SNOW_LAYER = class_2945.method_12791(MudGolemEntity.class, (class_2941)class_2943.field_13323);
    private int snowTicks = 0;
    private int snowMeltTimer = 0;
    private static final int WET_TO_DRY_TIME = 400;
    private static final int DRY_TO_WET_TIME = 400;
    private int transitionTimer = 0;
    private boolean isWet = false;

    public MudGolemEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1321.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23719, (double)0.2f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(1, (class_1352)new class_1350((class_1321)this, 1.0, 10.0f, 2.0f));
        this.field_6201.method_6277(2, (class_1352)new class_1394((class_1314)this, 0.75, 1.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_SNOW_LAYER, (Object)false);
        builder.method_56912(SITTING, (Object)false);
        builder.method_56912(VARIANT, (Object)MudGolemVariants.NORMAL.getId());
        builder.method_56912(WET_STATE, (Object)false);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "water_controller", 5, this::waterPredicate));
    }

    private <T extends GeoAnimatable> PlayState landPredicate(AnimationState<T> state) {
        if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.mud_golem.walk", Animation.LoopType.LOOP));
        } else if (this.method_24345()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.mud_golem.sit", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.mud_golem.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState waterPredicate(AnimationState<T> state) {
        if (!this.method_5799()) {
            return PlayState.STOP;
        }
        state.getController().setAnimation(RawAnimation.begin().then("animation.mud_golem.swim", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.hasSnowLayer() && this.isBeingSnowedOn()) {
            ++this.snowTicks;
            if (this.snowTicks >= 600) {
                this.setHasSnowLayer(true);
                this.snowTicks = 0;
            }
        }
        if ((this.method_5799() || !this.isInSnowyBiome()) && this.hasSnowLayer()) {
            ++this.snowMeltTimer;
            if (this.snowMeltTimer >= 200) {
                this.setHasSnowLayer(false);
                this.snowMeltTimer = 0;
            }
        }
        if (this.method_5721()) {
            if (!this.isWet) {
                ++this.transitionTimer;
                if (this.transitionTimer >= 400) {
                    this.setWet(true);
                }
            } else {
                this.transitionTimer = 0;
            }
        } else if (this.isWet) {
            ++this.transitionTimer;
            if (this.transitionTimer >= 400) {
                this.setWet(false);
            }
        } else {
            this.transitionTimer = 0;
        }
    }

    private void setWet(boolean wet) {
        this.isWet = wet;
        this.transitionTimer = 0;
        this.method_5841().method_12778(WET_STATE, (Object)wet);
        if (wet) {
            this.method_5996(class_5134.field_23716).method_6192(20.0);
            this.method_5996(class_5134.field_23721).method_6192(2.0);
        } else {
            this.method_5996(class_5134.field_23716).method_6192(10.0);
            this.method_5996(class_5134.field_23721).method_6192(5.0);
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7909() == class_1802.field_8317 && !this.method_6181()) {
            if (this.method_37908().method_8608()) {
                return class_1269.field_21466;
            }
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            if (this.field_5974.method_43048(3) == 0) {
                super.method_6170(player);
                this.field_6189.method_6356();
                this.method_5980(null);
                this.method_37908().method_8421((class_1297)this, (byte)7);
            }
            this.method_5783(class_3417.field_20614, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        if (this.method_6181() && !this.method_37908().method_8608() && itemStack.method_7909() == class_1802.field_8600 && hand == class_1268.field_5808) {
            this.setSit(player, !this.method_24345());
            class_2561 entityName = this.method_5476();
            class_5250 action = class_2561.method_43471((String)(this.method_24345() ? "message.domixs-creatures.action.sitting" : "message.domixs-creatures.action.following"));
            class_5250 message = class_2561.method_43470((String)(entityName.getString() + " ")).method_10852((class_2561)action).method_27693(".").method_27694(style -> style.method_10977(class_124.field_1060));
            player.method_7353((class_2561)message, true);
            return class_1269.field_5811;
        }
        if (itemStack.method_31573(class_3489.field_42615) && this.hasSnowLayer()) {
            this.setHasSnowLayer(false);
            this.snowMeltTimer = 0;
            if (!player.method_7337()) {
                itemStack.method_7970(1, (class_1309)player, class_1304.field_6173);
            }
            this.method_5783(class_3417.field_15165, 1.0f, 1.0f);
            if (!this.method_37908().field_9236) {
                int count = 3 + this.method_37908().field_9229.method_43048(2);
                this.method_5775(new class_1799((class_1935)class_1802.field_8543, count));
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public boolean method_24345() {
        return (Boolean)this.field_6011.method_12789(SITTING);
    }

    public void setSit(class_1657 player, boolean sitting) {
        if (player == this.method_35057()) {
            this.field_6011.method_12778(SITTING, (Object)sitting);
            super.method_24346(sitting);
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("isSitting", ((Boolean)this.field_6011.method_12789(SITTING)).booleanValue());
        nbt.method_10569("Variant", this.getVariant().ordinal());
        nbt.method_10556("IsWet", this.isWet);
        if (this.method_35057() != null) {
            nbt.method_25927("Owner", this.method_6139());
        }
        nbt.method_10556("HasSnowLayer", this.hasSnowLayer());
        nbt.method_10569("SnowTicks", this.snowTicks);
        nbt.method_10569("SnowMeltTimer", this.snowMeltTimer);
    }

    public void method_5749(class_2487 nbt) {
        UUID ownerUUID;
        super.method_5749(nbt);
        this.field_6011.method_12778(SITTING, (Object)nbt.method_10577("isSitting"));
        this.setVariant(MudGolemVariants.values()[nbt.method_10550("Variant")]);
        this.setWet(nbt.method_10577("IsWet"));
        UUID uUID = ownerUUID = nbt.method_10545("Owner") ? nbt.method_25926("Owner") : null;
        if (ownerUUID != null) {
            this.method_6174(ownerUUID);
        }
        this.setHasSnowLayer(nbt.method_10577("HasSnowLayer"));
        this.snowTicks = nbt.method_10550("SnowTicks");
        this.snowMeltTimer = nbt.method_10550("SnowMeltTimer");
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public boolean isBeingSnowedOn() {
        class_2338 blockPos = this.method_24515();
        return this.method_37908().method_8419() && this.isInSnowyBiome() && (this.hasSnow(blockPos) || this.hasSnow(class_2338.method_49637((double)blockPos.method_10263(), (double)this.method_5829().field_1325, (double)blockPos.method_10260())));
    }

    public boolean hasSnow(class_2338 pos) {
        if (!this.method_37908().method_8419()) {
            return false;
        }
        if (!this.method_37908().method_8311(pos)) {
            return false;
        }
        if (this.method_37908().method_8598(class_2902.class_2903.field_13197, pos).method_10264() > pos.method_10264()) {
            return false;
        }
        class_1959 biome = (class_1959)this.method_37908().method_23753(pos).comp_349();
        return biome.method_48162(pos) == class_1959.class_1963.field_9383;
    }

    public boolean isInSnowyBiome() {
        class_2338 pos = this.method_24515();
        class_6880 biomeEntry = this.method_37908().method_23753(pos);
        class_1959 biome = (class_1959)biomeEntry.comp_349();
        return biome.method_48162(pos) == class_1959.class_1963.field_9383;
    }

    public boolean hasSnowLayer() {
        return (Boolean)this.field_6011.method_12789(HAS_SNOW_LAYER);
    }

    public void setHasSnowLayer(boolean hasSnow) {
        this.field_6011.method_12778(HAS_SNOW_LAYER, (Object)hasSnow);
    }

    public MudGolemVariants getVariant() {
        return MudGolemVariants.values()[(Integer)this.field_6011.method_12789(VARIANT)];
    }

    public void setVariant(MudGolemVariants variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.ordinal());
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    protected class_3414 method_6011(class_1282 source) {
        return (Boolean)this.method_5841().method_12789(WET_STATE) != false ? class_3417.field_37329 : class_3417.field_37334;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        class_3414 stepSound = (Boolean)this.method_5841().method_12789(WET_STATE) != false ? class_3417.field_37333 : class_3417.field_37338;
        this.method_5783(stepSound, 0.15f, 1.0f);
    }
}

