/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.domixcze.domixscreatures.entity.ModEntities;
import net.domixcze.domixscreatures.entity.custom.VineEntity;
import net.domixcze.domixscreatures.sound.ModSounds;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ShamanEntity
extends class_1588
implements GeoEntity {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int vineAbilityCooldown = 0;
    private int poisonAbilityCooldown = 0;
    private final Set<UUID> spawnedVines = new HashSet<UUID>();

    public ShamanEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23716, 250.0).method_26868(class_5134.field_23719, 0.2);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new ShamanCombatGoal(this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new PoisonCloudGoal(this));
        this.field_6201.method_6277(4, (class_1352)new VineTrapGoal(this));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("VineAbilityCooldown", this.vineAbilityCooldown);
        nbt.method_10569("PoisonAbilityCooldown", this.poisonAbilityCooldown);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.vineAbilityCooldown = nbt.method_10550("VineAbilityCooldown");
        this.poisonAbilityCooldown = nbt.method_10550("PoisonAbilityCooldown");
    }

    public void method_5982() {
    }

    public void method_5773() {
        super.method_5773();
        if (this.vineAbilityCooldown > 0) {
            --this.vineAbilityCooldown;
        }
        if (this.poisonAbilityCooldown > 0) {
            --this.poisonAbilityCooldown;
        }
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
        this.clearVines();
    }

    public void clearVines() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        for (UUID id : this.spawnedVines) {
            class_1297 vine = serverWorld.method_14190(id);
            if (vine == null) continue;
            vine.method_31472();
        }
        this.spawnedVines.clear();
    }

    public boolean areVinesAlive() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        for (UUID vineId : this.spawnedVines) {
            class_1297 vine = serverWorld.method_14190(vineId);
            if (vine == null || !vine.method_5805()) continue;
            return true;
        }
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source == this.method_48923().method_48831()) {
            return false;
        }
        if (this.areVinesAlive()) {
            this.method_37908().method_8396(null, this.method_24515(), ModSounds.VINE_HURT, class_3419.field_15251, 1.0f, 0.8f + this.field_5974.method_43057() * 0.4f);
            return false;
        }
        return super.method_5643(source, amount);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate));
    }

    private <T extends GeoAnimatable> PlayState landPredicate(AnimationState<T> state) {
        if (this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.shaman.walk", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.shaman.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    protected class_3414 method_5994() {
        return class_3417.field_14782;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15111;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14599;
    }

    public static class ShamanCombatGoal
    extends class_1352 {
        private final ShamanEntity shaman;
        private class_1309 target;
        private final double speed;
        private int repositionCooldown;

        public ShamanCombatGoal(ShamanEntity shaman, double speed) {
            this.shaman = shaman;
            this.speed = speed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            this.target = this.shaman.method_5968();
            return this.target != null && this.target.method_5805();
        }

        public void method_6269() {
            this.repositionCooldown = 0;
        }

        public void method_6268() {
            if (this.target == null) {
                return;
            }
            double distance = this.shaman.method_5739((class_1297)this.target);
            this.shaman.method_5988().method_6226((class_1297)this.target, 30.0f, 30.0f);
            if (this.repositionCooldown-- > 0) {
                return;
            }
            this.repositionCooldown = 40;
            if (distance < 4.0) {
                this.moveAwayFromTarget();
            } else if (distance > 8.0) {
                this.moveTowardsTarget();
            }
        }

        private void moveAwayFromTarget() {
            class_243 dir = this.shaman.method_19538().method_1020(this.target.method_19538()).method_1029().method_1021(3.0);
            this.shaman.method_5942().method_6337(this.shaman.method_23317() + dir.field_1352, this.shaman.method_23318(), this.shaman.method_23321() + dir.field_1350, this.speed);
        }

        private void moveTowardsTarget() {
            this.shaman.method_5942().method_6337(this.target.method_23317(), this.target.method_23318(), this.target.method_23321(), this.speed);
        }
    }

    public class PoisonCloudGoal
    extends class_1352 {
        final ShamanEntity shaman;

        PoisonCloudGoal(ShamanEntity shaman) {
            this.shaman = shaman;
        }

        public boolean method_6264() {
            return this.shaman.poisonAbilityCooldown == 0 && ShamanEntity.this.method_5968() != null;
        }

        public void method_6269() {
            class_1295 cloud = new class_1295(ShamanEntity.this.method_37908(), ShamanEntity.this.method_23317(), ShamanEntity.this.method_23318(), ShamanEntity.this.method_23321());
            cloud.method_5610(new class_1293(class_1294.field_5899, 200, 0));
            cloud.method_5603(3.0f);
            ShamanEntity.this.method_37908().method_8649((class_1297)cloud);
            this.shaman.method_6092(new class_1293(class_1294.field_5924, 200, 0));
            this.shaman.method_6092(new class_1293(class_1294.field_5907, 200, 1));
            this.shaman.method_37908().method_8396(null, this.shaman.method_24515(), class_3417.field_15058, class_3419.field_15251, 1.0f, 1.0f);
            this.shaman.poisonAbilityCooldown = 400;
        }
    }

    public class VineTrapGoal
    extends class_1352 {
        private final ShamanEntity shaman;

        VineTrapGoal(ShamanEntity shaman) {
            this.shaman = shaman;
        }

        public boolean method_6264() {
            return this.shaman.vineAbilityCooldown == 0 && ShamanEntity.this.method_5968() != null;
        }

        public void method_6269() {
            class_1937 class_19372 = this.shaman.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                return;
            }
            class_3218 serverWorld = (class_3218)class_19372;
            class_2338 shamanPos = this.shaman.method_24515();
            HashSet<class_2338> chosenPositions = new HashSet<class_2338>();
            for (int i = 0; i < 2; ++i) {
                VineEntity vine;
                class_2338 vinePos = this.getRandomSpreadPosition(shamanPos, chosenPositions);
                if (vinePos == null || (vine = (VineEntity)ModEntities.VINE.method_5883((class_1937)serverWorld)) == null) continue;
                vine.method_5808((double)vinePos.method_10263() + 0.5, vinePos.method_10264() + 1, (double)vinePos.method_10260() + 0.5, 0.0f, 0.0f);
                serverWorld.method_8649((class_1297)vine);
                this.shaman.spawnedVines.add(vine.method_5667());
            }
            this.shaman.vineAbilityCooldown = 400;
        }

        private class_2338 getRandomSpreadPosition(class_2338 center, Set<class_2338> alreadyChosen) {
            for (int attempt = 0; attempt < 10; ++attempt) {
                boolean tooClose;
                int offsetZ;
                double angle = ShamanEntity.this.field_5974.method_43058() * Math.PI * 2.0;
                double distance = 4.0 + ShamanEntity.this.field_5974.method_43058() * 2.0;
                int offsetX = (int)Math.round(Math.cos(angle) * distance);
                class_2338 candidate = center.method_10069(offsetX, 0, offsetZ = (int)Math.round(Math.sin(angle) * distance));
                if (!this.isPositionClear(candidate) || (tooClose = alreadyChosen.stream().anyMatch(existing -> existing.method_19771((class_2382)candidate, 3.0)))) continue;
                alreadyChosen.add(candidate);
                return candidate;
            }
            return null;
        }

        private boolean isPositionClear(class_2338 position) {
            return !ShamanEntity.this.method_37908().method_8320(position).method_51367();
        }
    }
}

