/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import java.util.EnumSet;
import net.domixcze.domixscreatures.entity.ModEntities;
import net.domixcze.domixscreatures.entity.ai.BabyFollowParentGoal;
import net.domixcze.domixscreatures.entity.ai.ProtectBabiesGoal;
import net.domixcze.domixscreatures.entity.ai.SleepGoal;
import net.domixcze.domixscreatures.entity.ai.Sleepy;
import net.domixcze.domixscreatures.entity.ai.SnowLayerable;
import net.domixcze.domixscreatures.entity.ai.SunBearMeleeAttackGoal;
import net.domixcze.domixscreatures.entity.custom.CaterpillarEntity;
import net.domixcze.domixscreatures.entity.custom.DeerEntity;
import net.domixcze.domixscreatures.util.ModTags;
import net.domixcze.domixscreatures.util.SnowLayerUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8779;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SunBearEntity
extends class_1429
implements GeoEntity,
Sleepy,
SnowLayerable {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final class_2940<Boolean> HAS_SNOW_LAYER = class_2945.method_12791(SunBearEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SLEEPING = class_2945.method_12791(SunBearEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_EATING = class_2945.method_12791(SunBearEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_HONEYED = class_2945.method_12791(SunBearEntity.class, (class_2941)class_2943.field_13323);
    private static final class_4048 BABY_DIMENSIONS = class_4048.method_18385((float)0.7f, (float)0.7f);
    private static final class_4048 ADULT_DIMENSIONS = class_4048.method_18385((float)1.2f, (float)1.3f);
    private static final class_4048 SLEEPING_BABY_DIMENSIONS = class_4048.method_18385((float)0.7f, (float)0.5f);
    private static final class_4048 SLEEPING_ADULT_DIMENSIONS = class_4048.method_18385((float)1.2f, (float)0.8f);
    private int snowTicks = 0;
    private int snowMeltTimer = 0;
    private int eatingTimer = 0;
    private final int MAX_EATING_TIMER = 200;
    private int honeyTimer = 0;

    public SunBearEntity(class_1299<? extends class_1429> type, class_1937 world) {
        super(type, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23719, 0.2);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SleepGoal(this, (class_1308)this, 120, false, true, false, false, 5.0, 600, 800, false, false, true, true, 2));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new SunBearEatGoal(this));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new SunBearMeleeAttackGoal(this, 1.0, true));
        this.field_6201.method_6277(4, (class_1352)new BabyFollowParentGoal(this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.75));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, new ProtectBabiesGoal<SunBearEntity>(this, SunBearEntity.class, 8.0));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DeerEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, CaterpillarEntity.class, true));
    }

    public boolean method_5931() {
        return !this.method_6113();
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_20414) && !this.isHoneyed() && !this.method_6109() && !this.method_6113()) {
            class_3222 serverPlayer;
            MinecraftServer server;
            this.setEating(true);
            this.eatingTimer = 0;
            this.setHoneyed(true);
            this.method_5942().method_6340();
            if (!player.method_7337()) {
                itemStack.method_7934(1);
            }
            if (!this.method_37908().method_8608() && player instanceof class_3222 && (server = (serverPlayer = (class_3222)player).method_5682()) != null) {
                class_2960 advId = class_2960.method_60655((String)"domixs-creatures", (String)"domixs-creatures/a_bears_necessity");
                class_8779 entry = server.method_3851().method_12896(advId);
                if (entry != null) {
                    String criterion = "gave_honey_to_bear";
                    if (!serverPlayer.method_14236().method_12882(entry).method_740()) {
                        serverPlayer.method_14236().method_12878(entry, criterion);
                    }
                }
            }
            return class_1269.field_5812;
        }
        if (itemStack.method_31574(class_1802.field_42716) && this.hasSnowLayer()) {
            if (!this.method_37908().field_9236) {
                this.setHasSnowLayer(false);
                this.snowMeltTimer = 0;
                int count = 3 + this.method_37908().field_9229.method_43048(2);
                this.method_5775(new class_1799((class_1935)class_1802.field_8543, count));
            }
            SnowLayerUtil.spawnSnowParticles((class_1309)this);
            this.method_5783(class_3417.field_15165, 1.0f, 1.0f);
            if (!player.method_7337()) {
                itemStack.method_7970(1, (class_1309)player, class_1304.field_6173);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    @Override
    public boolean hasSnowLayer() {
        return (Boolean)this.field_6011.method_12789(HAS_SNOW_LAYER);
    }

    @Override
    public void setHasSnowLayer(boolean hasSnow) {
        this.field_6011.method_12778(HAS_SNOW_LAYER, (Object)hasSnow);
    }

    @Override
    public int getSnowTicks() {
        return this.snowTicks;
    }

    @Override
    public void setSnowTicks(int ticks) {
        this.snowTicks = ticks;
    }

    @Override
    public int getSnowMeltTimer() {
        return this.snowMeltTimer;
    }

    @Override
    public void setSnowMeltTimer(int timer) {
        this.snowMeltTimer = timer;
    }

    @Override
    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.method_5942().method_6340();
        }
    }

    public boolean isEating() {
        return (Boolean)this.field_6011.method_12789(IS_EATING);
    }

    public void setEating(boolean eating) {
        this.field_6011.method_12778(IS_EATING, (Object)eating);
    }

    public boolean isHoneyed() {
        return (Boolean)this.field_6011.method_12789(IS_HONEYED);
    }

    public void setHoneyed(boolean honeyed) {
        this.field_6011.method_12778(IS_HONEYED, (Object)honeyed);
    }

    public void method_6005(double strength, double x, double z) {
        super.method_6005(strength * 0.1, x, z);
    }

    public boolean method_5810() {
        return false;
    }

    public void method_5773() {
        super.method_5773();
        if (this.isEating()) {
            ++this.eatingTimer;
            if (this.eatingTimer >= 200) {
                this.setEating(false);
                this.eatingTimer = 0;
                this.honeyTimer = 6000;
            }
        }
        if (this.honeyTimer > 0) {
            --this.honeyTimer;
            if (this.honeyTimer == 0 && this.isHoneyed()) {
                this.setHoneyed(false);
            }
        }
        SnowLayerUtil.handleSnowLayerTick((class_1309)this, this);
    }

    public void method_5674(class_2940<?> data) {
        if (SLEEPING.equals(data)) {
            this.method_18382();
        }
        super.method_5674(data);
    }

    public class_4048 method_55694(class_4050 pose) {
        return this.getCustomDimensions(pose);
    }

    private class_4048 getCustomDimensions(class_4050 pose) {
        if (this.method_6113()) {
            return this.method_6109() ? SLEEPING_BABY_DIMENSIONS : SLEEPING_ADULT_DIMENSIONS;
        }
        return this.method_6109() ? BABY_DIMENSIONS : ADULT_DIMENSIONS;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_SNOW_LAYER, (Object)false);
        builder.method_56912(SLEEPING, (Object)false);
        builder.method_56912(IS_EATING, (Object)false);
        builder.method_56912(IS_HONEYED, (Object)false);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("HasSnowLayer", this.hasSnowLayer());
        nbt.method_10569("SnowTicks", this.snowTicks);
        nbt.method_10569("SnowMeltTimer", this.snowMeltTimer);
        nbt.method_10556("Sleeping", this.method_6113());
        nbt.method_10556("IsEating", this.isEating());
        nbt.method_10569("EatingTimer", this.eatingTimer);
        nbt.method_10556("IsHoneyed", this.isHoneyed());
        nbt.method_10569("HoneyTimer", this.honeyTimer);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setHasSnowLayer(nbt.method_10577("HasSnowLayer"));
        this.snowTicks = nbt.method_10550("SnowTicks");
        this.snowMeltTimer = nbt.method_10550("SnowMeltTimer");
        this.setSleeping(nbt.method_10577("Sleeping"));
        this.setEating(nbt.method_10577("IsEating"));
        this.eatingTimer = nbt.method_10550("EatingTimer");
        this.setHoneyed(nbt.method_10577("IsHoneyed"));
        this.honeyTimer = nbt.method_10550("HoneyTimer");
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ModTags.Items.SUN_BEAR_FOR_BREEDING);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)ModEntities.SUN_BEAR.method_5883((class_1937)world);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController landController = new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate);
        landController.triggerableAnim("attack", RawAnimation.begin().then("animation.sun_bear.attack", Animation.LoopType.PLAY_ONCE));
        controllers.add(landController);
        controllers.add(new AnimationController((GeoAnimatable)this, "sleep_controller", 5, this::sleepPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "water_controller", 5, this::waterPredicate));
    }

    private <T extends GeoAnimatable> PlayState landPredicate(AnimationState<T> state) {
        if (this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_18798().method_37268() > 1.0E-9) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_sun_bear.walk", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_sun_bear.idle", Animation.LoopType.LOOP));
            }
        } else if (this.isEating()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.sun_bear.eat", Animation.LoopType.LOOP));
        } else if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.sun_bear.walk", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.sun_bear.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState sleepPredicate(AnimationState<T> state) {
        if (this.method_6113()) {
            if (this.method_6109()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_sun_bear.sleep", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.sun_bear.sleep", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <T extends GeoAnimatable> PlayState waterPredicate(AnimationState<T> state) {
        if (!this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_5799()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_sun_bear.swim", Animation.LoopType.LOOP));
            }
        } else if (this.method_5799()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.sun_bear.swim", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    public static class SunBearEatGoal
    extends class_1352 {
        private final SunBearEntity sunBear;
        private int eatingSoundCooldown = 10;

        public SunBearEatGoal(SunBearEntity sunBear) {
            this.sunBear = sunBear;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.sunBear.isEating() && !this.sunBear.method_6113() && !this.sunBear.method_6109();
        }

        public void method_6269() {
            this.sunBear.method_5942().method_6340();
        }

        public void method_6270() {
            this.sunBear.setEating(false);
        }

        public boolean method_6266() {
            return this.sunBear.isEating() && !this.sunBear.method_6113();
        }

        public void method_6268() {
            this.sunBear.method_5942().method_6340();
            this.sunBear.method_5988().method_6231();
            if (this.eatingSoundCooldown <= 0) {
                this.sunBear.method_37908().method_43128(null, this.sunBear.method_23317(), this.sunBear.method_23318(), this.sunBear.method_23321(), class_3417.field_16439, this.sunBear.method_5634(), 1.0f, 1.0f);
                this.eatingSoundCooldown = 10;
            } else {
                --this.eatingSoundCooldown;
            }
        }
    }
}

