/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import java.util.List;
import net.domixcze.domixscreatures.sound.ModSounds;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VineEntity
extends class_1588
implements GeoEntity {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Boolean> IS_HOLDING_ENTITY = class_2945.method_12791(VineEntity.class, (class_2941)class_2943.field_13323);
    private int vineGrabCooldown = 0;

    public VineEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23716, 40.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new GrabEntitiesGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IS_HOLDING_ENTITY, (Object)false);
    }

    public boolean isHoldingEntity() {
        return (Boolean)this.field_6011.method_12789(IS_HOLDING_ENTITY);
    }

    public void setHoldingEntity(boolean holding) {
        this.field_6011.method_12778(IS_HOLDING_ENTITY, (Object)holding);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("VineGrabCooldown", this.vineGrabCooldown);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.vineGrabCooldown = nbt.method_10550("VineGrabCooldown");
    }

    public void method_6005(double strength, double x, double z) {
        super.method_6005(strength * 0.0, x, z);
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    public void method_5773() {
        super.method_5773();
        if (this.vineGrabCooldown > 0) {
            --this.vineGrabCooldown;
        }
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        double xOffset = 0.0;
        double yOffset = -0.1;
        double zOffset = 0.0;
        class_243 offsetVector = new class_243(xOffset, yOffset, zOffset).method_1024(-this.field_6283 * ((float)Math.PI / 180));
        positionUpdater.accept(passenger, this.method_23317() + offsetVector.field_1352, this.method_23318() + offsetVector.field_1351, this.method_23321() + offsetVector.field_1350);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source == this.method_48923().method_48831()) {
            return false;
        }
        if (source.method_48789(class_8103.field_42246)) {
            amount *= 2.0f;
        }
        return super.method_5643(source, amount);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate));
    }

    private <T extends GeoAnimatable> PlayState landPredicate(AnimationState<T> state) {
        if (this.isHoldingEntity()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.vine.attack", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.vine.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.VINE_HURT;
    }

    static class GrabEntitiesGoal
    extends class_1352 {
        private final VineEntity vine;
        private int grabTime = 0;
        private static final int MAX_GRAB_TIME = 200;
        private static final int DAMAGE_ON_GRAB = 8;
        private static final float DAMAGE_PER_TICK = 2.0f;

        GrabEntitiesGoal(VineEntity vine) {
            this.vine = vine;
        }

        public boolean method_6264() {
            if (this.vine.vineGrabCooldown > 0 || this.vine.method_5782()) {
                return false;
            }
            List nearbyPlayers = this.vine.method_37908().method_8390(class_1309.class, this.vine.method_5829().method_1014(1.0), e -> e instanceof class_1657);
            for (class_1309 entity : nearbyPlayers) {
                if (entity.method_5765()) continue;
                return true;
            }
            return false;
        }

        public void method_6269() {
            List nearbyPlayers = this.vine.method_37908().method_8390(class_1309.class, this.vine.method_5829().method_1014(2.0), e -> e instanceof class_1657);
            if (!nearbyPlayers.isEmpty()) {
                class_1309 player = (class_1309)nearbyPlayers.get(0);
                player.method_5873((class_1297)this.vine, true);
                this.vine.setHoldingEntity(true);
                this.grabTime = 0;
                player.method_5643(this.vine.method_48923().method_48812((class_1309)this.vine), 8.0f);
            }
        }

        public void method_6268() {
            if (!this.vine.method_5782()) {
                this.vine.setHoldingEntity(false);
                this.vine.vineGrabCooldown = 200;
                return;
            }
            class_1297 passenger = this.vine.method_31483();
            if (passenger instanceof class_1657) {
                class_1657 player = (class_1657)passenger;
                if (this.grabTime % 20 == 0) {
                    player.method_5643(this.vine.method_48923().method_48812((class_1309)this.vine), 2.0f);
                }
                ++this.grabTime;
                if (this.grabTime >= 200) {
                    player.method_5848();
                    this.vine.setHoldingEntity(false);
                    this.vine.vineGrabCooldown = 200;
                }
            }
        }

        public boolean method_6266() {
            return this.vine.method_5782();
        }

        public void method_6270() {
            this.vine.setHoldingEntity(false);
            if (this.vine.vineGrabCooldown <= 0) {
                this.vine.vineGrabCooldown = 200;
            }
        }
    }
}

