/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.item.guide;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.domixcze.domixscreatures.item.guide.GuideDataLoader;
import net.domixcze.domixscreatures.sound.ModSounds;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_474;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class GuideMainScreen
extends class_437 {
    private static final class_2960 BOOK_TEXTURE = class_2960.method_60655((String)"domixs-creatures", (String)"textures/gui/two_page_book.png");
    private static final int BOOK_WIDTH = 256;
    private static final int BOOK_HEIGHT = 256;
    private static final int PAGE_WIDTH = 128;
    private static final int TEXT_MARGIN_X = 13;
    private static final int TEXT_MARGIN_Y_TOP = 40;
    private static final int TEXT_WIDTH_PER_PAGE = 105;
    private static final int LINE_HEIGHT = 9;
    private static final int LEFT_PAGE_TEXT_X = 13;
    private static final int RIGHT_PAGE_TEXT_X = 141;
    private static final int TEXT_START_Y = 40;
    private static final int MAX_LINES_PER_VISUAL_PAGE = 21;
    private static final int BOOKMARK_WIDTH = 64;
    private static final int BOOKMARK_HEIGHT = 16;
    private static final int BOOKMARK_TEXT_OFFSET_X = 15;
    private static final class_2960 BOOKMARK_TEXTURE = class_2960.method_60655((String)"domixs-creatures", (String)"textures/gui/bookmark.png");
    private static final class_2960 BOOKMARK_HIGHLIGHTED_TEXTURE = class_2960.method_60655((String)"domixs-creatures", (String)"textures/gui/bookmark_highlighted.png");
    private static final class_2960 EXIT_PAGE_TEXTURE = class_2960.method_60655((String)"domixs-creatures", (String)"textures/gui/exit_page.png");
    private static final class_2960 EXIT_PAGE_HIGHLIGHTED_TEXTURE = class_2960.method_60655((String)"domixs-creatures", (String)"textures/gui/exit_page_highlighted.png");
    private static final class_2960 ENTRY_BUTTON_TEXTURE = class_2960.method_60655((String)"domixs-creatures", (String)"textures/gui/entry_button.png");
    private PageType currentPage = PageType.MENU;
    private List<PageContent> currentEntryPagesContent = List.of();
    private class_2561 currentTitle = class_2561.method_43473();
    private int currentEntryPage = 0;
    private int currentMenuPage = 0;
    private Category currentCategory = Category.ENTITIES;
    private int globalImageCycleTick = 0;
    public static final int DEFAULT_IMAGE_CYCLE_FRAME_DURATION_TICKS = 100;
    private class_474 nextPageButton;
    private class_474 previousPageButton;
    private class_4185 backButton;
    private int bookX;
    private int bookY;

    public GuideMainScreen() {
        super((class_2561)class_2561.method_43470((String)"Guide Book"));
    }

    public boolean method_25421() {
        return true;
    }

    public void method_25393() {
        super.method_25393();
        ++this.globalImageCycleTick;
    }

    protected void method_25426() {
        Map<Category, List<List<LightweightMenuEntry>>> loadedMenuEntries;
        List pagesForCurrentCategory;
        this.bookX = (this.field_22789 - 256) / 2;
        this.bookY = 2;
        this.method_37067();
        if (this.currentPage == PageType.MENU && this.currentMenuPage < (pagesForCurrentCategory = (loadedMenuEntries = GuideDataLoader.getLoadedMenuEntries()).getOrDefault((Object)this.currentCategory, List.of())).size()) {
            List entriesForCurrentMenuPage = (List)pagesForCurrentCategory.get(this.currentMenuPage);
            int buttonYOffset = 50;
            int buttonSpacing = 30;
            int leftColumnButtonX = this.bookX + 13 - -2;
            int rightColumnButtonX = this.bookX + 128 + 13 - -2;
            for (int i = 0; i < entriesForCurrentMenuPage.size(); ++i) {
                LightweightMenuEntry entry = (LightweightMenuEntry)entriesForCurrentMenuPage.get(i);
                int currentButtonY = this.bookY + buttonYOffset + i % 4 * buttonSpacing;
                int currentButtonX = i < 4 ? leftColumnButtonX : rightColumnButtonX;
                this.method_37063((class_364)new NavigationButton(currentButtonX, currentButtonY, 100, 20, entry.getButtonText(), b -> this.openEntry(entry.jsonLocation())));
            }
        }
        int bookmarkYOffset = this.bookY + 50;
        int bookmarkSpacing = 5;
        for (int i = 0; i < Category.values().length; ++i) {
            Category category = Category.values()[i];
            this.method_37063((class_364)new BookmarkButton(this.bookX - 64, bookmarkYOffset + i * (16 + bookmarkSpacing), 64, 16, category.bookmarkText, category, button -> {
                this.currentCategory = category;
                this.currentPage = PageType.MENU;
                this.currentMenuPage = 0;
                this.method_25426();
            }));
        }
        this.previousPageButton = (class_474)this.method_37063((class_364)new class_474(this.bookX + 64 - 40, this.bookY + 159, false, b -> {
            if (this.currentPage == PageType.ENTRY) {
                if (this.currentEntryPage == 0) {
                    this.returnToMenu();
                } else {
                    this.previousEntryPage();
                }
            } else {
                this.previousMenuPage();
            }
        }, true));
        this.nextPageButton = (class_474)this.method_37063((class_364)new class_474(this.bookX + 128 + 64 + 20, this.bookY + 159, true, b -> {
            if (this.currentPage == PageType.ENTRY) {
                this.nextEntryPage();
            } else {
                this.nextMenuPage();
            }
        }, true));
        this.backButton = (class_4185)this.method_37063((class_364)new BackButton(this, this.bookX + 13 - 30, this.bookY + 10, 18, 18, button -> this.method_25419()));
        this.updateButtonVisibility();
    }

    private void openEntry(class_2960 entryJsonId) {
        List<PageContent> pagesContent = GuideDataLoader.getEntryContent(entryJsonId);
        class_5250 entryTitle = class_2561.method_43470((String)"Unknown Entry");
        block0: for (List pageList : GuideDataLoader.getLoadedMenuEntries().getOrDefault((Object)this.currentCategory, List.of())) {
            for (LightweightMenuEntry lightweightEntry : pageList) {
                if (!lightweightEntry.jsonLocation().equals((Object)entryJsonId)) continue;
                entryTitle = lightweightEntry.getEntryTitle();
                break block0;
            }
        }
        this.currentPage = PageType.ENTRY;
        this.currentTitle = entryTitle;
        this.currentEntryPagesContent = pagesContent;
        this.currentEntryPage = 0;
        this.method_25426();
    }

    private void returnToMenu() {
        this.currentPage = PageType.MENU;
        this.currentEntryPagesContent = List.of();
        this.currentTitle = class_2561.method_43473();
        this.currentEntryPage = 0;
        this.method_25426();
    }

    public void method_25419() {
        super.method_25419();
    }

    private void updateButtonVisibility() {
        boolean isEntryPage = this.currentPage == PageType.ENTRY;
        boolean isMenuPage = this.currentPage == PageType.MENU;
        this.previousPageButton.field_22764 = isEntryPage || isMenuPage && this.currentMenuPage > 0;
        Map<Category, List<List<LightweightMenuEntry>>> loadedMenuEntries = GuideDataLoader.getLoadedMenuEntries();
        List pagesInCurrentCategory = loadedMenuEntries.getOrDefault((Object)this.currentCategory, List.of());
        this.nextPageButton.field_22764 = isEntryPage && this.currentEntryPage < this.currentEntryPagesContent.size() - 2 || isMenuPage && this.currentMenuPage < pagesInCurrentCategory.size() - 1;
        this.backButton.field_22764 = true;
    }

    private void nextEntryPage() {
        if (this.currentEntryPage < this.currentEntryPagesContent.size() - 2) {
            this.currentEntryPage += 2;
            this.updateButtonVisibility();
        }
    }

    private void previousEntryPage() {
        if (this.currentEntryPage > 0) {
            this.currentEntryPage -= 2;
            this.updateButtonVisibility();
        }
    }

    private void nextMenuPage() {
        Map<Category, List<List<LightweightMenuEntry>>> loadedMenuEntries = GuideDataLoader.getLoadedMenuEntries();
        List pagesInCurrentCategory = loadedMenuEntries.getOrDefault((Object)this.currentCategory, List.of());
        if (this.currentMenuPage < pagesInCurrentCategory.size() - 1) {
            ++this.currentMenuPage;
            this.method_25426();
        }
    }

    private void previousMenuPage() {
        if (this.currentMenuPage > 0) {
            --this.currentMenuPage;
            this.method_25426();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.currentPage == PageType.MENU) {
            this.renderMenu(context);
        } else {
            this.renderEntry(context);
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_52752(context);
        context.method_25302(BOOK_TEXTURE, this.bookX, this.bookY, 0, 0, 256, 256);
    }

    private void renderMenu(class_332 context) {
        int titleX = this.bookX + (256 - this.field_22793.method_27525((class_5348)class_2561.method_43470((String)"Guide Book"))) / 2;
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Guide Book"), titleX, this.bookY + 10, 0xFFFFFF, false);
        int leftPageNumber = this.currentMenuPage * 2 + 1;
        int rightPageNumber = this.currentMenuPage * 2 + 2;
        int numberY = this.bookY + 165;
        class_5250 leftNumText = class_2561.method_43470((String)String.valueOf(leftPageNumber));
        int leftNumWidth = this.field_22793.method_27525((class_5348)leftNumText);
        int leftNumX = this.bookX + 64 - leftNumWidth / 2;
        context.method_51439(this.field_22793, (class_2561)leftNumText, leftNumX, numberY, 0x503000, false);
        class_5250 rightNumText = class_2561.method_43470((String)String.valueOf(rightPageNumber));
        int rightNumWidth = this.field_22793.method_27525((class_5348)rightNumText);
        int rightNumX = this.bookX + 128 + 64 - rightNumWidth / 2;
        context.method_51439(this.field_22793, (class_2561)rightNumText, rightNumX, numberY, 0x503000, false);
    }

    private void renderEntry(class_332 context) {
        class_2960 currentTexture;
        class_1799 currentStack;
        int currentFrameIndex;
        int frameDuration;
        int y;
        int x;
        int titleX = this.bookX + (256 - this.field_22793.method_27525((class_5348)this.currentTitle)) / 2;
        context.method_51439(this.field_22793, this.currentTitle, titleX, this.bookY + 10, 0xFFFFFF, false);
        int leftPageNumber = this.currentEntryPage + 1;
        int rightPageNumber = this.currentEntryPage + 2;
        int numberY = this.bookY + 165;
        class_5250 leftNumText = class_2561.method_43470((String)String.valueOf(leftPageNumber));
        int leftNumWidth = this.field_22793.method_27525((class_5348)leftNumText);
        int leftNumX = this.bookX + 64 - leftNumWidth / 2;
        context.method_51439(this.field_22793, (class_2561)leftNumText, leftNumX, numberY, 0x503000, false);
        class_5250 rightNumText = class_2561.method_43470((String)String.valueOf(rightPageNumber));
        int rightNumWidth = this.field_22793.method_27525((class_5348)rightNumText);
        int rightNumX = this.bookX + 128 + 64 - rightNumWidth / 2;
        context.method_51439(this.field_22793, (class_2561)rightNumText, rightNumX, numberY, 0x503000, false);
        if (this.currentEntryPagesContent.isEmpty() || this.currentEntryPage < 0) {
            return;
        }
        if (this.currentEntryPage < this.currentEntryPagesContent.size()) {
            PageContent leftPage = this.currentEntryPagesContent.get(this.currentEntryPage);
            List<class_5481> leftPageLines = leftPage.getWrappedLines(this.field_22793, 105);
            int drawYLeft = this.bookY + 40;
            for (int i = 0; i < Math.min(21, leftPageLines.size()); ++i) {
                context.method_51430(this.field_22793, leftPageLines.get(i), this.bookX + 13, drawYLeft, 0x503000, false);
                drawYLeft += 9;
            }
            for (ImageEntry img : leftPage.images()) {
                x = this.bookX + 13 + img.x();
                y = this.bookY + img.y();
                if (img.type() == ImageType.ITEM && img.itemStack() != null) {
                    this.renderScaledItem(context, img.itemStack(), x, y, img.width(), img.height());
                    continue;
                }
                if (img.type() == ImageType.TEXTURE && img.identifier() != null) {
                    context.method_25290(img.identifier(), x, y, 0.0f, 0.0f, img.width(), img.height(), img.width(), img.height());
                    continue;
                }
                if (img.type() == ImageType.CYCLING_ITEM && img.cyclingItemStacks() != null && !img.cyclingItemStacks().isEmpty()) {
                    frameDuration = img.frameDurationTicks() > 0 ? img.frameDurationTicks() : 100;
                    currentFrameIndex = this.globalImageCycleTick / frameDuration % img.cyclingItemStacks().size();
                    currentStack = img.cyclingItemStacks().get(currentFrameIndex);
                    this.renderScaledItem(context, currentStack, x, y, img.width(), img.height());
                    continue;
                }
                if (img.type() != ImageType.CYCLING_TEXTURE || img.cyclingIdentifiers() == null || img.cyclingIdentifiers().isEmpty()) continue;
                frameDuration = img.frameDurationTicks() > 0 ? img.frameDurationTicks() : 100;
                currentFrameIndex = this.globalImageCycleTick / frameDuration % img.cyclingIdentifiers().size();
                currentTexture = img.cyclingIdentifiers().get(currentFrameIndex);
                context.method_25290(currentTexture, x, y, 0.0f, 0.0f, img.width(), img.height(), img.width(), img.height());
            }
        }
        if (this.currentEntryPage + 1 < this.currentEntryPagesContent.size()) {
            PageContent rightPage = this.currentEntryPagesContent.get(this.currentEntryPage + 1);
            List<class_5481> rightPageLines = rightPage.getWrappedLines(this.field_22793, 105);
            int drawYRight = this.bookY + 40;
            for (int i = 0; i < Math.min(21, rightPageLines.size()); ++i) {
                context.method_51430(this.field_22793, rightPageLines.get(i), this.bookX + 141, drawYRight, 0x503000, false);
                drawYRight += 9;
            }
            for (ImageEntry img : rightPage.images()) {
                x = this.bookX + 141 + img.x();
                y = this.bookY + img.y();
                if (img.type() == ImageType.ITEM && img.itemStack() != null) {
                    this.renderScaledItem(context, img.itemStack(), x, y, img.width(), img.height());
                    continue;
                }
                if (img.type() == ImageType.TEXTURE && img.identifier() != null) {
                    context.method_25290(img.identifier(), x, y, 0.0f, 0.0f, img.width(), img.height(), img.width(), img.height());
                    continue;
                }
                if (img.type() == ImageType.CYCLING_ITEM && img.cyclingItemStacks() != null && !img.cyclingItemStacks().isEmpty()) {
                    frameDuration = img.frameDurationTicks() > 0 ? img.frameDurationTicks() : 100;
                    currentFrameIndex = this.globalImageCycleTick / frameDuration % img.cyclingItemStacks().size();
                    currentStack = img.cyclingItemStacks().get(currentFrameIndex);
                    this.renderScaledItem(context, currentStack, x, y, img.width(), img.height());
                    continue;
                }
                if (img.type() != ImageType.CYCLING_TEXTURE || img.cyclingIdentifiers() == null || img.cyclingIdentifiers().isEmpty()) continue;
                frameDuration = img.frameDurationTicks() > 0 ? img.frameDurationTicks() : 100;
                currentFrameIndex = this.globalImageCycleTick / frameDuration % img.cyclingIdentifiers().size();
                currentTexture = img.cyclingIdentifiers().get(currentFrameIndex);
                context.method_25290(currentTexture, x, y, 0.0f, 0.0f, img.width(), img.height(), img.width(), img.height());
            }
        }
    }

    private void renderScaledItem(class_332 context, class_1799 stack, int x, int y, int width, int height) {
        if (width == 16 && height == 16) {
            context.method_51427(stack, x, y);
            return;
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)x, (float)y, 100.0f);
        context.method_51448().method_22905((float)width / 16.0f, (float)height / 16.0f, 1.0f);
        context.method_51427(stack, 0, 0);
        context.method_51448().method_22909();
    }

    private static enum PageType {
        MENU,
        ENTRY;

    }

    public static enum Category {
        ENTITIES((class_2561)class_2561.method_43470((String)"Entities")),
        ITEMS((class_2561)class_2561.method_43470((String)"Items")),
        BLOCKS((class_2561)class_2561.method_43470((String)"Blocks"));

        public final class_2561 bookmarkText;

        private Category(class_2561 bookmarkText) {
            this.bookmarkText = bookmarkText;
        }

        public static Category fromString(String name) {
            for (Category category : Category.values()) {
                if (!category.name().equalsIgnoreCase(name)) continue;
                return category;
            }
            return null;
        }
    }

    public record LightweightMenuEntry(String buttonTextKey, String entryTitleKey, class_2960 jsonLocation, Category category) {
        public class_2561 getButtonText() {
            return class_2561.method_43471((String)this.buttonTextKey);
        }

        public class_2561 getEntryTitle() {
            return class_2561.method_43471((String)this.entryTitleKey);
        }
    }

    class NavigationButton
    extends class_4185 {
        private static final int HOVER_OFFSET_Y = -2;
        private boolean wasHovered;

        protected NavigationButton(int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress) {
            super(x, y, width, height, message, onPress, field_40754);
            this.wasHovered = false;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            if (this.method_49606() && !this.wasHovered) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)ModSounds.GUIDE_BOOK_ENTRY, (float)1.0f, (float)0.5f));
            }
            this.wasHovered = this.method_49606();
            int drawY = this.method_46427();
            if (this.method_49606()) {
                drawY -= 2;
            }
            context.method_25290(ENTRY_BUTTON_TEXTURE, this.method_46426(), drawY, 0.0f, 0.0f, this.field_22758, this.field_22759, 100, 20);
            int textColor = 0x503000;
            context.method_51439(GuideMainScreen.this.field_22793, this.method_25369(), this.method_46426() + (this.field_22758 - GuideMainScreen.this.field_22793.method_27525((class_5348)this.method_25369())) / 2, drawY + (this.field_22759 - 8) / 2, textColor, false);
        }
    }

    class BookmarkButton
    extends class_4185 {
        private final Category category;
        private boolean wasHovered;

        protected BookmarkButton(int x, int y, int width, int height, class_2561 message, Category category, class_4185.class_4241 onPress) {
            super(x, y, width, height, message, onPress, field_40754);
            this.wasHovered = false;
            this.category = category;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            if (this.method_49606() && !this.wasHovered) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)ModSounds.GUIDE_BOOK_BOOKMARK, (float)1.0f, (float)1.0f));
            }
            this.wasHovered = this.method_49606();
            class_2960 identifier = BOOKMARK_TEXTURE;
            int textColor = 0;
            if (this.method_49606() || GuideMainScreen.this.currentCategory == this.category) {
                identifier = BOOKMARK_HIGHLIGHTED_TEXTURE;
                textColor = 0xFFFFFF;
            }
            context.method_25290(identifier, this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.field_22758, this.field_22759, this.field_22758, this.field_22759);
            int textX = this.method_46426() + 15;
            int n = this.method_46427();
            Objects.requireNonNull(GuideMainScreen.this.field_22793);
            int textY = n + (this.field_22759 - 9) / 2;
            context.method_51439(GuideMainScreen.this.field_22793, this.method_25369(), textX, textY, textColor, false);
        }
    }

    class BackButton
    extends class_4185 {
        protected BackButton(GuideMainScreen this$0, int x, int y, int width, int height, class_4185.class_4241 onPress) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), onPress, field_40754);
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            class_2960 identifier = this.method_49606() ? EXIT_PAGE_HIGHLIGHTED_TEXTURE : EXIT_PAGE_TEXTURE;
            context.method_25290(identifier, this.method_46426(), this.method_46427(), 0.0f, 0.0f, 18, 18, 18, 18);
        }
    }

    public static class PageContent {
        private final List<class_2561> textContent;
        private final List<ImageEntry> images;
        private List<class_5481> cachedWrappedLines = null;
        private class_327 lastUsedRenderer = null;
        private int lastUsedMaxWidth = -1;

        public PageContent(List<class_2561> textContent, List<ImageEntry> images) {
            this.textContent = List.copyOf(textContent);
            this.images = List.copyOf(images);
        }

        public List<ImageEntry> images() {
            return this.images;
        }

        public List<class_5481> getWrappedLines(class_327 renderer, int maxWidth) {
            if (this.cachedWrappedLines == null || renderer != this.lastUsedRenderer || maxWidth != this.lastUsedMaxWidth) {
                ArrayList<class_5481> newWrappedLines = new ArrayList<class_5481>();
                for (class_2561 line : this.textContent) {
                    if (line.getString().isEmpty()) {
                        newWrappedLines.add(class_5481.field_26385);
                        continue;
                    }
                    newWrappedLines.addAll(renderer.method_1728((class_5348)line, maxWidth));
                }
                this.cachedWrappedLines = Collections.unmodifiableList(newWrappedLines);
                this.lastUsedRenderer = renderer;
                this.lastUsedMaxWidth = maxWidth;
            }
            return this.cachedWrappedLines;
        }
    }

    public record ImageEntry(ImageType type, @Nullable class_2960 identifier, @Nullable class_1799 itemStack, @Nullable List<class_2960> cyclingIdentifiers, @Nullable List<class_1799> cyclingItemStacks, int frameDurationTicks, int x, int y, int width, int height) {
        public static ImageEntry texture(class_2960 identifier, int x, int y, int width, int height) {
            return new ImageEntry(ImageType.TEXTURE, identifier, null, null, null, 0, x, y, width, height);
        }

        public static ImageEntry item(class_1799 itemStack, int x, int y, int width, int height) {
            return new ImageEntry(ImageType.ITEM, null, itemStack, null, null, 0, x, y, width, height);
        }

        public static ImageEntry cyclingTexture(List<class_2960> identifiers, int frameDurationTicks, int x, int y, int width, int height) {
            return new ImageEntry(ImageType.CYCLING_TEXTURE, null, null, List.copyOf(identifiers), null, frameDurationTicks, x, y, width, height);
        }

        public static ImageEntry cyclingItem(List<class_1799> itemStacks, int frameDurationTicks, int x, int y, int width, int height) {
            return new ImageEntry(ImageType.CYCLING_ITEM, null, null, null, List.copyOf(itemStacks), frameDurationTicks, x, y, width, height);
        }
    }

    private static enum ImageType {
        ITEM,
        TEXTURE,
        CYCLING_ITEM,
        CYCLING_TEXTURE;

    }
}

