/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.block.custom;

import net.domixcze.domixscreatures.entity.ModEntities;
import net.domixcze.domixscreatures.entity.client.crocodile.CrocodileVariants;
import net.domixcze.domixscreatures.entity.custom.CrocodileEntity;
import net.domixcze.domixscreatures.util.ModTags;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class CrocodileEggBlock
extends class_2248 {
    public static final class_2758 HATCH;
    public static final class_2758 EGGS;
    private static final class_265 ONE_EGG_SHAPE;
    private static final class_265 TWO_EGG_SHAPE;
    private static final class_265 THREE_EGG_SHAPE;

    public CrocodileEggBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)HATCH, (Comparable)Integer.valueOf(0))).method_11657((class_2769)EGGS, (Comparable)Integer.valueOf(1)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        switch ((Integer)state.method_11654((class_2769)EGGS)) {
            default: {
                return ONE_EGG_SHAPE;
            }
            case 2: {
                return TWO_EGG_SHAPE;
            }
            case 3: 
        }
        return THREE_EGG_SHAPE;
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (!entity.method_21749()) {
            this.tryBreakEgg(world, state, pos, entity, 100);
        }
        super.method_9591(world, pos, state, entity);
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (!(entity instanceof class_1642)) {
            this.tryBreakEgg(world, state, pos, entity, 3);
        }
        super.method_9554(world, state, pos, entity, fallDistance);
    }

    private void tryBreakEgg(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, int inverseChance) {
        if (this.breaksEgg(world, entity) && !world.field_9236 && world.field_9229.method_43048(inverseChance) == 0) {
            this.breakEgg(world, pos, state);
        }
    }

    private boolean breaksEgg(class_1937 world, class_1297 entity) {
        if (!(entity instanceof CrocodileEntity) && !(entity instanceof class_1420)) {
            if (!(entity instanceof class_1309)) {
                return false;
            }
            return entity instanceof class_1657 || world.method_8450().method_8355(class_1928.field_19388);
        }
        return false;
    }

    private void breakEgg(class_1937 world, class_2338 pos, class_2680 state) {
        world.method_8396(null, pos, class_3417.field_14687, class_3419.field_15245, 0.7f, 0.9f + world.field_9229.method_43057() * 0.2f);
        int i = (Integer)state.method_11654((class_2769)EGGS);
        if (i <= 1) {
            world.method_22352(pos, false);
        } else {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            world.method_33596(null, (class_6880)class_5712.field_28165, pos);
            world.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
        }
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 tool) {
        super.method_9556(world, player, pos, state, blockEntity, tool);
        this.breakEgg(world, pos, state);
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1799 itemStack = player.method_6047();
        if (itemStack.method_31574(world.method_8320(pos).method_26204().method_8389())) {
            int currentCount = (Integer)state.method_11654((class_2769)EGGS);
            if (currentCount < 3) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)EGGS, (Comparable)Integer.valueOf(currentCount + 1)), 3);
                if (!player.method_31549().field_7477) {
                    itemStack.method_7934(1);
                }
                world.method_8396(player, pos, class_3417.field_28030, class_3419.field_15245, 1.0f, 1.0f);
                world.method_33596((class_1297)player, (class_6880)class_5712.field_28164, pos);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (this.shouldHatchProgress((class_1937)world) && CrocodileEggBlock.isHatchableBelow((class_1922)world, pos)) {
            int i = (Integer)state.method_11654((class_2769)HATCH);
            if (i < 2) {
                world.method_8396(null, pos, class_3417.field_15109, class_3419.field_15245, 0.7f, 0.9f + random.method_43057() * 0.2f);
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                world.method_8396(null, pos, class_3417.field_14902, class_3419.field_15245, 0.7f, 0.9f + random.method_43057() * 0.2f);
                world.method_8650(pos, false);
                for (int j = 0; j < (Integer)state.method_11654((class_2769)EGGS); ++j) {
                    class_1299<CrocodileEntity> crocodile = ModEntities.CROCODILE;
                    class_1309 crocodileEntity = (class_1309)crocodile.method_5883((class_1937)world);
                    if (!(crocodileEntity instanceof CrocodileEntity)) continue;
                    CrocodileEntity crocodileInstance = (CrocodileEntity)crocodileEntity;
                    crocodileInstance.method_7217(true);
                    class_6880 biomeEntry = world.method_23753(pos);
                    if (biomeEntry.method_40220(ModTags.Biomes.SPAWNS_SAVANNA_CROCODILE)) {
                        crocodileInstance.setVariant(CrocodileVariants.SAVANNA);
                    } else if (world.method_8409().method_43058() < 0.05) {
                        crocodileInstance.setVariant(CrocodileVariants.ALBINO);
                    } else {
                        crocodileInstance.setVariant(CrocodileVariants.NORMAL);
                    }
                    crocodileEntity.method_5808((double)pos.method_10263() + 0.3 + (double)j * 0.2, (double)pos.method_10264(), (double)pos.method_10260() + 0.3, 0.0f, 0.0f);
                    world.method_8649((class_1297)crocodileEntity);
                }
            }
        }
    }

    private boolean shouldHatchProgress(class_1937 world) {
        float f = world.method_30274(1.0f);
        return (double)f < 0.69 && (double)f > 0.65 || world.field_9229.method_43048(500) == 0;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{HATCH, EGGS});
    }

    public static boolean isHatchableBelow(class_1922 world, class_2338 pos) {
        return CrocodileEggBlock.isHatchable(world, pos.method_10074());
    }

    public static boolean isHatchable(class_1922 world, class_2338 pos) {
        return world.method_8320(pos).method_26164(ModTags.Blocks.CROCODILE_EGG_HATCHABLE);
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (CrocodileEggBlock.isHatchableBelow((class_1922)world, pos) && !world.field_9236) {
            world.method_20290(2005, pos, 0);
        }
    }

    static {
        EGGS = class_2758.method_11867((String)"eggs", (int)1, (int)3);
        ONE_EGG_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)5.0, (double)12.0);
        TWO_EGG_SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
        THREE_EGG_SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
        HATCH = class_2741.field_12530;
    }
}

