/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.block.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import net.domixcze.domixscreatures.block.entity.ModBlockEntities;
import net.domixcze.domixscreatures.screen.custom.FishTrapScreenHandler;
import net.domixcze.domixscreatures.util.ModTags;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class FishTrapBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<class_2338>,
class_1278 {
    private final class_2371<class_1799> items = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private int fishingCooldown = 0;
    private final int ticksPerItem = 4800;

    public FishTrapBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.FISH_TRAP_BLOCK_ENTITY, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, FishTrapBlockEntity entity) {
        if (world.field_9236) {
            return;
        }
        ++entity.fishingCooldown;
        if (entity.fishingCooldown >= entity.ticksPerItem) {
            entity.fishingCooldown = 0;
            if (entity.canFish()) {
                entity.catchItem();
            }
        }
    }

    public boolean canFish() {
        if (this.field_11863 == null) {
            return false;
        }
        if (!this.isWaterlogged()) {
            return false;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                class_2338 checkPos;
                class_2680 state;
                if (dx == 0 && dz == 0 || (state = this.field_11863.method_8320(checkPos = this.field_11867.method_10069(dx, 0, dz))).method_27852(class_2246.field_10382)) continue;
                return false;
            }
        }
        for (class_1799 stack : this.items) {
            if (!stack.method_7960() && stack.method_7947() >= stack.method_7914()) continue;
            return true;
        }
        return false;
    }

    private boolean isWaterlogged() {
        if (this.field_11863 == null) {
            return false;
        }
        return (Boolean)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)class_2741.field_12508);
    }

    private void catchItem() {
        class_1799 stack;
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_5321 lootTableKey = class_39.field_353;
        class_6880 biomeEntry = serverWorld.method_30349().method_30530(class_7924.field_41236).method_40264((class_5321)serverWorld.method_23753(this.field_11867).method_40230().orElse(null)).orElse(null);
        if (biomeEntry != null && serverWorld.method_8409().method_43057() < 0.35f) {
            if (biomeEntry.method_40220(ModTags.Biomes.FISH_TRAP_OCEAN)) {
                lootTableKey = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)"domixs-creatures", (String)"gameplay/fish_trap_ocean"));
            } else if (biomeEntry.method_40220(ModTags.Biomes.FISH_TRAP_JUNGLE)) {
                lootTableKey = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)"domixs-creatures", (String)"gameplay/fish_trap_jungle"));
            } else if (biomeEntry.method_40220(ModTags.Biomes.FISH_TRAP_SWAMP)) {
                lootTableKey = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)"domixs-creatures", (String)"gameplay/fish_trap_swamp"));
            } else if (biomeEntry.method_40220(ModTags.Biomes.FISH_TRAP_LUSH_CAVE)) {
                lootTableKey = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)"domixs-creatures", (String)"gameplay/fish_trap_lush_cave"));
            }
        }
        class_52 lootTable = serverWorld.method_8503().method_58576().method_58295(lootTableKey);
        class_8567.class_8568 builder = new class_8567.class_8568(serverWorld).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.field_11867)).method_51874(class_181.field_1229, (Object)class_1799.field_8037);
        class_8567 context = builder.method_51875(class_173.field_1176);
        ObjectArrayList loot = lootTable.method_51878(context);
        Iterator iterator = loot.iterator();
        while (iterator.hasNext() && !this.tryInsertStack(stack = (class_1799)iterator.next())) {
        }
    }

    private boolean tryInsertStack(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        for (class_1799 existing : this.items) {
            if (existing.method_7960() || !class_1799.method_7984((class_1799)existing, (class_1799)stack) || existing.method_7947() >= existing.method_7914()) continue;
            int transfer = Math.min(existing.method_7914() - existing.method_7947(), stack.method_7947());
            existing.method_7933(transfer);
            stack.method_7934(transfer);
            this.method_5431();
            return true;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((class_1799)this.items.get(i)).method_7960()) continue;
            this.items.set(i, (Object)stack.method_7972());
            stack.method_7939(0);
            this.method_5431();
            return true;
        }
        return false;
    }

    public void dropInventory(class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            return;
        }
        for (class_1799 stack : this.items) {
            if (stack.method_7960()) continue;
            class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)stack);
        }
        this.method_5448();
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.items, (class_7225.class_7874)registryLookup);
        nbt.method_10569("fishingCooldown", this.fishingCooldown);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.items, (class_7225.class_7874)registryLookup);
        this.fishingCooldown = nbt.method_10550("fishingCooldown");
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        for (class_1799 stack : this.items) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.items.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack = class_1262.method_5430(this.items, (int)slot, (int)amount);
        if (!stack.method_7960()) {
            this.method_5431();
        }
        return stack;
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.items, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.items.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public void method_5448() {
        this.items.clear();
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5431() {
        super.method_5431();
    }

    public int[] method_5494(class_2350 side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 side) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
        return true;
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.field_11867;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block_entity.domixs_creatures.fish_trap");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new FishTrapScreenHandler(syncId, playerInventory, this.field_11867);
    }
}

