/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.block.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.domixcze.domixscreatures.block.custom.NegativeMagnetBlock;
import net.domixcze.domixscreatures.block.entity.ModBlockEntities;
import net.domixcze.domixscreatures.particle.ModParticles;
import net.domixcze.domixscreatures.sound.ModSounds;
import net.domixcze.domixscreatures.util.ModTags;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_746;
import org.joml.Vector3f;

public class NegativeMagnetBlockEntity
extends class_2586 {
    @Environment(value=EnvType.CLIENT)
    private class_1113 activeMagnetSound;
    private final Set<class_1542> affectedItemEntities = new HashSet<class_1542>();

    public NegativeMagnetBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.NEGATIVE_MAGNET_BLOCK_ENTITY, pos, state);
    }

    private static double calculateEffectiveBeamLength(class_1937 world, class_2338 magnetPos, class_2350 direction) {
        class_243 magnetCenter = class_243.method_24953((class_2382)magnetPos);
        class_243 directionVec = class_243.method_24954((class_2382)direction.method_10163());
        double maxBeamEffectDistance = 8.0;
        double raycastTotalLength = maxBeamEffectDistance + 1.5;
        class_243 raycastStart = magnetCenter.method_1019(directionVec.method_1021(0.501));
        class_243 raycastEnd = raycastStart.method_1019(directionVec.method_1021(raycastTotalLength));
        class_3959 rayCtx = new class_3959(raycastStart, raycastEnd, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, class_3726.method_16194());
        class_3965 hitResult = world.method_17742(rayCtx);
        double effectiveLength = maxBeamEffectDistance;
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            double hitDistance = hitResult.method_17784().method_1022(raycastStart);
            effectiveLength = Math.max(0.0, (double)((int)(hitDistance + 0.5 - 0.001)));
            effectiveLength = Math.min(effectiveLength, maxBeamEffectDistance);
        }
        return effectiveLength;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, NegativeMagnetBlockEntity be) {
        class_238 box;
        if (world.method_8608()) {
            NegativeMagnetBlockEntity.applyMagnetClient(world, pos, state);
            NegativeMagnetBlockEntity.handleMagnetSound(world, pos, state, be);
            return;
        }
        boolean isPowered = (Boolean)state.method_11654((class_2769)NegativeMagnetBlock.POWERED);
        if (!isPowered && !be.affectedItemEntities.isEmpty()) {
            for (class_1542 itemEntity : new HashSet<class_1542>(be.affectedItemEntities)) {
                if (itemEntity == null || !itemEntity.method_5805()) continue;
                itemEntity.method_5875(false);
            }
            be.affectedItemEntities.clear();
            return;
        }
        if (!isPowered) {
            return;
        }
        class_2350 direction = (class_2350)state.method_11654((class_2769)NegativeMagnetBlock.FACING);
        class_243 directionVec = class_243.method_24954((class_2382)direction.method_10163());
        double dynamicBeamBlocks = NegativeMagnetBlockEntity.calculateEffectiveBeamLength(world, pos, direction);
        if (dynamicBeamBlocks <= 0.0) {
            box = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        } else {
            class_243 start = class_243.method_24954((class_2382)pos);
            class_243 end = class_243.method_24954((class_2382)pos.method_10079(direction, (int)dynamicBeamBlocks + 1)).method_1031(1.0, 1.0, 1.0);
            box = new class_238(start, end);
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (dynamicBeamBlocks > 0.0) {
                for (int i = 0; i < 4; ++i) {
                    double range = world.field_9229.method_43058() * dynamicBeamBlocks;
                    Vector3f unitVec = direction.method_23955();
                    class_243 base = class_243.method_24953((class_2382)pos).method_1019(new class_243((double)unitVec.x, (double)unitVec.y, (double)unitVec.z).method_1021(range + 0.5));
                    double x = base.field_1352 + (world.field_9229.method_43058() - 0.5) * 0.4;
                    double y = base.field_1351 + (world.field_9229.method_43058() - 0.5) * 0.4;
                    double z = base.field_1350 + (world.field_9229.method_43058() - 0.5) * 0.4;
                    serverWorld.method_14199((class_2394)ModParticles.NEGATIVE_MAGNET, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        List currentAffectedGeneralEntities = world.method_8390(class_1297.class, box, NegativeMagnetBlockEntity::isAffectedEntity);
        HashSet<class_1542> currentItemEntitiesInBeam = new HashSet<class_1542>();
        for (class_1297 entity : currentAffectedGeneralEntities) {
            if (!(entity instanceof class_1542)) continue;
            class_1542 itemEntity = (class_1542)entity;
            currentItemEntitiesInBeam.add(itemEntity);
        }
        for (class_1542 itemEntity : new HashSet<class_1542>(be.affectedItemEntities)) {
            if (currentItemEntitiesInBeam.contains(itemEntity) || itemEntity == null || !itemEntity.method_5805()) continue;
            itemEntity.method_5875(false);
        }
        be.affectedItemEntities.clear();
        for (class_1297 entity : currentAffectedGeneralEntities) {
            if (entity.method_24515().equals((Object)pos)) continue;
            class_243 force = directionVec.method_1021(0.1);
            entity.method_60491(force);
            entity.field_6017 = 0.0f;
            if (!(entity instanceof class_1542)) continue;
            class_1542 itemEntity = (class_1542)entity;
            itemEntity.method_5875(true);
            be.affectedItemEntities.add(itemEntity);
        }
    }

    private static boolean isAffectedEntity(class_1297 entity) {
        class_1309 living;
        if (entity instanceof class_1309 && NegativeMagnetBlockEntity.isWearingIronArmor(living = (class_1309)entity)) {
            return true;
        }
        if (entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            return itemEntity.method_6983().method_31573(ModTags.Items.MAGNETIC_ITEMS);
        }
        return false;
    }

    private static boolean isWearingIronArmor(class_1309 entity) {
        for (class_1799 stack : entity.method_5661()) {
            if (!stack.method_31573(ModTags.Items.MAGNETIC_ITEMS)) continue;
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private static void applyMagnetClient(class_1937 world, class_2338 pos, class_2680 state) {
        class_238 box;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || !((Boolean)state.method_11654((class_2769)NegativeMagnetBlock.POWERED)).booleanValue()) {
            return;
        }
        if (!NegativeMagnetBlockEntity.isWearingIronArmor((class_1309)player)) {
            return;
        }
        class_2350 direction = (class_2350)state.method_11654((class_2769)NegativeMagnetBlock.FACING);
        class_243 directionVec = class_243.method_24954((class_2382)direction.method_10163());
        class_243 pullVec = directionVec.method_1021(0.1);
        double dynamicBeamBlocks = NegativeMagnetBlockEntity.calculateEffectiveBeamLength(world, pos, direction);
        if (dynamicBeamBlocks <= 0.0) {
            box = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        } else {
            class_243 start = class_243.method_24954((class_2382)pos);
            class_243 end = class_243.method_24954((class_2382)pos.method_10079(direction, (int)dynamicBeamBlocks + 1)).method_1031(1.0, 1.0, 1.0);
            box = new class_238(start, end);
        }
        if (player.method_5829().method_994(box)) {
            player.method_60491(pullVec);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void handleMagnetSound(class_1937 world, final class_2338 pos, class_2680 state, NegativeMagnetBlockEntity be) {
        boolean isPowered = (Boolean)state.method_11654((class_2769)NegativeMagnetBlock.POWERED);
        class_310 client = class_310.method_1551();
        if (isPowered) {
            if (be.activeMagnetSound == null || !client.method_1483().method_4877(be.activeMagnetSound)) {
                class_1101 sound = new class_1101(ModSounds.MAGNET, class_3419.field_15245, world.field_9229){
                    {
                        super(soundEvent, soundCategory, random);
                        this.field_5442 = 1.0f;
                        this.field_5441 = 1.0f;
                        this.field_5446 = true;
                        this.field_5451 = 0;
                        this.field_5440 = class_1113.class_1114.field_5476;
                        this.field_5439 = (double)pos.method_10263() + 0.5;
                        this.field_5450 = (double)pos.method_10264() + 0.5;
                        this.field_5449 = (double)pos.method_10260() + 0.5;
                        this.field_18936 = false;
                    }

                    public boolean method_4793() {
                        return false;
                    }

                    public void method_16896() {
                    }
                };
                client.method_1483().method_4873((class_1113)sound);
                be.activeMagnetSound = sound;
            }
        } else if (be.activeMagnetSound != null && client.method_1483().method_4877(be.activeMagnetSound)) {
            client.method_1483().method_4870(be.activeMagnetSound);
            be.activeMagnetSound = null;
        }
    }
}

