/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.ai;

import java.util.List;
import net.domixcze.domixscreatures.effect.ModEffects;
import net.domixcze.domixscreatures.entity.custom.EelEntity;
import net.domixcze.domixscreatures.particle.ModParticles;
import net.domixcze.domixscreatures.sound.ModSounds;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1366;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import net.minecraft.class_3419;

public class EelMeleeAttackGoal
extends class_1366 {
    private final EelEntity eel;
    private static final int ATTACK_RADIUS = 3;
    private static final int ATTACK_TIME = 40;
    public static final int COOLDOWN_TIME = 1000;
    private int attackDuration = 0;

    public EelMeleeAttackGoal(EelEntity eel, double speed, boolean pauseWhenMobIdle) {
        super((class_1314)eel, speed, pauseWhenMobIdle);
        this.eel = eel;
    }

    public boolean method_6264() {
        class_1309 target = this.eel.method_5968();
        boolean isTargetInWater = target != null && target.method_5799() && this.isTargetInRange();
        return this.eel.isCharged() && this.eel.method_5799() && isTargetInWater;
    }

    private boolean isTargetInRange() {
        class_1309 target = this.eel.method_5968();
        return target != null && this.eel.method_5858((class_1297)target) <= 3.0;
    }

    public boolean method_6266() {
        return this.attackDuration > 0;
    }

    public void method_6269() {
        this.attackDuration = 40;
        this.eel.setCharged(false);
        class_1937 class_19372 = this.eel.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_43129(null, (class_1297)this.eel, ModSounds.EEL_ATTACK, class_3419.field_15251, 1.0f, 1.0f);
        }
    }

    public void method_6270() {
        this.eel.setAttackCooldown(1000);
        this.attackDuration = 0;
    }

    public void method_6268() {
        if (this.attackDuration > 0) {
            --this.attackDuration;
            this.spawnParticles();
            this.applyEffectInRadius();
        }
    }

    private void spawnParticles() {
        class_1937 class_19372 = this.eel.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            double centerX = this.eel.method_23317();
            double centerY = this.eel.method_23318() + 0.5;
            double centerZ = this.eel.method_23321();
            double pulseRadius = 3.0 * (double)((float)(40 - this.attackDuration) / 40.0f);
            for (double angle = 0.0; angle < 360.0; angle += 10.0) {
                double radians = Math.toRadians(angle);
                double xOffset = Math.cos(radians) * pulseRadius;
                double zOffset = Math.sin(radians) * pulseRadius;
                serverWorld.method_14199((class_2394)ModParticles.ELECTRIC, centerX + xOffset, centerY, centerZ + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    private void applyEffectInRadius() {
        class_1937 class_19372 = this.eel.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            double centerX = this.eel.method_23317();
            double centerZ = this.eel.method_23321();
            double centerY = this.eel.method_23318();
            int blockY = (int)Math.floor(centerY);
            double pulseRadius = 3.0 * (double)((float)(40 - this.attackDuration) / 40.0f);
            class_238 area = new class_238(centerX - pulseRadius, (double)blockY, centerZ - pulseRadius, centerX + pulseRadius, (double)(blockY + 1), centerZ + pulseRadius);
            List entities = serverWorld.method_8390(class_1309.class, area, entity -> entity != this.eel);
            for (class_1309 entity2 : entities) {
                entity2.method_6092(new class_1293(ModEffects.ELECTRIFIED, 200, 0));
            }
        }
    }
}

