/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.domixcze.domixscreatures.block.ModBlocks;
import net.domixcze.domixscreatures.config.ModConfig;
import net.domixcze.domixscreatures.entity.ModEntities;
import net.domixcze.domixscreatures.entity.ai.BabyFollowParentGoal;
import net.domixcze.domixscreatures.entity.ai.SleepGoal;
import net.domixcze.domixscreatures.entity.ai.Sleepy;
import net.domixcze.domixscreatures.entity.ai.SnowLayerable;
import net.domixcze.domixscreatures.entity.client.beaver.BeaverVariants;
import net.domixcze.domixscreatures.item.ModItems;
import net.domixcze.domixscreatures.util.ModTags;
import net.domixcze.domixscreatures.util.SnowLayerUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1324;
import net.minecraft.class_1335;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5757;
import net.minecraft.class_5766;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BeaverEntity
extends class_1429
implements GeoEntity,
Sleepy,
SnowLayerable {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int snowTicks = 0;
    private int snowMeltTimer = 0;
    public static final class_2940<Boolean> HAS_SNOW_LAYER = class_2945.method_12791(BeaverEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_2338> HOME_POS = class_2945.method_12791(BeaverEntity.class, (class_2941)class_2943.field_13324);
    public static final class_2940<Boolean> SLEEPING = class_2945.method_12791(BeaverEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(BeaverEntity.class, (class_2941)class_2943.field_13327);
    public static final Map<class_2248, class_2248> STRIPPED_LOGS = new HashMap<class_2248, class_2248>();

    public BeaverEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new BeaverMoveControl(this);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_47761, 1.2);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SleepGoal(this, (class_1308)this, 100, false, true, true, false, 3.0, 500, 700, true, false, false, true, 1));
        this.field_6201.method_6277(1, (class_1352)new StripLogGoal(this, 1.0, 10));
        this.field_6201.method_6277(1, (class_1352)new StayNearHomeGoal(this, 1.0, 16, 10));
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new BabyFollowParentGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 0.75, 1.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_SNOW_LAYER, (Object)false);
        builder.method_56912(HOME_POS, (Object)class_2338.field_10980);
        builder.method_56912(SLEEPING, (Object)false);
        builder.method_56912(VARIANT, (Object)BeaverVariants.BROWN.getId());
    }

    public boolean method_5931() {
        return !this.method_6113();
    }

    @Override
    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.method_5942().method_6340();
        }
    }

    public BeaverVariants getVariant() {
        return BeaverVariants.byId((Integer)this.field_6011.method_12789(VARIANT));
    }

    public void setVariant(BeaverVariants variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ModTags.Items.BEAVER_FOR_BREEDING);
    }

    protected class_4048 method_55694(class_4050 pose) {
        if (this.method_6109()) {
            return class_4048.method_18385((float)0.4f, (float)0.3f);
        }
        return this.method_5864().method_18386();
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        BeaverEntity baby = (BeaverEntity)ModEntities.BEAVER.method_5883((class_1937)world);
        if (baby != null) {
            BeaverEntity parent1 = this;
            BeaverEntity parent2 = (BeaverEntity)entity;
            if (parent1.getVariant() == BeaverVariants.ALBINO && parent2.getVariant() == BeaverVariants.ALBINO) {
                baby.setVariant(BeaverVariants.ALBINO);
            } else {
                double chance = 0.01;
                if (parent1.getVariant() == BeaverVariants.ALBINO || parent2.getVariant() == BeaverVariants.ALBINO) {
                    chance = 0.25;
                }
                if (world.method_8409().method_43058() < chance) {
                    baby.setVariant(BeaverVariants.ALBINO);
                } else {
                    baby.setVariant(BeaverVariants.BROWN);
                }
            }
        }
        return baby;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_42716) && this.hasSnowLayer()) {
            if (!this.method_37908().field_9236) {
                this.setHasSnowLayer(false);
                this.snowMeltTimer = 0;
                int count = 3 + this.method_37908().field_9229.method_43048(2);
                this.method_5775(new class_1799((class_1935)class_1802.field_8543, count));
            }
            SnowLayerUtil.spawnSnowParticles((class_1309)this);
            this.method_5783(class_3417.field_15165, 1.0f, 1.0f);
            if (!player.method_7337()) {
                itemStack.method_7970(1, (class_1309)player, class_1304.field_6173);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "water_controller", 5, this::waterPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "sleep_controller", 5, this::sleepPredicate));
    }

    private <T extends GeoAnimatable> PlayState landPredicate(AnimationState<T> state) {
        if (this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_18798().method_37268() > 1.0E-9) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_beaver.walk", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_beaver.idle", Animation.LoopType.LOOP));
            }
        } else if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.beaver.walk", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.beaver.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState waterPredicate(AnimationState<T> state) {
        if (!this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_18798().method_37268() > 1.0E-9) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_beaver.swim", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_beaver.idle_swim", Animation.LoopType.LOOP));
            }
        } else if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.beaver.swim", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.beaver.idle_swim", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState sleepPredicate(AnimationState<T> state) {
        if (this.method_6113()) {
            if (this.method_6109()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_beaver.sleep", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.beaver.sleep", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    protected class_1408 method_5965(class_1937 world) {
        return new class_5766((class_1308)this, world);
    }

    public boolean method_5675() {
        return false;
    }

    public void method_6007() {
        super.method_6007();
        class_1324 movementSpeed = this.method_5996(class_5134.field_23719);
        if (movementSpeed != null) {
            if (this.method_24828()) {
                movementSpeed.method_6192((double)0.2f);
            } else if (this.method_5799()) {
                movementSpeed.method_6192(1.5);
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_5799()) {
            this.field_6207 = new class_5757((class_1308)this, 85, 10, 5.0f, 0.1f, true);
        } else if (this.method_24828()) {
            this.field_6207 = new BeaverMoveControl(this);
        }
        SnowLayerUtil.handleSnowLayerTick((class_1309)this, this);
    }

    @Override
    public boolean hasSnowLayer() {
        return (Boolean)this.field_6011.method_12789(HAS_SNOW_LAYER);
    }

    @Override
    public void setHasSnowLayer(boolean hasSnow) {
        this.field_6011.method_12778(HAS_SNOW_LAYER, (Object)hasSnow);
    }

    @Override
    public int getSnowTicks() {
        return this.snowTicks;
    }

    @Override
    public void setSnowTicks(int ticks) {
        this.snowTicks = ticks;
    }

    @Override
    public int getSnowMeltTimer() {
        return this.snowMeltTimer;
    }

    @Override
    public void setSnowMeltTimer(int timer) {
        this.snowMeltTimer = timer;
    }

    public void setHomePos(class_2338 pos) {
        this.field_6011.method_12778(HOME_POS, (Object)pos);
    }

    public class_2338 getHomePos() {
        return (class_2338)this.field_6011.method_12789(HOME_POS);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("HasSnowLayer", this.hasSnowLayer());
        nbt.method_10569("SnowTicks", this.snowTicks);
        nbt.method_10569("SnowMeltTimer", this.snowMeltTimer);
        nbt.method_10569("Variant", this.getVariant().getId());
        nbt.method_10556("Sleeping", this.method_6113());
        class_2338 homePos = this.getHomePos();
        if (!homePos.equals((Object)class_2338.field_10980)) {
            nbt.method_10569("HomeX", homePos.method_10263());
            nbt.method_10569("HomeY", homePos.method_10264());
            nbt.method_10569("HomeZ", homePos.method_10260());
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setHasSnowLayer(nbt.method_10577("HasSnowLayer"));
        this.snowTicks = nbt.method_10550("SnowTicks");
        this.snowMeltTimer = nbt.method_10550("SnowMeltTimer");
        this.setVariant(BeaverVariants.byId(nbt.method_10550("Variant")));
        this.setSleeping(nbt.method_10577("Sleeping"));
        if (nbt.method_10545("HomeX") && nbt.method_10545("HomeY") && nbt.method_10545("HomeZ")) {
            this.setHomePos(new class_2338(nbt.method_10550("HomeX"), nbt.method_10550("HomeY"), nbt.method_10550("HomeZ")));
        }
    }

    static {
        STRIPPED_LOGS.put(class_2246.field_10431, class_2246.field_10519);
        STRIPPED_LOGS.put(class_2246.field_10037, class_2246.field_10436);
        STRIPPED_LOGS.put(class_2246.field_10511, class_2246.field_10366);
        STRIPPED_LOGS.put(class_2246.field_10306, class_2246.field_10254);
        STRIPPED_LOGS.put(class_2246.field_10533, class_2246.field_10622);
        STRIPPED_LOGS.put(class_2246.field_10010, class_2246.field_10244);
        STRIPPED_LOGS.put(class_2246.field_37545, class_2246.field_37548);
        STRIPPED_LOGS.put(class_2246.field_42729, class_2246.field_42732);
        STRIPPED_LOGS.put(ModBlocks.SPECTRAL_LOG, ModBlocks.STRIPPED_SPECTRAL_LOG);
        STRIPPED_LOGS.put(ModBlocks.PALM_LOG, ModBlocks.STRIPPED_PALM_LOG);
    }

    class BeaverMoveControl
    extends class_1335 {
        public BeaverMoveControl(BeaverEntity this$0) {
            super((class_1308)this$0);
        }
    }

    public static class StripLogGoal
    extends class_1352 {
        private final BeaverEntity beaver;
        private final double speed;
        private final int searchRadius;
        private class_2338 targetLogPos;
        private final Random random = new Random();
        private final class_1937 world;

        public StripLogGoal(BeaverEntity beaver, double speed, int searchRadius) {
            this.beaver = beaver;
            this.speed = speed;
            this.searchRadius = searchRadius;
            this.world = beaver.method_37908();
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (!this.world.method_8450().method_8355(class_1928.field_19388) || !ModConfig.INSTANCE.enableBeaverLogStripping) {
                return false;
            }
            if (this.beaver.method_59922().method_43048(100) < 5) {
                class_2338 beaverPos = this.beaver.method_24515();
                class_1937 world = this.beaver.method_37908();
                for (class_2338 pos : class_2338.method_25996((class_2338)beaverPos, (int)this.searchRadius, (int)this.searchRadius, (int)this.searchRadius)) {
                    class_2680 state = world.method_8320(pos);
                    if (!this.isLog(state) || !this.isReachable(beaverPos, pos)) continue;
                    this.targetLogPos = pos;
                    return true;
                }
            }
            return false;
        }

        public boolean method_6266() {
            return this.targetLogPos != null && this.isLog(this.beaver.method_37908().method_8320(this.targetLogPos));
        }

        public void method_6269() {
            if (this.targetLogPos != null) {
                this.beaver.method_5942().method_6337((double)this.targetLogPos.method_10263() + 0.5, (double)this.targetLogPos.method_10264(), (double)this.targetLogPos.method_10260() + 0.5, this.speed);
            }
        }

        public void method_6268() {
            if (this.targetLogPos != null && this.beaver.method_24515().method_19771((class_2382)this.targetLogPos, 1.5)) {
                this.stripLog(this.targetLogPos);
                this.targetLogPos = null;
            }
        }

        public void method_6270() {
            this.targetLogPos = null;
        }

        private boolean isLog(class_2680 state) {
            return state.method_26164(class_3481.field_15475);
        }

        private boolean isReachable(class_2338 beaverPos, class_2338 logPos) {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                if (!beaverPos.method_10093(direction).equals((Object)logPos)) continue;
                return true;
            }
            return false;
        }

        private void stripLog(class_2338 logPos) {
            class_1937 world = this.beaver.method_37908();
            class_2680 currentState = world.method_8320(logPos);
            class_2248 strippedLog = this.getStrippedLog(currentState.method_26204());
            if (strippedLog != null) {
                class_2680 newState = strippedLog.method_9564();
                if (currentState.method_28498((class_2769)class_2465.field_11459)) {
                    newState = (class_2680)newState.method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)currentState.method_11654((class_2769)class_2465.field_11459)));
                }
                world.method_8501(logPos, newState);
                world.method_8396(null, logPos, class_3417.field_14675, class_3419.field_15245, 1.0f, 1.0f);
                if (this.random.nextDouble() < 0.2) {
                    class_2248.method_9577((class_1937)world, (class_2338)logPos, (class_1799)new class_1799((class_1935)ModItems.SAWDUST));
                }
                class_2248.method_9577((class_1937)world, (class_2338)logPos, (class_1799)new class_1799((class_1935)ModItems.BARK, this.random.nextInt(2) + 1));
            }
        }

        private class_2248 getStrippedLog(class_2248 log) {
            return STRIPPED_LOGS.get(log);
        }
    }

    public static class StayNearHomeGoal
    extends class_1352 {
        private final BeaverEntity beaver;
        private final double speed;
        private final int innerRadius;
        private final int totalRadius;
        private class_2338 targetWaypoint;

        public StayNearHomeGoal(BeaverEntity beaver, double speed, int innerRadius, int outerRadiusOffset) {
            this.beaver = beaver;
            this.speed = speed;
            this.innerRadius = innerRadius;
            this.totalRadius = innerRadius + outerRadiusOffset;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_2338 currentHome;
            block6: {
                block5: {
                    if (this.beaver.method_60953()) {
                        return false;
                    }
                    currentHome = this.beaver.getHomePos();
                    if (currentHome.equals((Object)class_2338.field_10980)) break block5;
                    if (!this.isHomeBlockValid(currentHome)) break block6;
                }
                this.findNearestPileOfSticksAroundBeaver(this.totalRadius).ifPresentOrElse(this.beaver::setHomePos, () -> this.beaver.setHomePos(class_2338.field_10980));
                currentHome = this.beaver.getHomePos();
            }
            if (currentHome.equals((Object)class_2338.field_10980)) {
                return false;
            }
            double distSqToHome = this.beaver.method_24515().method_10262((class_2382)currentHome);
            return distSqToHome > (double)(this.innerRadius * this.innerRadius);
        }

        public void method_6269() {
            this.targetWaypoint = this.findRandomPositionNearHome(this.beaver.getHomePos(), this.innerRadius);
            if (this.targetWaypoint != null) {
                this.beaver.method_5942().method_6337((double)this.targetWaypoint.method_10263() + 0.5, (double)this.targetWaypoint.method_10264(), (double)this.targetWaypoint.method_10260() + 0.5, this.speed);
                this.beaver.method_5988().method_20248((double)this.targetWaypoint.method_10263() + 0.5, (double)this.targetWaypoint.method_10264() + 0.5, (double)this.targetWaypoint.method_10260() + 0.5);
            } else {
                this.beaver.method_5942().method_6340();
            }
        }

        public boolean method_6266() {
            if (this.beaver.method_60953()) {
                return false;
            }
            class_2338 currentHome = this.beaver.getHomePos();
            if (currentHome.equals((Object)class_2338.field_10980) || this.isHomeBlockValid(currentHome)) {
                return false;
            }
            double distSqToHome = this.beaver.method_24515().method_10262((class_2382)currentHome);
            if (distSqToHome > (double)(this.totalRadius * this.totalRadius)) {
                if (!this.beaver.method_37908().method_8608()) {
                    this.beaver.setHomePos(class_2338.field_10980);
                }
                return false;
            }
            if (distSqToHome <= (double)(this.innerRadius * this.innerRadius)) {
                return false;
            }
            if (this.beaver.method_5942().method_6357()) {
                this.targetWaypoint = this.findRandomPositionNearHome(currentHome, this.innerRadius);
                if (this.targetWaypoint != null) {
                    this.beaver.method_5942().method_6337((double)this.targetWaypoint.method_10263() + 0.5, (double)this.targetWaypoint.method_10264(), (double)this.targetWaypoint.method_10260() + 0.5, this.speed);
                    this.beaver.method_5988().method_20248((double)this.targetWaypoint.method_10263() + 0.5, (double)this.targetWaypoint.method_10264() + 0.5, (double)this.targetWaypoint.method_10260() + 0.5);
                } else {
                    return false;
                }
            }
            return true;
        }

        public void method_6270() {
            this.beaver.method_5942().method_6340();
            this.targetWaypoint = null;
        }

        private boolean isHomeBlockValid(class_2338 homePos) {
            return !this.beaver.method_37908().method_22340(homePos) || !this.beaver.method_37908().method_8320(homePos).method_27852(ModBlocks.PILE_OF_STICKS_BLOCK);
        }

        private Optional<class_2338> findNearestPileOfSticksAroundBeaver(int searchRadius) {
            class_2338 beaverPos = this.beaver.method_24515();
            class_1937 world = this.beaver.method_37908();
            class_238 searchBox = new class_238(beaverPos).method_1014((double)searchRadius);
            for (class_2338 p : class_2338.method_10094((int)((int)searchBox.field_1323), (int)((int)searchBox.field_1322), (int)((int)searchBox.field_1321), (int)((int)searchBox.field_1320), (int)((int)searchBox.field_1325), (int)((int)searchBox.field_1324))) {
                if (!world.method_8320(p).method_27852(ModBlocks.PILE_OF_STICKS_BLOCK)) continue;
                return Optional.of(p);
            }
            return Optional.empty();
        }

        private class_2338 findRandomPositionNearHome(class_2338 center, int radius) {
            if (center.equals((Object)class_2338.field_10980)) {
                return null;
            }
            class_1937 world = this.beaver.method_37908();
            for (int i = 0; i < 10; ++i) {
                class_2338 randomPos = center.method_10069(world.method_8409().method_43048(radius * 2 + 1) - radius, world.method_8409().method_43048(3) - 1, world.method_8409().method_43048(radius * 2 + 1) - radius);
                class_2680 blockState = world.method_8320(randomPos);
                class_2680 blockBelowState = world.method_8320(randomPos.method_10074());
                if (!blockState.method_26215() && !blockState.method_45474() || !blockBelowState.method_51367()) continue;
                return randomPos;
            }
            return null;
        }
    }
}

