/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.domixcze.domixscreatures.entity.ModEntities;
import net.domixcze.domixscreatures.entity.ai.BabyFollowParentGoal;
import net.domixcze.domixscreatures.entity.ai.BisonMeleeAttackGoal;
import net.domixcze.domixscreatures.entity.ai.EatsGrass;
import net.domixcze.domixscreatures.entity.ai.MobEatGrassGoal;
import net.domixcze.domixscreatures.entity.ai.ProtectBabiesGoal;
import net.domixcze.domixscreatures.entity.ai.SleepGoal;
import net.domixcze.domixscreatures.entity.ai.Sleepy;
import net.domixcze.domixscreatures.entity.ai.SnowLayerable;
import net.domixcze.domixscreatures.sound.ModSounds;
import net.domixcze.domixscreatures.util.ModTags;
import net.domixcze.domixscreatures.util.SnowLayerUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BisonEntity
extends class_1429
implements GeoEntity,
EatsGrass,
Sleepy,
SnowLayerable {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final class_2940<Boolean> HAS_SNOW_LAYER = class_2945.method_12791(BisonEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_CHARGING = class_2945.method_12791(BisonEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_PREPARING = class_2945.method_12791(BisonEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_EATING = class_2945.method_12791(BisonEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SLEEPING = class_2945.method_12791(BisonEntity.class, (class_2941)class_2943.field_13323);
    private static final class_4048 BABY_DIMENSIONS = class_4048.method_18385((float)0.8f, (float)0.9f);
    private static final class_4048 ADULT_DIMENSIONS = class_4048.method_18385((float)1.6f, (float)2.0f);
    private static final class_4048 SLEEPING_BABY_DIMENSIONS = class_4048.method_18385((float)0.8f, (float)0.7f);
    private static final class_4048 SLEEPING_ADULT_DIMENSIONS = class_4048.method_18385((float)1.6f, (float)1.6f);
    private int snowTicks = 0;
    private int snowMeltTimer = 0;
    private int chargeCooldown;
    private final int DEFAULT_CHARGE_COOLDOWN = 2000;
    private int lookingTimer;
    private final int DEFAULT_LOOKING_TIME = 40;
    private int runningTimer;
    private final int DEFAULT_RUNNING_TIME = 20;
    private int proximityTimer;
    public class_243 runDirection = class_243.field_1353;
    private float momentum = 0.0f;
    public final float CHARGE_SPEED = 0.8f;
    public final float MOMENTUM_DECREASE = 0.05f;

    public BisonEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 60.0).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_47761, 1.2);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SleepGoal(this, (class_1308)this, 150, false, true, false, false, 5.0, 600, 800, false, false, true, true, 3));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new ChargeGoal(this));
        this.field_6201.method_6277(3, (class_1352)new BisonMeleeAttackGoal(this, 1.0, true));
        this.field_6201.method_6277(4, (class_1352)new MobEatGrassGoal((class_1308)this));
        this.field_6201.method_6277(5, (class_1352)new BabyFollowParentGoal(this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 0.75));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, new ProtectBabiesGoal<BisonEntity>(this, BisonEntity.class, 8.0));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_SNOW_LAYER, (Object)false);
        builder.method_56912(IS_CHARGING, (Object)false);
        builder.method_56912(IS_PREPARING, (Object)false);
        builder.method_56912(IS_EATING, (Object)false);
        builder.method_56912(SLEEPING, (Object)false);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("HasSnowLayer", this.hasSnowLayer());
        nbt.method_10569("SnowTicks", this.snowTicks);
        nbt.method_10569("SnowMeltTimer", this.snowMeltTimer);
        nbt.method_10569("ProximityTimer", this.proximityTimer);
        nbt.method_10569("ChargeCooldown", this.chargeCooldown);
        nbt.method_10569("LookingTimer", this.lookingTimer);
        nbt.method_10569("RunningTimer", this.runningTimer);
        nbt.method_10556("IsCharging", this.isCharging());
        nbt.method_10556("IsPreparing", this.isPreparing());
        nbt.method_10548("Momentum", this.momentum);
        nbt.method_10556("Sleeping", this.method_6113());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setHasSnowLayer(nbt.method_10577("HasSnowLayer"));
        this.snowTicks = nbt.method_10550("SnowTicks");
        this.snowMeltTimer = nbt.method_10550("SnowMeltTimer");
        this.proximityTimer = nbt.method_10550("ProximityTimer");
        this.chargeCooldown = nbt.method_10550("ChargeCooldown");
        this.lookingTimer = nbt.method_10550("LookingTimer");
        this.runningTimer = nbt.method_10550("RunningTimer");
        this.setCharging(nbt.method_10577("IsCharging"));
        this.setPreparing(nbt.method_10577("IsPreparing"));
        this.momentum = nbt.method_10583("Momentum");
        this.setSleeping(nbt.method_10577("Sleeping"));
    }

    public void method_6005(double strength, double x, double z) {
        super.method_6005(strength * 0.1, x, z);
    }

    public boolean method_5810() {
        return false;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_42716) && this.hasSnowLayer()) {
            if (!this.method_37908().field_9236) {
                this.setHasSnowLayer(false);
                this.snowMeltTimer = 0;
                int count = 3 + this.method_37908().field_9229.method_43048(2);
                this.method_5775(new class_1799((class_1935)class_1802.field_8543, count));
            }
            SnowLayerUtil.spawnSnowParticles((class_1309)this);
            this.method_5783(class_3417.field_15165, 1.0f, 1.0f);
            if (!player.method_7337()) {
                itemStack.method_7970(1, (class_1309)player, class_1304.field_6173);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    @Override
    public boolean hasSnowLayer() {
        return (Boolean)this.field_6011.method_12789(HAS_SNOW_LAYER);
    }

    @Override
    public void setHasSnowLayer(boolean hasSnow) {
        this.field_6011.method_12778(HAS_SNOW_LAYER, (Object)hasSnow);
    }

    @Override
    public int getSnowTicks() {
        return this.snowTicks;
    }

    @Override
    public void setSnowTicks(int ticks) {
        this.snowTicks = ticks;
    }

    @Override
    public int getSnowMeltTimer() {
        return this.snowMeltTimer;
    }

    @Override
    public void setSnowMeltTimer(int timer) {
        this.snowMeltTimer = timer;
    }

    @Override
    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.method_5942().method_6340();
        }
    }

    @Override
    public void onEatGrass() {
        this.method_5783(class_3417.field_15037, 1.0f, 1.0f);
        if (this.method_6109()) {
            this.method_5615(60);
        }
    }

    @Override
    public boolean canEatGrass() {
        return this.method_6109();
    }

    @Override
    public boolean isEating() {
        return (Boolean)this.field_6011.method_12789(IS_EATING);
    }

    @Override
    public void setEating(boolean eating) {
        this.field_6011.method_12778(IS_EATING, (Object)eating);
    }

    public boolean isCharging() {
        return (Boolean)this.field_6011.method_12789(IS_CHARGING);
    }

    public void setCharging(boolean charging) {
        this.field_6011.method_12778(IS_CHARGING, (Object)charging);
    }

    public boolean isPreparing() {
        return (Boolean)this.field_6011.method_12789(IS_PREPARING);
    }

    public void setPreparing(boolean preparing) {
        this.field_6011.method_12778(IS_PREPARING, (Object)preparing);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController landController = new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate);
        landController.triggerableAnim("attack", RawAnimation.begin().then("animation.bison.attack", Animation.LoopType.PLAY_ONCE));
        controllers.add(landController);
        controllers.add(new AnimationController((GeoAnimatable)this, "water_controller", 5, this::waterPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "sleep_controller", 5, this::sleepPredicate));
    }

    private <P extends GeoAnimatable> PlayState landPredicate(AnimationState<P> state) {
        if (this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_18798().method_37268() > 1.0E-9) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_bison.walk", Animation.LoopType.LOOP));
            } else if (this.isEating()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_bison.eat", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_bison.idle", Animation.LoopType.LOOP));
            }
        } else if (this.isCharging()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.bison.charge", Animation.LoopType.LOOP));
        } else if (this.isPreparing()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.bison.prepare", Animation.LoopType.LOOP));
        } else if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.bison.walk", Animation.LoopType.LOOP));
        } else if (this.isEating()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.bison.eat", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.bison.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState waterPredicate(AnimationState<T> state) {
        if (!this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.baby_bison.swim", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.bison.swim", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState sleepPredicate(AnimationState<T> state) {
        if (this.method_6113()) {
            if (this.method_6109()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_bison.sleep", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.bison.sleep", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)ModEntities.BISON.method_5883((class_1937)world);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ModTags.Items.BISON_FOR_BREEDING);
    }

    public void method_5674(class_2940<?> data) {
        if (SLEEPING.equals(data)) {
            this.method_18382();
        }
        super.method_5674(data);
    }

    public class_4048 method_55694(class_4050 pose) {
        return this.getCustomDimensions(pose);
    }

    private class_4048 getCustomDimensions(class_4050 pose) {
        if (this.method_6113()) {
            return this.method_6109() ? SLEEPING_BABY_DIMENSIONS : SLEEPING_ADULT_DIMENSIONS;
        }
        return this.method_6109() ? BABY_DIMENSIONS : ADULT_DIMENSIONS;
    }

    protected class_3414 method_5994() {
        if (this.method_6113()) {
            return null;
        }
        return ModSounds.BISON_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.BISON_HURT;
    }

    protected class_3414 method_6002() {
        return ModSounds.BISON_DEATH;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_15110, 0.15f, 0.7f);
    }

    public void method_5773() {
        super.method_5773();
        SnowLayerUtil.handleSnowLayerTick((class_1309)this, this);
        if (!this.method_37908().field_9236) {
            if (!this.method_6109() && this.chargeCooldown > 0) {
                --this.chargeCooldown;
            }
            if (this.isPreparing()) {
                if (this.lookingTimer > 0) {
                    --this.lookingTimer;
                }
                if (this.lookingTimer <= 0) {
                    this.runDirection = this.method_5828(1.0f);
                    this.setPreparing(false);
                    this.setCharging(true);
                    this.runningTimer = 20;
                    this.momentum = 0.8f;
                    this.method_5942().method_6340();
                }
            }
            if (this.isCharging()) {
                if (this.runningTimer > 0 && this.momentum > 0.0f) {
                    --this.runningTimer;
                    class_243 horizontal = this.runDirection.method_1021((double)this.momentum);
                    this.method_18800(horizontal.field_1352, this.method_18798().field_1351, horizontal.field_1350);
                    this.momentum -= 0.05f;
                    if (this.momentum < 0.0f) {
                        this.momentum = 0.0f;
                    }
                    class_2338 front = this.method_24515().method_10069(class_3532.method_15357((double)(this.runDirection.field_1352 * 1.5)), 0, class_3532.method_15357((double)(this.runDirection.field_1350 * 1.5)));
                    class_2680 state = this.method_37908().method_8320(front);
                    if (!state.method_26220((class_1922)this.method_37908(), front).method_1110()) {
                        this.setCharging(false);
                        this.method_18799(class_243.field_1353);
                        this.chargeCooldown = this.DEFAULT_CHARGE_COOLDOWN;
                        return;
                    }
                    List hitEntities = this.method_37908().method_8390(class_1309.class, this.method_5829().method_1014(0.5), e -> e != this && e.method_5805());
                    Iterator iterator = hitEntities.iterator();
                    if (iterator.hasNext()) {
                        class_1309 target = (class_1309)iterator.next();
                        class_243 knockback = target.method_19538().method_1020(this.method_19538()).method_1029().method_1021(1.5);
                        target.method_6005(1.2, -knockback.field_1352, -knockback.field_1350);
                        target.method_5643(this.method_48923().method_48812((class_1309)this), 6.0f);
                        this.setCharging(false);
                        this.method_18799(class_243.field_1353);
                        this.chargeCooldown = this.DEFAULT_CHARGE_COOLDOWN;
                        return;
                    }
                } else {
                    this.setCharging(false);
                    this.chargeCooldown = this.DEFAULT_CHARGE_COOLDOWN;
                    this.method_18799(class_243.field_1353);
                }
            }
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_37908().field_9236 && this.isCharging()) {
            class_243 offset = new class_243(0.0, 0.1, 0.0);
            class_243 forward = this.method_5828(1.0f).method_1029();
            class_243 right = forward.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
            class_243 leftFoot = this.method_19538().method_1019(offset).method_1019(right.method_1021(-0.4));
            class_243 rightFoot = this.method_19538().method_1019(offset).method_1019(right.method_1021(0.4));
            this.method_37908().method_8406((class_2394)class_2398.field_17430, leftFoot.field_1352, leftFoot.field_1351, leftFoot.field_1350, 0.0, 0.0, 0.0);
            this.method_37908().method_8406((class_2394)class_2398.field_17430, rightFoot.field_1352, rightFoot.field_1351, rightFoot.field_1350, 0.0, 0.0, 0.0);
        }
        if (this.isCharging() && !this.runDirection.equals((Object)class_243.field_1353)) {
            double dx = this.runDirection.field_1352;
            double dz = this.runDirection.field_1350;
            float targetYaw = (float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            this.method_36456(targetYaw);
            this.field_5982 = targetYaw;
            this.method_5636(targetYaw);
            this.field_6220 = targetYaw;
            this.method_5847(targetYaw);
            this.field_6259 = targetYaw;
        }
    }

    public static class ChargeGoal
    extends class_1352 {
        private final BisonEntity bison;
        private class_1657 targetPlayer;
        private static final double DETECTION_RADIUS = 8.0;
        private static final int PROXIMITY_THRESHOLD = 200;

        public ChargeGoal(BisonEntity bison) {
            this.bison = bison;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.bison.method_6113()) {
                return false;
            }
            if (this.bison.method_5799()) {
                return false;
            }
            if (this.bison.method_6109()) {
                return false;
            }
            if (this.bison.chargeCooldown > 0) {
                return false;
            }
            this.targetPlayer = this.bison.method_37908().method_8604(this.bison.method_23317(), this.bison.method_23318(), this.bison.method_23321(), 8.0, class_1301.field_6156);
            if (this.targetPlayer == null || !this.bison.method_24828()) {
                this.bison.proximityTimer = 0;
                return false;
            }
            if ((double)this.targetPlayer.method_5739((class_1297)this.bison) <= 8.0) {
                ++this.bison.proximityTimer;
                return this.bison.proximityTimer >= 200;
            }
            this.bison.proximityTimer = 0;
            return false;
        }

        public boolean method_6266() {
            return this.bison.isPreparing() || this.bison.isCharging();
        }

        public void method_6269() {
            this.bison.setPreparing(true);
            this.bison.setCharging(false);
            this.bison.lookingTimer = this.bison.DEFAULT_LOOKING_TIME;
            this.bison.runDirection = class_243.field_1353;
            this.bison.proximityTimer = 0;
        }

        public void method_6270() {
            this.bison.setCharging(false);
            this.bison.setPreparing(false);
            this.bison.method_18799(class_243.field_1353);
            this.bison.field_6007 = true;
            this.targetPlayer = null;
            this.bison.proximityTimer = 0;
        }

        public void method_6268() {
            if (this.bison.isPreparing()) {
                if (this.bison.lookingTimer <= 0) {
                    this.bison.runDirection = this.bison.method_5828(1.0f);
                    this.bison.setPreparing(false);
                    this.bison.setCharging(true);
                    this.bison.method_5942().method_6340();
                } else if (this.targetPlayer != null) {
                    double targetYaw = class_3532.method_15349((double)(this.targetPlayer.method_23321() - this.bison.method_23321()), (double)(this.targetPlayer.method_23317() - this.bison.method_23317())) * 57.29577951308232 - 90.0;
                    this.bison.method_5710((float)targetYaw, this.bison.method_36455());
                    this.bison.method_5847((float)targetYaw);
                    this.bison.field_5982 = (float)targetYaw;
                    this.bison.field_6259 = (float)targetYaw;
                    this.bison.runDirection = this.bison.method_5828(1.0f);
                }
            }
        }
    }
}

