/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import java.time.LocalDate;
import net.domixcze.domixscreatures.block.ModBlocks;
import net.domixcze.domixscreatures.block.custom.CrocodileEggBlock;
import net.domixcze.domixscreatures.entity.ModEntities;
import net.domixcze.domixscreatures.entity.ai.CrocodileMeleeAttackGoal;
import net.domixcze.domixscreatures.entity.ai.SleepGoal;
import net.domixcze.domixscreatures.entity.ai.Sleepy;
import net.domixcze.domixscreatures.entity.client.crocodile.CrocodileVariants;
import net.domixcze.domixscreatures.item.ModItems;
import net.domixcze.domixscreatures.sound.ModSounds;
import net.domixcze.domixscreatures.util.ModTags;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1324;
import net.minecraft.class_1335;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1367;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1431;
import net.minecraft.class_1462;
import net.minecraft.class_1543;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5757;
import net.minecraft.class_5766;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CrocodileEntity
extends class_1429
implements GeoEntity,
Sleepy {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Boolean> OVERGROWN = class_2945.method_12791(CrocodileEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_EGG = class_2945.method_12791(CrocodileEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SLEEPING = class_2945.method_12791(CrocodileEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(CrocodileEntity.class, (class_2941)class_2943.field_13327);
    private int waterTimer = 0;
    private final int overgrownTimer;

    public CrocodileEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new CrocodileMoveControl(this);
        this.overgrownTimer = class_5819.method_43047().method_39332(1000, 1200);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SleepGoal(this, (class_1308)this, 120, false, true, true, false, 3.0, 500, 700, true, false, false, true, 2));
        this.field_6201.method_6277(1, (class_1352)new CrocodileMateGoal(this, 1.0));
        this.field_6201.method_6277(1, (class_1352)new CrocodileLayEggGoal(this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new CrocodileMeleeAttackGoal(this, 1.0, true));
        this.field_6201.method_6277(2, (class_1352)new class_1394((class_1314)this, 0.75, 1.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1543.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1462.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1431.class, true));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23721, 4.0).method_26867(class_5134.field_23722).method_26868(class_5134.field_23719, (double)0.2f);
    }

    public void method_6007() {
        super.method_6007();
        class_1324 movementSpeed = this.method_5996(class_5134.field_23719);
        if (movementSpeed != null) {
            if (this.method_6109()) {
                if (this.method_24828()) {
                    movementSpeed.method_6192((double)0.15f);
                } else if (this.method_5799()) {
                    movementSpeed.method_6192((double)1.2f);
                }
            } else if (this.method_24828()) {
                movementSpeed.method_6192((double)0.2f);
            } else if (this.method_5799()) {
                movementSpeed.method_6192(1.5);
            }
        }
    }

    public boolean method_5931() {
        return !this.method_6113();
    }

    public boolean method_5675() {
        return false;
    }

    protected class_1408 method_5965(class_1937 world) {
        return new class_5766((class_1308)this, world);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_5799()) {
            this.field_6207 = new class_5757((class_1308)this, 85, 10, 5.0f, 0.1f, true);
        } else if (this.method_24828()) {
            this.field_6207 = new CrocodileMoveControl(this);
        }
        if (this.method_5799() && !this.method_6109()) {
            if (!this.isOvergrown()) {
                ++this.waterTimer;
                if (this.waterTimer >= this.overgrownTimer) {
                    this.setOvergrown(true);
                }
            }
        } else if (!this.isOvergrown()) {
            this.waterTimer = 0;
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (this.isOvergrown() && itemStack.method_31574(class_1802.field_8868)) {
            this.setOvergrown(false);
            this.waterTimer = 0;
            class_5819 random = class_5819.method_43047();
            int mossCarpetAmount = random.method_39332(1, 5);
            for (int i = 0; i < mossCarpetAmount; ++i) {
                this.method_5706((class_1935)class_1802.field_28653);
            }
            if (random.method_43057() < 0.5f) {
                int scaleAmount = random.method_39332(1, 3);
                if (this.getVariant() == CrocodileVariants.ALBINO) {
                    for (int i = 0; i < scaleAmount; ++i) {
                        this.method_5706((class_1935)ModItems.CROCODILE_SCALE_ALBINO);
                    }
                } else {
                    for (int i = 0; i < scaleAmount; ++i) {
                        this.method_5706((class_1935)ModItems.CROCODILE_SCALE);
                    }
                }
            }
            itemStack.method_7970(1, (class_1309)player, class_1304.field_6173);
            this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
            this.method_5783(class_3417.field_14975, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    @Override
    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.method_5942().method_6340();
        }
    }

    public void setOvergrown(boolean isOvergrown) {
        this.method_5841().method_12778(OVERGROWN, (Object)isOvergrown);
    }

    public boolean isOvergrown() {
        return (Boolean)this.method_5841().method_12789(OVERGROWN);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(OVERGROWN, (Object)false);
        builder.method_56912(HAS_EGG, (Object)false);
        builder.method_56912(SLEEPING, (Object)false);
        builder.method_56912(VARIANT, (Object)CrocodileVariants.NORMAL.getId());
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)ModEntities.CROCODILE.method_5883((class_1937)world);
    }

    public CrocodileVariants getVariant() {
        return CrocodileVariants.byId((Integer)this.field_6011.method_12789(VARIANT));
    }

    public void setVariant(CrocodileVariants variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        entityData = super.method_5943(world, difficulty, spawnReason, entityData);
        if (spawnReason == class_3730.field_16459 || spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16472) {
            boolean isHalloweenPeriod;
            class_5819 random = world.method_8409();
            LocalDate date = LocalDate.now();
            int day = date.getDayOfMonth();
            int month = date.getMonthValue();
            boolean bl = isHalloweenPeriod = month == 10 && day >= 30 || month == 11 && day == 1;
            if (isHalloweenPeriod && random.method_43057() < 0.05f) {
                this.setVariant(CrocodileVariants.HALLOWEEN);
            } else {
                class_6880 biomeEntry = world.method_23753(this.method_24515());
                if (random.method_43058() < 0.05) {
                    this.setVariant(CrocodileVariants.ALBINO);
                } else if (biomeEntry.method_40220(ModTags.Biomes.SPAWNS_SAVANNA_CROCODILE)) {
                    this.setVariant(CrocodileVariants.SAVANNA);
                } else {
                    this.setVariant(CrocodileVariants.NORMAL);
                }
            }
        }
        return entityData;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("WaterTimer", this.waterTimer);
        nbt.method_10556("IsOvergrown", this.isOvergrown());
        nbt.method_10556("HasEgg", this.hasEgg());
        nbt.method_10556("Sleeping", this.method_6113());
        nbt.method_10569("Variant", this.getVariant().getId());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.waterTimer = nbt.method_10550("WaterTimer");
        this.setOvergrown(nbt.method_10577("IsOvergrown"));
        this.setHasEgg(nbt.method_10577("HasEgg"));
        this.setSleeping(nbt.method_10577("Sleeping"));
        this.setVariant(CrocodileVariants.byId(nbt.method_10550("Variant")));
    }

    public void method_6005(double strength, double x, double z) {
        super.method_6005(strength * 0.2, x, z);
    }

    protected class_4048 method_55694(class_4050 pose) {
        if (this.method_6109()) {
            return class_4048.method_18385((float)0.75f, (float)0.35f);
        }
        return this.method_5864().method_18386();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController landController = new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate);
        landController.triggerableAnim("attack", RawAnimation.begin().then("animation.crocodile.attack", Animation.LoopType.PLAY_ONCE));
        controllers.add(landController);
        controllers.add(new AnimationController((GeoAnimatable)this, "water_controller", 5, this::waterPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "sleep_controller", 5, this::sleepPredicate));
    }

    private <T extends GeoAnimatable> PlayState landPredicate(AnimationState<T> state) {
        if (this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_18798().method_37268() > 1.0E-6) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_crocodile.walk", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_crocodile.idle", Animation.LoopType.LOOP));
            }
        } else if (this.method_18798().method_37268() > 1.0E-6) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.crocodile.walk", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.crocodile.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState sleepPredicate(AnimationState<T> state) {
        if (this.method_6113()) {
            if (this.method_6109()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_crocodile.sleep", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.crocodile.sleep", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <T extends GeoAnimatable> PlayState waterPredicate(AnimationState<T> state) {
        if (!this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_18798().method_37268() > 1.0E-9) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_crocodile.swim", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_crocodile.idle_swim", Animation.LoopType.LOOP));
            }
        } else if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.crocodile.swim", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.crocodile.idle_swim", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ModTags.Items.CROCODILE_FOR_BREEDING);
    }

    public boolean hasEgg() {
        return (Boolean)this.field_6011.method_12789(HAS_EGG);
    }

    void setHasEgg(boolean hasEgg) {
        this.field_6011.method_12778(HAS_EGG, (Object)hasEgg);
    }

    public float method_6017() {
        return 1.0f;
    }

    protected class_3414 method_5994() {
        if (this.method_6113()) {
            return null;
        }
        if (this.getVariant() == CrocodileVariants.HALLOWEEN) {
            return class_3417.field_15200;
        }
        return ModSounds.CROCODILE_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return this.getVariant() == CrocodileVariants.HALLOWEEN ? class_3417.field_15069 : ModSounds.CROCODILE_HURT;
    }

    protected class_3414 method_6002() {
        return this.getVariant() == CrocodileVariants.HALLOWEEN ? class_3417.field_14877 : ModSounds.CROCODILE_DEATH;
    }

    class CrocodileMoveControl
    extends class_1335 {
        public CrocodileMoveControl(CrocodileEntity this$0) {
            super((class_1308)this$0);
        }
    }

    private static class CrocodileMateGoal
    extends class_1341 {
        private final CrocodileEntity crocodile;

        CrocodileMateGoal(CrocodileEntity crocodile, double speed) {
            super((class_1429)crocodile, speed);
            this.crocodile = crocodile;
        }

        public boolean method_6264() {
            return super.method_6264() && !this.crocodile.hasEgg();
        }

        protected void method_6249() {
            class_3222 serverPlayerEntity = this.field_6404.method_6478();
            if (serverPlayerEntity == null && this.field_6406.method_6478() != null) {
                serverPlayerEntity = this.field_6406.method_6478();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.method_7281(class_3468.field_15410);
                class_174.field_1190.method_855(serverPlayerEntity, this.field_6404, this.field_6406, (class_1296)null);
            }
            if (this.field_6404.method_59922().method_43056()) {
                this.crocodile.setHasEgg(true);
            } else {
                ((CrocodileEntity)this.field_6406).setHasEgg(true);
            }
            this.field_6404.method_5614(6000);
            this.field_6406.method_5614(6000);
            this.field_6404.method_6477();
            this.field_6406.method_6477();
            class_5819 random = this.field_6404.method_59922();
            if (this.field_6405.method_8450().method_8355(class_1928.field_19391)) {
                this.field_6405.method_8649((class_1297)new class_1303(this.field_6405, this.field_6404.method_23317(), this.field_6404.method_23318(), this.field_6404.method_23321(), random.method_43048(7) + 1));
            }
        }
    }

    private static class CrocodileLayEggGoal
    extends class_1367 {
        private final CrocodileEntity crocodile;

        CrocodileLayEggGoal(CrocodileEntity crocodile, double speed) {
            super((class_1314)crocodile, speed, 16);
            this.crocodile = crocodile;
        }

        public boolean method_6264() {
            return this.crocodile.hasEgg() && super.method_6264();
        }

        public boolean method_6266() {
            return super.method_6266() && this.crocodile.hasEgg();
        }

        public void method_6268() {
            super.method_6268();
            class_2338 blockPos = this.crocodile.method_24515();
            if (this.method_6295()) {
                class_1937 world = this.crocodile.method_37908();
                world.method_8396(null, blockPos, class_3417.field_14634, class_3419.field_15245, 0.3f, 0.9f + world.field_9229.method_43057() * 0.2f);
                int eggCount = world.field_9229.method_43048(3) + 1;
                class_2338 eggPos = this.field_6512.method_10086(1);
                class_2680 eggState = (class_2680)ModBlocks.CROCODILE_EGG.method_9564().method_11657((class_2769)CrocodileEggBlock.EGGS, (Comparable)Integer.valueOf(eggCount));
                world.method_8652(eggPos, eggState, 3);
                this.crocodile.setHasEgg(false);
                this.crocodile.method_6476(600);
            }
        }

        protected boolean method_6296(class_4538 world, class_2338 pos) {
            return world.method_8320(pos).method_26164(ModTags.Blocks.CROCODILE_EGG_HATCHABLE);
        }
    }
}

