/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.domixcze.domixscreatures.entity.ModEntities;
import net.domixcze.domixscreatures.entity.ai.BabyFollowParentGoal;
import net.domixcze.domixscreatures.entity.ai.GorillaMeleeAttackGoal;
import net.domixcze.domixscreatures.entity.ai.SleepGoal;
import net.domixcze.domixscreatures.entity.ai.Sleepy;
import net.domixcze.domixscreatures.entity.ai.SnowLayerable;
import net.domixcze.domixscreatures.item.ModItems;
import net.domixcze.domixscreatures.util.ModTags;
import net.domixcze.domixscreatures.util.SnowLayerUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GorillaEntity
extends class_1429
implements GeoEntity,
Sleepy,
SnowLayerable {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final class_2940<Boolean> HAS_SNOW_LAYER = class_2945.method_12791(GorillaEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SLEEPING = class_2945.method_12791(GorillaEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_EATING = class_2945.method_12791(GorillaEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_SITTING = class_2945.method_12791(GorillaEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_CHEST_BANGING = class_2945.method_12791(GorillaEntity.class, (class_2941)class_2943.field_13323);
    private static final class_4048 BABY_DIMENSIONS = class_4048.method_18385((float)0.5f, (float)0.5f);
    private static final class_4048 ADULT_DIMENSIONS = class_4048.method_18385((float)1.2f, (float)1.5f);
    private static final class_4048 SLEEPING_BABY_DIMENSIONS = class_4048.method_18385((float)0.5f, (float)0.5f);
    private static final class_4048 SLEEPING_ADULT_DIMENSIONS = class_4048.method_18385((float)1.2f, (float)1.0f);
    private int snowTicks = 0;
    private int snowMeltTimer = 0;
    private int eatingTimer = 0;
    private int sittingTimer = 0;
    private int chestBangTimer = 0;
    private int rideParentCooldown = 0;
    private static final int MAX_RIDE_PARENT_COOLDOWN = 100;
    private static final int MAX_CHEST_BANG_TIMER = 60;
    private final int MAX_EATING_TIMER = 200;
    private final int MAX_SITTING_TIMER = 1000;
    private int currentSittingCooldown = this.getRandomSittingCooldown(this.field_5974);
    private int currentChestBangCooldown = this.getRandomChestBangCooldown(this.field_5974);
    private static final int MIN_SITTING_COOLDOWN = 600;
    private static final int MAX_SITTING_COOLDOWN_RANGE = 1200;
    private static final int MIN_CHEST_BANG_COOLDOWN = 2400;
    private static final int MAX_CHEST_BANG_COOLDOWN_RANGE = 3600;

    public GorillaEntity(class_1299<? extends class_1429> type, class_1937 world) {
        super(type, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23719, 0.2);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SleepGoal(this, (class_1308)this, 120, false, true, true, false, 5.0, 600, 800, true, false, true, true, 2));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new GorillaEatGoal(this));
        this.field_6201.method_6277(2, (class_1352)new GorillaSitGoal(this));
        this.field_6201.method_6277(3, (class_1352)new GorillaChestBangGoal(this));
        this.field_6201.method_6277(4, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new GorillaMeleeAttackGoal(this, 1.0, true));
        this.field_6201.method_6277(6, (class_1352)new BabyFollowParentGoal(this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new RideParentGoal(this));
        this.field_6201.method_6277(8, (class_1352)new class_1394((class_1314)this, 0.75));
        this.field_6201.method_6277(9, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    public boolean method_5931() {
        return false;
    }

    public void method_6005(double strength, double x, double z) {
        super.method_6005(strength * 0.1, x, z);
    }

    public boolean method_5810() {
        return false;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (!(!itemStack.method_31574(ModItems.BANANA) || this.method_6109() || this.method_6113() || this.isEating() || this.isChestBanging() || this.method_5782())) {
            this.currentSittingCooldown = this.getRandomSittingCooldown(this.field_5974);
            this.setSitting(true);
            this.setEating(true);
            this.eatingTimer = 0;
            this.sittingTimer = 0;
            this.method_5942().method_6340();
            if (!player.method_7337()) {
                itemStack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        if (itemStack.method_31574(class_1802.field_42716) && this.hasSnowLayer()) {
            if (!this.method_37908().field_9236) {
                this.setHasSnowLayer(false);
                this.snowMeltTimer = 0;
                int count = 3 + this.method_37908().field_9229.method_43048(2);
                this.method_5775(new class_1799((class_1935)class_1802.field_8543, count));
            }
            SnowLayerUtil.spawnSnowParticles((class_1309)this);
            this.method_5783(class_3417.field_15165, 1.0f, 1.0f);
            if (!player.method_7337()) {
                itemStack.method_7970(1, (class_1309)player, class_1304.field_6173);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    @Override
    public boolean hasSnowLayer() {
        return (Boolean)this.field_6011.method_12789(HAS_SNOW_LAYER);
    }

    @Override
    public void setHasSnowLayer(boolean hasSnow) {
        this.field_6011.method_12778(HAS_SNOW_LAYER, (Object)hasSnow);
    }

    @Override
    public int getSnowTicks() {
        return this.snowTicks;
    }

    @Override
    public void setSnowTicks(int ticks) {
        this.snowTicks = ticks;
    }

    @Override
    public int getSnowMeltTimer() {
        return this.snowMeltTimer;
    }

    @Override
    public void setSnowMeltTimer(int timer) {
        this.snowMeltTimer = timer;
    }

    @Override
    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.method_5942().method_6340();
        }
    }

    public boolean isEating() {
        return (Boolean)this.field_6011.method_12789(IS_EATING);
    }

    public void setEating(boolean eating) {
        this.field_6011.method_12778(IS_EATING, (Object)eating);
    }

    public boolean isSitting() {
        return (Boolean)this.field_6011.method_12789(IS_SITTING);
    }

    public void setSitting(boolean sitting) {
        this.field_6011.method_12778(IS_SITTING, (Object)sitting);
        if (sitting) {
            this.method_5942().method_6340();
        }
    }

    public boolean isChestBanging() {
        return (Boolean)this.field_6011.method_12789(IS_CHEST_BANGING);
    }

    public void setChestBanging(boolean banging) {
        this.field_6011.method_12778(IS_CHEST_BANGING, (Object)banging);
        if (banging) {
            this.method_5942().method_6340();
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.rideParentCooldown > 0) {
            --this.rideParentCooldown;
        }
        if (this.currentChestBangCooldown > 0) {
            --this.currentChestBangCooldown;
        }
        if (this.isChestBanging()) {
            ++this.chestBangTimer;
            if (this.chestBangTimer >= 60) {
                this.setChestBanging(false);
                this.chestBangTimer = 0;
                this.currentChestBangCooldown = this.getRandomChestBangCooldown(this.field_5974);
            }
        }
        if (this.isEating()) {
            ++this.eatingTimer;
            if (this.eatingTimer >= 200) {
                this.setEating(false);
                this.eatingTimer = 0;
            }
        }
        if (this.currentSittingCooldown > 0) {
            --this.currentSittingCooldown;
        }
        if (this.isSitting()) {
            ++this.sittingTimer;
            if (this.sittingTimer >= 1000) {
                this.setSitting(false);
                this.sittingTimer = 0;
                this.currentSittingCooldown = this.getRandomSittingCooldown(this.field_5974);
            }
        }
        SnowLayerUtil.handleSnowLayerTick((class_1309)this, this);
    }

    private int getRandomSittingCooldown(class_5819 random) {
        return 600 + random.method_43048(1200);
    }

    private int getRandomChestBangCooldown(class_5819 random) {
        return 2400 + random.method_43048(3600);
    }

    public void method_5842() {
        class_1297 class_12972;
        super.method_5842();
        if (!this.method_6109()) {
            this.method_5848();
            this.rideParentCooldown = 100;
            return;
        }
        if (this.field_6235 > 0) {
            this.method_5848();
            this.rideParentCooldown = 100;
            return;
        }
        if (this.method_6113()) {
            this.method_5848();
            this.rideParentCooldown = 100;
            return;
        }
        if (this.method_5765() && (class_12972 = this.method_5854()) instanceof GorillaEntity) {
            GorillaEntity parent = (GorillaEntity)class_12972;
            if (parent.method_6113()) {
                this.method_5848();
                this.rideParentCooldown = 100;
                return;
            }
            if (parent.method_5799() || parent.field_6235 > 0) {
                this.method_5848();
                this.rideParentCooldown = 100;
                return;
            }
            float parentYaw = parent.method_5791();
            this.method_5847(parentYaw);
            this.method_5636(parentYaw);
            this.method_36456(parentYaw);
        }
    }

    protected class_243 method_52533(class_1297 passenger, class_4048 dimensions, float scaleFactor) {
        GorillaEntity baby;
        class_243 base = super.method_52533(passenger, dimensions, scaleFactor);
        if (passenger instanceof GorillaEntity && (baby = (GorillaEntity)passenger).method_6109()) {
            class_243 offset = new class_243(0.0, -0.45, -0.3).method_1021((double)scaleFactor).method_1024(-this.method_36454() * ((float)Math.PI / 180));
            return base.method_1019(offset);
        }
        return base;
    }

    public void method_5674(class_2940<?> data) {
        if (SLEEPING.equals(data)) {
            this.method_18382();
        }
        super.method_5674(data);
    }

    public class_4048 method_55694(class_4050 pose) {
        return this.getCustomDimensions(pose);
    }

    private class_4048 getCustomDimensions(class_4050 pose) {
        if (this.method_6113()) {
            return this.method_6109() ? SLEEPING_BABY_DIMENSIONS : SLEEPING_ADULT_DIMENSIONS;
        }
        return this.method_6109() ? BABY_DIMENSIONS : ADULT_DIMENSIONS;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_SNOW_LAYER, (Object)false);
        builder.method_56912(SLEEPING, (Object)false);
        builder.method_56912(IS_EATING, (Object)false);
        builder.method_56912(IS_SITTING, (Object)false);
        builder.method_56912(IS_CHEST_BANGING, (Object)false);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("HasSnowLayer", this.hasSnowLayer());
        nbt.method_10569("SnowTicks", this.snowTicks);
        nbt.method_10569("SnowMeltTimer", this.snowMeltTimer);
        nbt.method_10556("Sleeping", this.method_6113());
        nbt.method_10556("IsEating", this.isEating());
        nbt.method_10569("EatingTimer", this.eatingTimer);
        nbt.method_10556("IsSitting", this.isSitting());
        nbt.method_10569("SittingTimer", this.sittingTimer);
        nbt.method_10569("SittingCooldown", this.currentSittingCooldown);
        nbt.method_10569("ChestBangTimer", this.chestBangTimer);
        nbt.method_10569("ChestBangCooldown", this.currentChestBangCooldown);
        nbt.method_10556("IsChestBanging", this.isChestBanging());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setHasSnowLayer(nbt.method_10577("HasSnowLayer"));
        this.snowTicks = nbt.method_10550("SnowTicks");
        this.snowMeltTimer = nbt.method_10550("SnowMeltTimer");
        this.setSleeping(nbt.method_10577("Sleeping"));
        this.setEating(nbt.method_10577("IsEating"));
        this.eatingTimer = nbt.method_10550("EatingTimer");
        this.setSitting(nbt.method_10577("IsSitting"));
        this.sittingTimer = nbt.method_10550("SittingTimer");
        this.currentSittingCooldown = nbt.method_10550("SittingCooldown");
        this.chestBangTimer = nbt.method_10550("ChestBangTimer");
        this.currentChestBangCooldown = nbt.method_10550("ChestBangCooldown");
        this.setChestBanging(nbt.method_10577("IsChestBanging"));
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ModTags.Items.GORILLA_FOR_BREEDING);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)ModEntities.GORILLA.method_5883((class_1937)world);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController landController = new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate);
        landController.triggerableAnim("attack", RawAnimation.begin().then("animation.gorilla.attack", Animation.LoopType.PLAY_ONCE));
        controllers.add(landController);
        controllers.add(new AnimationController((GeoAnimatable)this, "sleep_controller", 5, this::sleepPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "water_controller", 5, this::waterPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "ride_controller", 5, this::ridePredicate));
    }

    private <T extends GeoAnimatable> PlayState landPredicate(AnimationState<T> state) {
        if (this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_18798().method_37268() > 1.0E-9) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_gorilla.walk", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_gorilla.idle", Animation.LoopType.LOOP));
            }
        } else if (this.isEating()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.gorilla.eat", Animation.LoopType.LOOP));
        } else if (this.isSitting()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.gorilla.sit", Animation.LoopType.LOOP));
        } else if (this.isChestBanging()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.gorilla.chest_bang", Animation.LoopType.LOOP));
        } else if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.gorilla.walk", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.gorilla.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState ridePredicate(AnimationState<T> state) {
        if (this.method_5765() && this.method_6109()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.baby_gorilla.ride", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <T extends GeoAnimatable> PlayState sleepPredicate(AnimationState<T> state) {
        if (this.method_6113()) {
            if (this.method_6109()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_gorilla.sleep", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.gorilla.sleep", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <T extends GeoAnimatable> PlayState waterPredicate(AnimationState<T> state) {
        if (!this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_5799()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_gorilla.swim", Animation.LoopType.LOOP));
            }
        } else if (this.method_5799()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.gorilla.swim", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    public static class GorillaEatGoal
    extends class_1352 {
        private final GorillaEntity gorilla;
        private int eatingSoundCooldown = 10;

        public GorillaEatGoal(GorillaEntity gorilla) {
            this.gorilla = gorilla;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.gorilla.isEating() && !this.gorilla.method_6113() && !this.gorilla.method_6109() && !this.gorilla.method_5782();
        }

        public void method_6269() {
            this.gorilla.method_5942().method_6340();
        }

        public void method_6270() {
            this.gorilla.setEating(false);
        }

        public boolean method_6266() {
            return this.gorilla.isEating() && !this.gorilla.method_6113();
        }

        public void method_6268() {
            this.gorilla.method_5942().method_6340();
            this.gorilla.method_5988().method_6231();
            if (this.eatingSoundCooldown <= 0) {
                this.gorilla.method_37908().method_43128(null, this.gorilla.method_23317(), this.gorilla.method_23318(), this.gorilla.method_23321(), class_3417.field_16439, this.gorilla.method_5634(), 1.0f, 1.0f);
                this.eatingSoundCooldown = 10;
            } else {
                --this.eatingSoundCooldown;
            }
        }
    }

    public static class GorillaSitGoal
    extends class_1352 {
        private final GorillaEntity gorilla;

        public GorillaSitGoal(GorillaEntity gorilla) {
            this.gorilla = gorilla;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return !this.gorilla.method_6109() && !this.gorilla.method_6113() && !this.gorilla.method_5782() && (this.gorilla.isSitting() || this.gorilla.isEating() || this.gorilla.currentSittingCooldown <= 0 && this.gorilla.method_24828());
        }

        public boolean method_6266() {
            return (this.gorilla.isSitting() || this.gorilla.isEating()) && !this.gorilla.method_6113();
        }

        public void method_6269() {
            if (!this.gorilla.isSitting()) {
                this.gorilla.setSitting(true);
                this.gorilla.sittingTimer = 0;
            }
            this.gorilla.method_5942().method_6340();
        }

        public void method_6270() {
            if (this.gorilla.isSitting() && !this.gorilla.isEating()) {
                this.gorilla.setSitting(false);
                this.gorilla.currentSittingCooldown = this.gorilla.getRandomSittingCooldown(this.gorilla.field_5974);
                this.gorilla.sittingTimer = 0;
            }
        }

        public void method_6268() {
            this.gorilla.method_5942().method_6340();
            this.gorilla.method_5988().method_6231();
            if (this.gorilla.isSitting()) {
                ++this.gorilla.sittingTimer;
                if (this.gorilla.sittingTimer >= this.gorilla.MAX_SITTING_TIMER && !this.gorilla.isEating()) {
                    this.gorilla.setSitting(false);
                    this.gorilla.currentSittingCooldown = this.gorilla.getRandomSittingCooldown(this.gorilla.field_5974);
                    this.gorilla.sittingTimer = 0;
                }
            }
        }
    }

    public static class GorillaChestBangGoal
    extends class_1352 {
        private final GorillaEntity gorilla;

        public GorillaChestBangGoal(GorillaEntity gorilla) {
            this.gorilla = gorilla;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return !this.gorilla.method_6113() && !this.gorilla.method_6109() && !this.gorilla.isEating() && !this.gorilla.isSitting() && !this.gorilla.method_5782() && this.gorilla.currentChestBangCooldown <= 0 && !this.gorilla.isChestBanging();
        }

        public boolean method_6266() {
            return this.gorilla.isChestBanging();
        }

        public void method_6269() {
            this.gorilla.setChestBanging(true);
            this.gorilla.chestBangTimer = 0;
            this.gorilla.method_5942().method_6340();
        }

        public void method_6270() {
            this.gorilla.setChestBanging(false);
            this.gorilla.currentChestBangCooldown = this.gorilla.getRandomChestBangCooldown(this.gorilla.field_5974);
            this.gorilla.chestBangTimer = 0;
        }

        public void method_6268() {
            this.gorilla.method_5942().method_6340();
            this.gorilla.method_5988().method_6231();
        }
    }

    public static class RideParentGoal
    extends class_1352 {
        private final GorillaEntity child;
        private GorillaEntity nearestParent;

        public RideParentGoal(GorillaEntity child) {
            this.child = child;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            if (!this.child.method_6109() || this.child.method_5765()) {
                return false;
            }
            if (this.child.rideParentCooldown > 0) {
                return false;
            }
            Predicate<GorillaEntity> parentPredicate = g -> !g.method_6109() && g != this.child && g.method_5805() && !g.method_5782() && !g.isSitting() && !g.isEating() && !g.isChestBanging() && !g.method_6113();
            List nearbyAdults = this.child.method_37908().method_8390(GorillaEntity.class, this.child.method_5829().method_1009(4.0, 2.0, 4.0), parentPredicate);
            Iterator iterator = nearbyAdults.iterator();
            if (iterator.hasNext()) {
                GorillaEntity adult;
                this.nearestParent = adult = (GorillaEntity)iterator.next();
                return true;
            }
            return false;
        }

        public boolean method_6266() {
            return this.child.method_6109() && this.child.method_5765() && this.child.method_5854() instanceof GorillaEntity;
        }

        public void method_6269() {
            double distanceSq;
            if (this.nearestParent != null && !this.nearestParent.method_5782() && (distanceSq = this.child.method_5858((class_1297)this.nearestParent)) <= 2.25) {
                this.child.method_5873((class_1297)this.nearestParent, true);
            }
        }

        public void method_6270() {
            this.nearestParent = null;
        }
    }
}

