/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import net.domixcze.domixscreatures.entity.ModEntities;
import net.domixcze.domixscreatures.entity.ai.BabyFollowParentGoal;
import net.domixcze.domixscreatures.entity.ai.MooseMeleeAttackGoal;
import net.domixcze.domixscreatures.entity.ai.ProtectBabiesGoal;
import net.domixcze.domixscreatures.entity.ai.SleepGoal;
import net.domixcze.domixscreatures.entity.ai.Sleepy;
import net.domixcze.domixscreatures.entity.ai.SnowLayerable;
import net.domixcze.domixscreatures.entity.client.moose.MooseAntlerSize;
import net.domixcze.domixscreatures.entity.client.moose.MooseVariants;
import net.domixcze.domixscreatures.sound.ModSounds;
import net.domixcze.domixscreatures.util.ModTags;
import net.domixcze.domixscreatures.util.SnowLayerUtil;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MooseEntity
extends class_1429
implements GeoEntity,
SnowLayerable,
Sleepy {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int snowTicks = 0;
    private int snowMeltTimer = 0;
    public static final class_2940<Boolean> HAS_SNOW_LAYER = class_2945.method_12791(MooseEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SLEEPING = class_2945.method_12791(MooseEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(MooseEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> ANTLER_SIZE = class_2945.method_12791(MooseEntity.class, (class_2941)class_2943.field_13327);
    private static final class_4048 BABY_DIMENSIONS = class_4048.method_18385((float)0.8f, (float)1.4f);
    private static final class_4048 ADULT_DIMENSIONS = class_4048.method_18385((float)1.4f, (float)2.0f);
    private static final class_4048 SLEEPING_BABY_DIMENSIONS = class_4048.method_18385((float)0.8f, (float)0.7f);
    private static final class_4048 SLEEPING_ADULT_DIMENSIONS = class_4048.method_18385((float)1.4f, (float)1.0f);

    public MooseEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 50.0).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_47761, 1.2);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SleepGoal(this, (class_1308)this, 120, true, false, true, false, 5.0, 500, 700, true, false, true, true, 2));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new MooseMeleeAttackGoal(this, 1.0, true));
        this.field_6201.method_6277(3, (class_1352)new BabyFollowParentGoal(this, 1.25));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 0.75, 1.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, new ProtectBabiesGoal<MooseEntity>(this, MooseEntity.class, 8.0));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_SNOW_LAYER, (Object)false);
        builder.method_56912(SLEEPING, (Object)false);
        builder.method_56912(VARIANT, (Object)MooseVariants.BROWN.ordinal());
        builder.method_56912(ANTLER_SIZE, (Object)MooseAntlerSize.NONE.ordinal());
    }

    public void method_6005(double strength, double x, double z) {
        super.method_6005(strength * 0.2, x, z);
    }

    public boolean method_5931() {
        return !this.method_6113();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController landController = new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate);
        landController.triggerableAnim("attack", RawAnimation.begin().then("animation.moose.attack", Animation.LoopType.PLAY_ONCE));
        controllers.add(landController);
        controllers.add(new AnimationController((GeoAnimatable)this, "water_controller", 5, this::waterPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "sleep_controller", 5, this::sleepPredicate));
    }

    private <T extends GeoAnimatable> PlayState landPredicate(AnimationState<T> state) {
        if (this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_18798().method_37268() > 1.0E-9) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_moose.walk", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_moose.idle", Animation.LoopType.LOOP));
            }
        } else if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.moose.walk", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.moose.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState waterPredicate(AnimationState<T> state) {
        if (!this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_5799()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_moose.swim", Animation.LoopType.LOOP));
            }
        } else if (this.method_5799()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.moose.swim", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState sleepPredicate(AnimationState<T> state) {
        if (this.method_6113()) {
            if (this.method_6109()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_moose.sleep", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.moose.sleep", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        entityData = super.method_5943(world, difficulty, spawnReason, entityData);
        if (world.method_8409().method_43058() < 0.05) {
            this.setVariant(MooseVariants.ALBINO);
        } else {
            this.setVariant(MooseVariants.BROWN);
        }
        if (!this.method_6109()) {
            if (world.method_8409().method_43057() < 0.2f) {
                this.setAntlerSize(MooseAntlerSize.MEDIUM);
            } else {
                this.setAntlerSize(MooseAntlerSize.NONE);
            }
        }
        return entityData;
    }

    public void method_5674(class_2940<?> data) {
        if (SLEEPING.equals(data)) {
            this.method_18382();
        }
        super.method_5674(data);
    }

    public class_4048 method_55694(class_4050 pose) {
        return this.getCustomDimensions(pose);
    }

    private class_4048 getCustomDimensions(class_4050 pose) {
        if (this.method_6113()) {
            return this.method_6109() ? SLEEPING_BABY_DIMENSIONS : SLEEPING_ADULT_DIMENSIONS;
        }
        return this.method_6109() ? BABY_DIMENSIONS : ADULT_DIMENSIONS;
    }

    protected void method_5619() {
        super.method_5619();
        if (!this.method_37908().method_8608()) {
            class_5819 random = this.field_5974;
            if (random.method_43057() < 0.5f) {
                this.setAntlerSize(MooseAntlerSize.MEDIUM);
            } else {
                this.setAntlerSize(MooseAntlerSize.NONE);
            }
        }
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        MooseEntity baby = (MooseEntity)ModEntities.MOOSE.method_5883((class_1937)world);
        if (baby != null) {
            MooseEntity parent1 = this;
            MooseEntity parent2 = (MooseEntity)entity;
            if (parent1.getVariant() == MooseVariants.ALBINO && parent2.getVariant() == MooseVariants.ALBINO) {
                baby.setVariant(MooseVariants.ALBINO);
            } else if (parent1.getVariant() == MooseVariants.ALBINO || parent2.getVariant() == MooseVariants.ALBINO) {
                double chance = 0.25;
                if (world.method_8409().method_43058() < chance) {
                    baby.setVariant(MooseVariants.ALBINO);
                } else {
                    baby.setVariant(MooseVariants.BROWN);
                }
            } else {
                double chance = 0.01;
                if (world.method_8409().method_43058() < chance) {
                    baby.setVariant(MooseVariants.ALBINO);
                } else {
                    baby.setVariant(MooseVariants.BROWN);
                }
            }
            baby.setAntlerSize(MooseAntlerSize.NONE);
        }
        return baby;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ModTags.Items.MOOSE_FOR_BREEDING);
    }

    public boolean method_6474(class_1429 other) {
        if (other == this) {
            return false;
        }
        if (!(other instanceof MooseEntity)) {
            return false;
        }
        MooseEntity otherMoose = (MooseEntity)other;
        boolean thisHasAntlers = this.getAntlerSize() != MooseAntlerSize.NONE;
        boolean otherHasAntlers = otherMoose.getAntlerSize() != MooseAntlerSize.NONE;
        return this.method_6479() && other.method_6479() && thisHasAntlers ^ otherHasAntlers;
    }

    public void method_5773() {
        super.method_5773();
        SnowLayerUtil.handleSnowLayerTick((class_1309)this, this);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_42716) && this.hasSnowLayer()) {
            if (!this.method_37908().field_9236) {
                this.setHasSnowLayer(false);
                this.snowMeltTimer = 0;
                int count = 3 + this.method_37908().field_9229.method_43048(2);
                this.method_5775(new class_1799((class_1935)class_1802.field_8543, count));
            }
            SnowLayerUtil.spawnSnowParticles((class_1309)this);
            this.method_5783(class_3417.field_15165, 1.0f, 1.0f);
            if (!player.method_7337()) {
                itemStack.method_7970(1, (class_1309)player, class_1304.field_6173);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    @Override
    public boolean hasSnowLayer() {
        return (Boolean)this.field_6011.method_12789(HAS_SNOW_LAYER);
    }

    @Override
    public void setHasSnowLayer(boolean hasSnow) {
        this.field_6011.method_12778(HAS_SNOW_LAYER, (Object)hasSnow);
    }

    @Override
    public int getSnowTicks() {
        return this.snowTicks;
    }

    @Override
    public void setSnowTicks(int ticks) {
        this.snowTicks = ticks;
    }

    @Override
    public int getSnowMeltTimer() {
        return this.snowMeltTimer;
    }

    @Override
    public void setSnowMeltTimer(int timer) {
        this.snowMeltTimer = timer;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Sleeping", this.method_6113());
        nbt.method_10556("HasSnowLayer", this.hasSnowLayer());
        nbt.method_10569("SnowTicks", this.snowTicks);
        nbt.method_10569("SnowMeltTimer", this.snowMeltTimer);
        nbt.method_10569("Variant", this.getVariant().ordinal());
        nbt.method_10569("AntlerSize", this.getAntlerSize().ordinal());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setSleeping(nbt.method_10577("Sleeping"));
        this.setHasSnowLayer(nbt.method_10577("HasSnowLayer"));
        this.snowTicks = nbt.method_10550("SnowTicks");
        this.snowMeltTimer = nbt.method_10550("SnowMeltTimer");
        this.setVariant(MooseVariants.values()[nbt.method_10550("Variant")]);
        this.setAntlerSize(MooseAntlerSize.values()[nbt.method_10550("AntlerSize")]);
    }

    @Override
    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.method_5942().method_6340();
        }
    }

    public MooseVariants getVariant() {
        return MooseVariants.values()[(Integer)this.field_6011.method_12789(VARIANT)];
    }

    public void setVariant(MooseVariants variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.ordinal());
    }

    public MooseAntlerSize getAntlerSize() {
        return MooseAntlerSize.values()[(Integer)this.field_6011.method_12789(ANTLER_SIZE)];
    }

    public void setAntlerSize(MooseAntlerSize size) {
        this.field_6011.method_12778(ANTLER_SIZE, (Object)size.ordinal());
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.MOOSE_HURT;
    }

    protected class_3414 method_6002() {
        return ModSounds.MOOSE_DEATH;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14613, 0.15f, 1.0f);
    }
}

