/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.domixcze.domixscreatures.effect.ModEffects;
import net.domixcze.domixscreatures.entity.ai.PiranhaMeleeAttackGoal;
import net.domixcze.domixscreatures.entity.client.piranha.PiranhaVariants;
import net.domixcze.domixscreatures.entity.custom.BeaverEntity;
import net.domixcze.domixscreatures.entity.custom.EelEntity;
import net.domixcze.domixscreatures.item.ModItems;
import net.domixcze.domixscreatures.util.BleedingUtil;
import net.domixcze.domixscreatures.util.ModTags;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1425;
import net.minecraft.class_1431;
import net.minecraft.class_1462;
import net.minecraft.class_1474;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PiranhaEntity
extends class_1425
implements GeoEntity {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(PiranhaEntity.class, (class_2941)class_2943.field_13327);

    public PiranhaEntity(class_1299<? extends class_1425> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1425.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23719, 2.0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new PiranhaMeleeAttackGoal(this, 1.0, true));
        this.field_6201.method_6277(2, (class_1352)new PiranhaEatMeatGoal(this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1431.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1462.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1474.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, BeaverEntity.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, EelEntity.class, true));
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        entityData = super.method_5943(world, difficulty, spawnReason, entityData);
        if (spawnReason == class_3730.field_16459 || spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16472 || spawnReason == class_3730.field_16473) {
            class_6880 biomeEntry = world.method_23753(this.method_24515());
            if (biomeEntry.method_40220(ModTags.Biomes.PIRANHA_SPAWNS_IN)) {
                PiranhaVariants variant;
                if (entityData instanceof PiranhaData) {
                    PiranhaData piranhaData = (PiranhaData)((Object)entityData);
                    variant = piranhaData.variant;
                } else {
                    variant = this.field_5974.method_43056() ? PiranhaVariants.BLUE : (this.field_5974.method_43056() ? PiranhaVariants.GREEN : PiranhaVariants.BLACK);
                    entityData = new PiranhaData(this, variant);
                }
                this.setVariant(variant);
            } else {
                this.setVariant(PiranhaVariants.BLUE);
            }
        }
        return entityData;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)PiranhaVariants.BLUE.getId());
    }

    public PiranhaVariants getVariant() {
        return PiranhaVariants.byId((Integer)this.field_6011.method_12789(VARIANT));
    }

    public void setVariant(PiranhaVariants variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public void method_6455(class_1799 stack) {
        super.method_6455(stack);
        class_9279.method_57452((class_9331)class_9334.field_49610, (class_1799)stack, nbtCompound -> nbtCompound.method_10569("Variant", this.getVariant().getId()));
    }

    public void method_35170(class_2487 nbt) {
        super.method_35170(nbt);
        if (nbt.method_10573("Variant", 3)) {
            this.setVariant(PiranhaVariants.byId(nbt.method_10550("Variant")));
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getVariant().getId());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(PiranhaVariants.byId(nbt.method_10550("Variant")));
    }

    public boolean method_6121(class_1297 target) {
        boolean success = super.method_6121(target);
        if (success && target instanceof class_1309) {
            class_1309 livingTarget = (class_1309)target;
            int protectionCount = BleedingUtil.getBleedingProtectionCount(livingTarget);
            if (protectionCount == 0) {
                livingTarget.method_6092(new class_1293(ModEffects.BLEEDING, 250, 0));
            } else if (protectionCount <= 2) {
                livingTarget.method_6092(new class_1293(ModEffects.BLEEDING, 150, 0));
            } else if (protectionCount == 3) {
                livingTarget.method_6092(new class_1293(ModEffects.BLEEDING, 80, 0));
            }
        }
        return success;
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)ModItems.PIRANHA_BUCKET);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController Controller = new AnimationController((GeoAnimatable)this, "controller", 3, this::predicate);
        Controller.triggerableAnim("attack", RawAnimation.begin().then("animation.piranha.attack", Animation.LoopType.PLAY_ONCE));
        controllers.add(Controller);
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> state) {
        if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.piranha.swim", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.piranha.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    protected class_3414 method_6457() {
        return class_3417.field_14563;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14638;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15123;
    }

    public static class PiranhaEatMeatGoal
    extends class_1352 {
        private class_1542 targetItem;
        private final PiranhaEntity piranha;
        private static final Predicate<class_1542> MEAT_ITEM_FILTER = itemEntity -> {
            class_1799 stack = itemEntity.method_6983();
            return stack.method_31573(ModTags.Items.RAW_MEAT);
        };

        public PiranhaEatMeatGoal(PiranhaEntity piranha) {
            this.piranha = piranha;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (!this.piranha.method_6118(class_1304.field_6173).method_7960()) {
                return false;
            }
            if (this.piranha.method_5968() != null || this.piranha.method_6065() != null) {
                return false;
            }
            if (this.piranha.method_59922().method_43048(PiranhaEatMeatGoal.method_38848((int)20)) != 0) {
                return false;
            }
            this.targetItem = this.findMeatItemInWater();
            return this.targetItem != null && this.piranha.method_6118(class_1304.field_6173).method_7960();
        }

        @Nullable
        private class_1542 findMeatItemInWater() {
            class_238 searchBox = this.piranha.method_5829().method_1009(8.0, 8.0, 8.0);
            List items = this.piranha.method_37908().method_8390(class_1542.class, searchBox, itemEntity -> MEAT_ITEM_FILTER.test((class_1542)itemEntity) && this.isItemInWater((class_1542)itemEntity));
            return items.isEmpty() ? null : (class_1542)items.getFirst();
        }

        private boolean isItemInWater(class_1542 itemEntity) {
            return this.piranha.method_37908().method_8316(itemEntity.method_24515()).method_15767(class_3486.field_15517);
        }

        public void method_6269() {
            if (this.targetItem != null) {
                this.piranha.method_5942().method_6335((class_1297)this.targetItem, 1.2);
            }
        }

        public boolean method_6266() {
            return this.targetItem != null && this.targetItem.method_5805() && this.piranha.method_6118(class_1304.field_6173).method_7960() && this.piranha.method_5858((class_1297)this.targetItem) < 256.0;
        }

        public void method_6268() {
            if (this.targetItem == null || !this.targetItem.method_5805()) {
                return;
            }
            this.piranha.method_5942().method_6335((class_1297)this.targetItem, 1.2);
            if (this.piranha.method_5858((class_1297)this.targetItem) < 0.75) {
                this.piranha.method_6025(2.0f);
                this.targetItem.method_6983().method_7934(1);
                if (this.targetItem.method_6983().method_7960()) {
                    this.targetItem.method_31472();
                }
                this.targetItem = null;
                this.piranha.method_5783(class_3417.field_20614, 1.0f, 1.0f + (this.piranha.method_59922().method_43057() - this.piranha.method_59922().method_43057()) * 0.2f);
            }
        }

        public void method_6270() {
            this.targetItem = null;
            this.piranha.method_5942().method_6340();
        }
    }

    private static class PiranhaData
    extends class_1425.class_1426 {
        final PiranhaVariants variant;

        PiranhaData(PiranhaEntity leader, PiranhaVariants variant) {
            super((class_1425)leader);
            this.variant = variant;
        }
    }
}

