/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import net.domixcze.domixscreatures.config.ModConfig;
import net.domixcze.domixscreatures.entity.ModEntities;
import net.domixcze.domixscreatures.entity.ai.BabyFollowParentGoal;
import net.domixcze.domixscreatures.entity.ai.SleepGoal;
import net.domixcze.domixscreatures.entity.ai.Sleepy;
import net.domixcze.domixscreatures.entity.ai.SnowLayerable;
import net.domixcze.domixscreatures.entity.client.porcupine.PorcupineVariants;
import net.domixcze.domixscreatures.entity.custom.QuillProjectileEntity;
import net.domixcze.domixscreatures.util.ModTags;
import net.domixcze.domixscreatures.util.SnowLayerUtil;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PorcupineEntity
extends class_1429
implements GeoEntity,
Sleepy,
SnowLayerable {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Integer> QUILLS = class_2945.method_12791(PorcupineEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(PorcupineEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SLEEPING = class_2945.method_12791(PorcupineEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> HAS_SNOW_LAYER = class_2945.method_12791(PorcupineEntity.class, (class_2941)class_2943.field_13323);
    private int snowTicks = 0;
    private int snowMeltTimer = 0;
    private int quillRegenCooldown = 0;
    private static final int MAX_QUILL_CLUSTERS = 5;
    private static final int REGEN_COOLDOWN_TICKS = 1200;

    public PorcupineEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.2);
    }

    public boolean method_5931() {
        return !this.method_6113();
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ModTags.Items.PORCUPINE_FOR_BREEDING);
    }

    @Override
    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.method_5942().method_6340();
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SleepGoal(this, (class_1308)this, 100, false, true, true, true, 7.0, 500, 700, true, false, true, true, 1));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new BabyFollowParentGoal(this, 0.8));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 0.75, 1.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_SNOW_LAYER, (Object)false);
        builder.method_56912(QUILLS, (Object)5);
        builder.method_56912(SLEEPING, (Object)false);
        builder.method_56912(VARIANT, (Object)PorcupineVariants.NORMAL.getId());
    }

    public void method_6005(double strength, double x, double z) {
        super.method_6005(strength * 0.1, x, z);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (ModConfig.INSTANCE.enablePorcupineQuillAttack && !this.method_37908().method_8608() && !this.method_29504() && !this.method_6109() && this.getQuillsAvailable() > 0) {
            class_1309 attacker;
            boolean wasHurt = super.method_5643(source, amount);
            class_1309 class_13092 = attacker = source.method_5529() instanceof class_1309 ? (class_1309)source.method_5529() : null;
            if (wasHurt && attacker != null) {
                this.shootQuills(attacker);
                this.setQuillsAvailable(this.getQuillsAvailable() - 1);
                this.quillRegenCooldown = 0;
            }
            return wasHurt;
        }
        return super.method_5643(source, amount);
    }

    private void shootQuills(class_1309 attacker) {
        if (attacker != null) {
            class_1937 world = this.method_37908();
            class_5819 random = this.method_59922();
            int numberOfQuills = random.method_43048(3) + 3;
            for (int i = 0; i < numberOfQuills; ++i) {
                QuillProjectileEntity quill = new QuillProjectileEntity(world, this.method_23317(), this.method_23320() - 0.1, this.method_23321());
                class_243 backwardVec = this.method_5828(1.0f).method_1029().method_1021(-0.4);
                double upwardVelocity = 0.5 + random.method_43058() * 0.15;
                double spreadXZ = (random.method_43058() - 0.5) * 0.25;
                class_243 velocity = new class_243((backwardVec.field_1352 + spreadXZ) * 0.3, upwardVelocity * 0.9, (backwardVec.field_1350 + spreadXZ) * 0.3);
                quill.method_18799(velocity);
                quill.method_7432((class_1297)this);
                world.method_8649((class_1297)quill);
            }
            this.method_5783(class_3417.field_14633, 1.0f, 1.0f);
        }
    }

    public int getQuillsAvailable() {
        return (Integer)this.field_6011.method_12789(QUILLS);
    }

    public void setQuillsAvailable(int amount) {
        this.field_6011.method_12778(QUILLS, (Object)amount);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getVariant().getId());
        nbt.method_10569("QuillRegenCooldown", this.quillRegenCooldown);
        nbt.method_10569("QuillsAvailable", this.getQuillsAvailable());
        nbt.method_10556("Sleeping", this.method_6113());
        nbt.method_10556("HasSnowLayer", this.hasSnowLayer());
        nbt.method_10569("SnowTicks", this.snowTicks);
        nbt.method_10569("SnowMeltTimer", this.snowMeltTimer);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(PorcupineVariants.byId(nbt.method_10550("Variant")));
        this.quillRegenCooldown = nbt.method_10550("QuillRegenCooldown");
        this.setQuillsAvailable(nbt.method_10550("QuillsAvailable"));
        this.setSleeping(nbt.method_10577("Sleeping"));
        this.setHasSnowLayer(nbt.method_10577("HasSnowLayer"));
        this.snowTicks = nbt.method_10550("SnowTicks");
        this.snowMeltTimer = nbt.method_10550("SnowMeltTimer");
    }

    @Override
    public boolean hasSnowLayer() {
        return (Boolean)this.field_6011.method_12789(HAS_SNOW_LAYER);
    }

    @Override
    public void setHasSnowLayer(boolean hasSnow) {
        this.field_6011.method_12778(HAS_SNOW_LAYER, (Object)hasSnow);
    }

    @Override
    public int getSnowTicks() {
        return this.snowTicks;
    }

    @Override
    public void setSnowTicks(int ticks) {
        this.snowTicks = ticks;
    }

    @Override
    public int getSnowMeltTimer() {
        return this.snowMeltTimer;
    }

    @Override
    public void setSnowMeltTimer(int timer) {
        this.snowMeltTimer = timer;
    }

    public PorcupineVariants getVariant() {
        return PorcupineVariants.byId((Integer)this.field_6011.method_12789(VARIANT));
    }

    public void setVariant(PorcupineVariants variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_42716) && this.hasSnowLayer()) {
            if (!this.method_37908().field_9236) {
                this.setHasSnowLayer(false);
                this.snowMeltTimer = 0;
                int count = 3 + this.method_37908().field_9229.method_43048(2);
                this.method_5775(new class_1799((class_1935)class_1802.field_8543, count));
            }
            SnowLayerUtil.spawnSnowParticles((class_1309)this);
            this.method_5783(class_3417.field_15165, 1.0f, 1.0f);
            if (!player.method_7337()) {
                itemStack.method_7970(1, (class_1309)player, class_1304.field_6173);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    protected class_4048 method_55694(class_4050 pose) {
        if (this.method_6109()) {
            return class_4048.method_18385((float)0.4f, (float)0.4f);
        }
        return this.method_5864().method_18386();
    }

    public void method_5773() {
        super.method_5773();
        SnowLayerUtil.handleSnowLayerTick((class_1309)this, this);
        if (!this.method_37908().field_9236 && !this.method_6109() && this.getQuillsAvailable() < 5) {
            ++this.quillRegenCooldown;
            if (this.quillRegenCooldown >= 1200) {
                this.setQuillsAvailable(this.getQuillsAvailable() + 1);
                this.quillRegenCooldown = 0;
            }
        }
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        entityData = super.method_5943(world, difficulty, spawnReason, entityData);
        if (world.method_8409().method_43058() < 0.05) {
            this.setVariant(PorcupineVariants.ALBINO);
        } else {
            this.setVariant(PorcupineVariants.NORMAL);
        }
        if (this.method_6109()) {
            this.setQuillsAvailable(0);
        } else {
            this.setQuillsAvailable(5);
        }
        this.quillRegenCooldown = 0;
        return entityData;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        PorcupineEntity baby = (PorcupineEntity)ModEntities.PORCUPINE.method_5883((class_1937)world);
        if (baby != null) {
            PorcupineEntity parent1 = this;
            PorcupineEntity parent2 = (PorcupineEntity)entity;
            if (parent1.getVariant() == PorcupineVariants.ALBINO && parent2.getVariant() == PorcupineVariants.ALBINO) {
                baby.setVariant(PorcupineVariants.ALBINO);
            } else if (parent1.getVariant() == PorcupineVariants.ALBINO || parent2.getVariant() == PorcupineVariants.ALBINO) {
                double chance = 0.25;
                if (world.method_8409().method_43058() < chance) {
                    baby.setVariant(PorcupineVariants.ALBINO);
                } else {
                    baby.setVariant(PorcupineVariants.NORMAL);
                }
            } else {
                double chance = 0.01;
                if (world.method_8409().method_43058() < chance) {
                    baby.setVariant(PorcupineVariants.ALBINO);
                } else {
                    baby.setVariant(PorcupineVariants.NORMAL);
                }
            }
        }
        return baby;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "water_controller", 5, this::waterPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "sleep_controller", 5, this::sleepPredicate));
    }

    private <P extends GeoAnimatable> PlayState landPredicate(AnimationState<P> state) {
        if (this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_18798().method_37268() > 1.0E-9) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_porcupine.walk", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_porcupine.idle", Animation.LoopType.LOOP));
            }
        } else if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.porcupine.walk", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.porcupine.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState waterPredicate(AnimationState<T> state) {
        if (!this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.baby_porcupine.swim", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.porcupine.swim", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState sleepPredicate(AnimationState<T> state) {
        if (this.method_6113()) {
            if (this.method_6109()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_porcupine.sleep", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.porcupine.sleep", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

