/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import java.util.List;
import net.domixcze.domixscreatures.config.ModConfig;
import net.domixcze.domixscreatures.entity.ModEntities;
import net.domixcze.domixscreatures.entity.ai.BabyFollowParentGoal;
import net.domixcze.domixscreatures.entity.ai.SleepGoal;
import net.domixcze.domixscreatures.entity.ai.Sleepy;
import net.domixcze.domixscreatures.entity.ai.SnowLayerable;
import net.domixcze.domixscreatures.item.ModItems;
import net.domixcze.domixscreatures.sound.ModSounds;
import net.domixcze.domixscreatures.util.ModTags;
import net.domixcze.domixscreatures.util.SnowLayerUtil;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1338;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1386;
import net.minecraft.class_1429;
import net.minecraft.class_1493;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3719;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RaccoonEntity
extends class_1321
implements GeoEntity,
Sleepy,
SnowLayerable {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int snowTicks = 0;
    private int snowMeltTimer = 0;
    public static final class_2940<Boolean> HAS_SNOW_LAYER = class_2945.method_12791(RaccoonEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_WASHING = class_2945.method_12791(RaccoonEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_1799> HELD_FOOD = class_2945.method_12791(RaccoonEntity.class, (class_2941)class_2943.field_13322);
    public static final class_2940<Boolean> SLEEPING = class_2945.method_12791(RaccoonEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SITTING = class_2945.method_12791(RaccoonEntity.class, (class_2941)class_2943.field_13323);
    private static final int STEAL_COOLDOWN_TICKS = 2400;
    private int washingTicks = 0;
    private int stealCooldown = 0;
    private int marshmallowsEaten = 0;

    public RaccoonEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1321.method_26828().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23719, (double)0.2f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SleepGoal(this, (class_1308)this, 100, true, false, true, false, 7.0, 600, 800, false, false, true, true, 1));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(1, (class_1352)new class_1350((class_1321)this, 1.0, 10.0f, 2.0f));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1493.class, 10.0f, 1.0, 1.0));
        this.field_6201.method_6277(2, (class_1352)new StealFoodGoal(this, 8.0));
        this.field_6201.method_6277(3, (class_1352)new WashFoodGoal(this, 8.0));
        this.field_6201.method_6277(3, (class_1352)new BabyFollowParentGoal((class_1429)this, 1.25));
        this.field_6201.method_6277(4, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_SNOW_LAYER, (Object)false);
        builder.method_56912(IS_WASHING, (Object)false);
        builder.method_56912(HELD_FOOD, (Object)class_1799.field_8037);
        builder.method_56912(SLEEPING, (Object)false);
        builder.method_56912(SITTING, (Object)false);
    }

    @Override
    public boolean hasSnowLayer() {
        return (Boolean)this.field_6011.method_12789(HAS_SNOW_LAYER);
    }

    @Override
    public void setHasSnowLayer(boolean hasSnow) {
        this.field_6011.method_12778(HAS_SNOW_LAYER, (Object)hasSnow);
    }

    @Override
    public int getSnowTicks() {
        return this.snowTicks;
    }

    @Override
    public void setSnowTicks(int ticks) {
        this.snowTicks = ticks;
    }

    @Override
    public int getSnowMeltTimer() {
        return this.snowMeltTimer;
    }

    @Override
    public void setSnowMeltTimer(int timer) {
        this.snowMeltTimer = timer;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("HasSnowLayer", this.hasSnowLayer());
        nbt.method_10569("SnowTicks", this.snowTicks);
        nbt.method_10569("SnowMeltTimer", this.snowMeltTimer);
        nbt.method_10556("Sleeping", this.method_6113());
        nbt.method_10556("isSitting", ((Boolean)this.field_6011.method_12789(SITTING)).booleanValue());
        nbt.method_10569("MarshmallowsEaten", this.marshmallowsEaten);
        nbt.method_10556("IsWashing", ((Boolean)this.field_6011.method_12789(IS_WASHING)).booleanValue());
        nbt.method_10569("WashingTicks", this.washingTicks);
        nbt.method_10569("StealCooldown", this.stealCooldown);
        if (!this.getHeldFood().method_7960()) {
            nbt.method_10566("HeldFood", (class_2520)class_1799.field_24671.encodeStart((DynamicOps)this.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)this.getHeldFood()).resultOrPartial(error -> {}).orElse(new class_2487()));
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setHasSnowLayer(nbt.method_10577("HasSnowLayer"));
        this.snowTicks = nbt.method_10550("SnowTicks");
        this.snowMeltTimer = nbt.method_10550("SnowMeltTimer");
        this.setSleeping(nbt.method_10577("Sleeping"));
        this.field_6011.method_12778(SITTING, (Object)nbt.method_10577("isSitting"));
        if (nbt.method_10545("MarshmallowsEaten")) {
            this.marshmallowsEaten = nbt.method_10550("MarshmallowsEaten");
        }
        if (nbt.method_10545("IsWashing")) {
            this.field_6011.method_12778(IS_WASHING, (Object)nbt.method_10577("IsWashing"));
        }
        if (nbt.method_10545("WashingTicks")) {
            this.washingTicks = nbt.method_10550("WashingTicks");
        }
        if (nbt.method_10545("StealCooldown")) {
            this.stealCooldown = nbt.method_10550("StealCooldown");
        }
        if (nbt.method_10545("HeldFood")) {
            class_1799 heldItem = class_1799.field_24671.parse((DynamicOps)this.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10580("HeldFood")).resultOrPartial(error -> {}).orElse(class_1799.field_8037);
            this.setHeldFood(heldItem);
        } else {
            this.setHeldFood(class_1799.field_8037);
        }
    }

    protected void method_16078() {
        super.method_16078();
        super.method_16078();
        class_1799 heldItem = this.getHeldFood();
        if (!heldItem.method_7960()) {
            this.method_5775(heldItem);
            this.setHeldFood(class_1799.field_8037);
        }
    }

    protected class_4048 method_55694(class_4050 pose) {
        if (this.method_6109()) {
            return class_4048.method_18385((float)0.5f, (float)0.4f);
        }
        return this.method_5864().method_18386();
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ModTags.Items.RACCOON_FOR_BREEDING);
    }

    @Override
    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.method_5942().method_6340();
            class_1309 class_13092 = this.method_35057();
            if (class_13092 instanceof class_1657) {
                class_1657 player = (class_1657)class_13092;
                if (!this.method_24345()) {
                    this.setSit(player, true);
                }
            }
        }
    }

    public boolean hasFood() {
        return !this.getHeldFood().method_7960();
    }

    public class_1799 getHeldFood() {
        return (class_1799)this.field_6011.method_12789(HELD_FOOD);
    }

    public void setHeldFood(class_1799 stack) {
        this.field_6011.method_12778(HELD_FOOD, (Object)stack);
    }

    public boolean isFood(class_1799 stack) {
        return stack.method_31573(ModTags.Items.RACCOON_STEALS);
    }

    public boolean isWashing() {
        return (Boolean)this.field_6011.method_12789(IS_WASHING);
    }

    public void startWashing() {
        this.field_6011.method_12778(IS_WASHING, (Object)true);
        this.washingTicks = 200;
    }

    public void stopWashing() {
        this.field_6011.method_12778(IS_WASHING, (Object)false);
        this.washingTicks = 0;
    }

    public int getStealCooldown() {
        return this.stealCooldown;
    }

    public void resetStealCooldown() {
        this.stealCooldown = 2400;
    }

    public void method_5773() {
        super.method_5773();
        SnowLayerUtil.handleSnowLayerTick((class_1309)this, this);
        if (this.stealCooldown > 0) {
            --this.stealCooldown;
        }
        if (this.isWashing()) {
            --this.washingTicks;
            if (this.washingTicks <= 0 && !this.method_37908().field_9236) {
                this.method_5783(class_3417.field_20614, 1.0f, 1.0f);
                class_1799 heldItem = this.getHeldFood();
                if (!heldItem.method_7960()) {
                    boolean wasMarshmallow = heldItem.method_31574(ModItems.MARSHMALLOW);
                    heldItem.method_7934(1);
                    this.setHeldFood(heldItem.method_7960() ? class_1799.field_8037 : heldItem);
                    if (wasMarshmallow && !this.method_6181()) {
                        ++this.marshmallowsEaten;
                        if (this.marshmallowsEaten >= 3 && !this.method_6181()) {
                            this.tameNearestPlayer();
                        }
                    }
                }
                this.stopWashing();
            }
        }
    }

    private void tameNearestPlayer() {
        if (this.method_37908().field_9236) {
            return;
        }
        class_1657 nearest = this.method_37908().method_18460((class_1297)this, 8.0);
        if (nearest != null) {
            this.method_6174(nearest.method_5667());
            this.method_6173(true, false);
            this.method_37908().method_8421((class_1297)this, (byte)7);
        }
    }

    public boolean method_24345() {
        return (Boolean)this.field_6011.method_12789(SITTING);
    }

    public void setSit(class_1657 player, boolean sitting) {
        if (player == this.method_35057()) {
            this.field_6011.method_12778(SITTING, (Object)sitting);
            super.method_24346(sitting);
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (this.method_6181() && !this.method_37908().method_8608() && this.method_6181() && hand == class_1268.field_5808 && itemStack.method_7960()) {
            this.setSit(player, !this.method_24345());
            class_2561 entityName = this.method_5476();
            class_5250 action = class_2561.method_43471((String)(this.method_24345() ? "message.domixs-creatures.action.sitting" : "message.domixs-creatures.action.following"));
            class_5250 message = class_2561.method_43470((String)(entityName.getString() + " ")).method_10852((class_2561)action).method_27693(".").method_27694(style -> style.method_10977(class_124.field_1060));
            player.method_7353((class_2561)message, true);
            return class_1269.field_5811;
        }
        if (!ModConfig.INSTANCE.enableRaccoonStealing && !this.method_6181() && itemStack.method_31574(ModItems.MARSHMALLOW)) {
            if (!player.method_37908().field_9236) {
                itemStack.method_7934(1);
                ++this.marshmallowsEaten;
                if (this.marshmallowsEaten >= 3) {
                    this.method_6174(player.method_5667());
                    this.method_6173(true, false);
                    this.method_37908().method_8421((class_1297)this, (byte)7);
                }
            }
            return class_1269.field_5812;
        }
        if (itemStack.method_31574(class_1802.field_42716) && this.hasSnowLayer()) {
            if (!this.method_37908().field_9236) {
                this.setHasSnowLayer(false);
                this.snowMeltTimer = 0;
                int count = 3 + this.method_37908().field_9229.method_43048(2);
                this.method_5775(new class_1799((class_1935)class_1802.field_8543, count));
            }
            SnowLayerUtil.spawnSnowParticles((class_1309)this);
            this.method_5783(class_3417.field_15165, 1.0f, 1.0f);
            if (!player.method_7337()) {
                itemStack.method_7970(1, (class_1309)player, class_1304.field_6173);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)ModEntities.RACCOON.method_5883((class_1937)world);
    }

    public boolean method_5931() {
        return !this.method_6113();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "water_controller", 5, this::waterPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "sleep_controller", 5, this::sleepPredicate));
    }

    private <P extends GeoAnimatable> PlayState landPredicate(AnimationState<P> state) {
        if (this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_18798().method_37268() > 1.0E-9) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_raccoon.walk", Animation.LoopType.LOOP));
            } else if (this.method_24345() && !this.method_6113()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_raccoon.sit", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_raccoon.idle", Animation.LoopType.LOOP));
            }
        } else if (this.isWashing()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.raccoon.washing", Animation.LoopType.LOOP));
        } else if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.raccoon.walk", Animation.LoopType.LOOP));
        } else if (this.method_24345() && !this.method_6113()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.raccoon.sit", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.raccoon.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState waterPredicate(AnimationState<T> state) {
        if (!this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.baby_raccoon.swim", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.raccoon.swim", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState sleepPredicate(AnimationState<T> state) {
        if (this.method_6113()) {
            if (this.method_6109()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_raccoon.sleep", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.raccoon.sleep", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    protected class_3414 method_5994() {
        if (this.method_6113()) {
            return null;
        }
        return ModSounds.RACCOON_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.RACCOON_HURT;
    }

    protected class_3414 method_6002() {
        return ModSounds.RACCOON_DEATH;
    }

    public static class StealFoodGoal
    extends class_1352 {
        private final RaccoonEntity raccoon;
        private final double range;
        private class_2338 targetChestPos;

        public StealFoodGoal(RaccoonEntity raccoon, double range) {
            this.raccoon = raccoon;
            this.range = range;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (!ModConfig.INSTANCE.enableRaccoonStealing) {
                return false;
            }
            if (this.raccoon.method_6113() || this.raccoon.method_6109() || this.raccoon.method_6181() || this.raccoon.hasFood() || this.raccoon.getStealCooldown() > 0) {
                return false;
            }
            List wolves = this.raccoon.method_37908().method_8390(class_1493.class, this.raccoon.method_5829().method_1014(10.0), wolf -> wolf.method_5805() && !wolf.method_6109());
            if (!wolves.isEmpty()) {
                return false;
            }
            class_1937 world = this.raccoon.method_37908();
            class_2338 origin = this.raccoon.method_24515();
            for (class_2338 pos : class_2338.method_25996((class_2338)origin, (int)((int)this.range), (int)((int)this.range), (int)((int)this.range))) {
                class_2586 be = world.method_8321(pos);
                if (!(be instanceof class_2595) && !(be instanceof class_3719)) continue;
                class_1263 inv = (class_1263)be;
                for (int i = 0; i < inv.method_5439(); ++i) {
                    if (!this.raccoon.isFood(inv.method_5438(i))) continue;
                    this.targetChestPos = pos;
                    return true;
                }
            }
            return false;
        }

        public boolean method_6266() {
            class_2586 be;
            if (this.targetChestPos != null && !this.raccoon.hasFood() && (be = this.raccoon.method_37908().method_8321(this.targetChestPos)) instanceof class_1263) {
                class_1263 inv = (class_1263)be;
                for (int i = 0; i < inv.method_5439(); ++i) {
                    if (!this.raccoon.isFood(inv.method_5438(i))) continue;
                    return true;
                }
            }
            return false;
        }

        public void method_6268() {
            if (this.raccoon.method_5649((double)this.targetChestPos.method_10263() + 0.5, this.targetChestPos.method_10264(), (double)this.targetChestPos.method_10260() + 0.5) < 2.0) {
                class_2586 be = this.raccoon.method_37908().method_8321(this.targetChestPos);
                if (be instanceof class_1263) {
                    class_1263 inv = (class_1263)be;
                    for (int i = 0; i < inv.method_5439(); ++i) {
                        class_1799 stack = inv.method_5438(i);
                        if (stack.method_7960() || !this.raccoon.isFood(stack)) continue;
                        class_1799 stolen = stack.method_7971(1);
                        this.raccoon.setHeldFood(stolen);
                        this.raccoon.method_5942().method_6340();
                        be.method_5431();
                        break;
                    }
                    if (!this.raccoon.hasFood()) {
                        this.method_6270();
                    }
                }
            } else {
                this.raccoon.method_5942().method_6337((double)this.targetChestPos.method_10263() + 0.5, (double)this.targetChestPos.method_10264(), (double)this.targetChestPos.method_10260() + 0.5, 1.0);
            }
        }

        public void method_6270() {
            if (this.raccoon.hasFood()) {
                this.raccoon.resetStealCooldown();
            }
            this.targetChestPos = null;
        }
    }

    public static class WashFoodGoal
    extends class_1352 {
        private final RaccoonEntity raccoon;
        private final double range;
        private class_2338 waterPos;
        private class_2338 targetPos;
        private int soundPlayCooldown = 0;
        private final class_2350[] HORIZONTALS = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034};

        public WashFoodGoal(RaccoonEntity raccoon, double range) {
            this.raccoon = raccoon;
            this.range = range;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.raccoon.method_6113() || this.raccoon.method_6109() || !this.raccoon.hasFood() || this.raccoon.method_52535()) {
                return false;
            }
            this.waterPos = this.getTarget();
            if (this.waterPos != null) {
                this.targetPos = this.getLandPos(this.waterPos);
                return this.targetPos != null;
            }
            return false;
        }

        public boolean method_6266() {
            return this.targetPos != null && this.raccoon.hasFood() && !this.raccoon.method_52535();
        }

        public void method_6268() {
            if (this.waterPos != null) {
                if (!this.raccoon.method_37908().method_8316(this.waterPos).method_15767(class_3486.field_15517)) {
                    this.method_6270();
                    return;
                }
                double dist = this.raccoon.method_5707(class_243.method_24953((class_2382)this.waterPos));
                --this.soundPlayCooldown;
                if (dist > 2.0 && this.raccoon.isWashing()) {
                    this.raccoon.stopWashing();
                }
                if (dist <= 1.0) {
                    this.raccoon.method_5942().method_6340();
                    double d0 = (double)this.waterPos.method_10263() + 0.5 - this.raccoon.method_23317();
                    double d2 = (double)this.waterPos.method_10260() + 0.5 - this.raccoon.method_23321();
                    float yaw = (float)(class_3532.method_15349((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.raccoon.method_36456(yaw);
                    this.raccoon.method_5847(yaw);
                    this.raccoon.field_6283 = yaw;
                    if (!this.raccoon.isWashing()) {
                        this.raccoon.startWashing();
                    }
                    if (this.soundPlayCooldown <= 0) {
                        this.raccoon.method_5783(class_3417.field_14818, 0.7f, 0.5f + this.raccoon.method_59922().method_43057());
                        this.soundPlayCooldown = 20;
                    }
                } else {
                    this.raccoon.method_5942().method_6337((double)this.waterPos.method_10263(), (double)this.waterPos.method_10264(), (double)this.waterPos.method_10260(), 1.2);
                }
            }
        }

        public void method_6270() {
            this.targetPos = null;
            this.waterPos = null;
            this.raccoon.stopWashing();
            this.raccoon.method_5942().method_6340();
            this.soundPlayCooldown = 0;
        }

        public class_2338 getTarget() {
            class_1937 world = this.raccoon.method_37908();
            class_5819 random = this.raccoon.method_59922();
            int range = (int)this.range;
            for (int i = 0; i < 15; ++i) {
                class_2338 searchPos = this.raccoon.method_24515().method_10069(random.method_43048(range) - range / 2, 3, random.method_43048(range) - range / 2);
                while (world.method_8320(searchPos).method_26215() && searchPos.method_10264() > world.method_31607()) {
                    searchPos = searchPos.method_10074();
                }
                if (!this.isNextToLand(searchPos)) continue;
                return searchPos;
            }
            return null;
        }

        public boolean isNextToLand(class_2338 pos) {
            class_1937 world = this.raccoon.method_37908();
            if (world.method_8316(pos).method_15767(class_3486.field_15517)) {
                for (class_2350 dir : this.HORIZONTALS) {
                    class_2338 offsetPos = pos.method_10093(dir);
                    if (!world.method_8316(offsetPos).method_15769() || !world.method_8320(offsetPos.method_10084()).method_26215()) continue;
                    return true;
                }
            }
            return false;
        }

        public class_2338 getLandPos(class_2338 pos) {
            class_1937 world = this.raccoon.method_37908();
            if (world.method_8316(pos).method_15767(class_3486.field_15517)) {
                for (class_2350 dir : this.HORIZONTALS) {
                    class_2338 offsetPos = pos.method_10093(dir);
                    if (!world.method_8316(offsetPos).method_15769() || !world.method_8320(offsetPos.method_10084()).method_26215()) continue;
                    return offsetPos;
                }
            }
            return null;
        }
    }
}

