/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.domixcze.domixscreatures.entity.ai.EatsGrass;
import net.domixcze.domixscreatures.entity.ai.MobEatGrassGoal;
import net.domixcze.domixscreatures.entity.ai.SleepGoal;
import net.domixcze.domixscreatures.entity.ai.Sleepy;
import net.domixcze.domixscreatures.entity.ai.SnowLayerable;
import net.domixcze.domixscreatures.entity.client.unicorn.UnicornVariants;
import net.domixcze.domixscreatures.item.ModItems;
import net.domixcze.domixscreatures.particle.ModParticles;
import net.domixcze.domixscreatures.util.SnowLayerUtil;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6025;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class UnicornEntity
extends class_1429
implements GeoEntity,
class_6025,
Sleepy,
EatsGrass,
SnowLayerable {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(UnicornEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Boolean> IS_RUBBING = class_2945.method_12791(UnicornEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_RUNNING = class_2945.method_12791(UnicornEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> TAMED = class_2945.method_12791(UnicornEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> TRUST = class_2945.method_12791(UnicornEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SLEEPING = class_2945.method_12791(UnicornEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_EATING = class_2945.method_12791(UnicornEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(UnicornEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> HAS_SNOW_LAYER = class_2945.method_12791(UnicornEntity.class, (class_2941)class_2943.field_13323);
    private static final double MOB_RUNNING_VELOCITY_THRESHOLD = 0.0025000000000000005;
    private int snowTicks = 0;
    private int snowMeltTimer = 0;
    private int soundTicks = 0;
    private long lastTrustFeedTime = 0L;
    private int hornRubCooldown = 0;
    private static final class_4048 ADULT_DIMENSIONS = class_4048.method_18385((float)1.4f, (float)1.6f);
    private static final class_4048 SLEEPING_ADULT_DIMENSIONS = class_4048.method_18385((float)1.4f, (float)0.8f);

    public UnicornEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23719, 0.2);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SleepGoal(this, (class_1308)this, 120, true, false, true, false, 5.0, 600, 800, true, false, true, true, 1));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new RubHornOnLogGoal(this, 10.0));
        this.field_6201.method_6277(2, (class_1352)new FleeGoal(this, 10.0, 1.0, 2.0));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 0.9));
        this.field_6201.method_6277(4, (class_1352)new MobEatGrassGoal((class_1308)this));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TAMED, (Object)false);
        builder.method_56912(TRUST, (Object)0);
        builder.method_56912(IS_RUNNING, (Object)false);
        builder.method_56912(IS_RUBBING, (Object)false);
        builder.method_56912(SLEEPING, (Object)false);
        builder.method_56912(IS_EATING, (Object)false);
        builder.method_56912(HAS_SNOW_LAYER, (Object)false);
        builder.method_56912(VARIANT, (Object)UnicornVariants.PINK.getId());
        builder.method_56912(OWNER_UUID, Optional.empty());
    }

    @Override
    public boolean hasSnowLayer() {
        return (Boolean)this.field_6011.method_12789(HAS_SNOW_LAYER);
    }

    @Override
    public void setHasSnowLayer(boolean hasSnow) {
        this.field_6011.method_12778(HAS_SNOW_LAYER, (Object)hasSnow);
    }

    @Override
    public int getSnowTicks() {
        return this.snowTicks;
    }

    @Override
    public void setSnowTicks(int ticks) {
        this.snowTicks = ticks;
    }

    @Override
    public int getSnowMeltTimer() {
        return this.snowMeltTimer;
    }

    @Override
    public void setSnowMeltTimer(int timer) {
        this.snowMeltTimer = timer;
    }

    public boolean isTamed() {
        return (Boolean)this.field_6011.method_12789(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.field_6011.method_12778(TAMED, (Object)tamed);
    }

    public int getTrust() {
        return (Integer)this.field_6011.method_12789(TRUST);
    }

    public void setTrust(int trust) {
        this.field_6011.method_12778(TRUST, (Object)class_3532.method_15340((int)trust, (int)0, (int)10));
    }

    public void updateTrust(int amount) {
        this.setTrust(this.getTrust() + amount);
    }

    public int getHornRubCooldown() {
        return this.hornRubCooldown;
    }

    public void resetHornRubCooldown() {
        this.hornRubCooldown = 600 + this.method_59922().method_43048(600);
    }

    public boolean isRunning() {
        return (Boolean)this.field_6011.method_12789(IS_RUNNING);
    }

    public void setRunning(boolean running) {
        this.field_6011.method_12778(IS_RUNNING, (Object)running);
    }

    public boolean isRubbing() {
        return (Boolean)this.field_6011.method_12789(IS_RUBBING);
    }

    public void setRubbing(boolean rubbing) {
        this.field_6011.method_12778(IS_RUBBING, (Object)rubbing);
    }

    @Override
    public boolean isEating() {
        return (Boolean)this.field_6011.method_12789(IS_EATING);
    }

    @Override
    public void setEating(boolean eating) {
        this.field_6011.method_12778(IS_EATING, (Object)eating);
    }

    @Nullable
    public UUID method_6139() {
        return ((Optional)this.field_6011.method_12789(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(OWNER_UUID, Optional.ofNullable(uuid));
    }

    @Override
    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.method_5942().method_6340();
        }
    }

    public UnicornVariants getVariant() {
        return UnicornVariants.byId((Integer)this.field_6011.method_12789(VARIANT));
    }

    public void setVariant(UnicornVariants variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public void method_5674(class_2940<?> data) {
        if (SLEEPING.equals(data)) {
            this.method_18382();
        }
        super.method_5674(data);
    }

    public class_4048 method_55694(class_4050 pose) {
        return this.getCustomDimensions(pose);
    }

    private class_4048 getCustomDimensions(class_4050 pose) {
        if (this.method_6113()) {
            return SLEEPING_ADULT_DIMENSIONS;
        }
        return ADULT_DIMENSIONS;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Tamed", this.isTamed());
        nbt.method_10569("Trust", this.getTrust());
        nbt.method_10569("HornRubCooldown", this.hornRubCooldown);
        nbt.method_10544("LastTrustFeedTime", this.lastTrustFeedTime);
        nbt.method_10556("IsRunning", this.isRunning());
        nbt.method_10556("Sleeping", this.method_6113());
        nbt.method_10569("Variant", this.getVariant().getId());
        nbt.method_10556("HasSnowLayer", this.hasSnowLayer());
        nbt.method_10569("SnowTicks", this.snowTicks);
        nbt.method_10569("SnowMeltTimer", this.snowMeltTimer);
        UUID owner = this.method_6139();
        if (owner != null) {
            nbt.method_25927("Owner", owner);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setTamed(nbt.method_10577("Tamed"));
        this.setTrust(nbt.method_10550("Trust"));
        this.hornRubCooldown = nbt.method_10550("HornRubCooldown");
        if (nbt.method_25928("Owner")) {
            this.setOwnerUuid(nbt.method_25926("Owner"));
        }
        if (nbt.method_10545("LastTrustFeedTime")) {
            this.lastTrustFeedTime = nbt.method_10537("LastTrustFeedTime");
        }
        this.setRunning(nbt.method_10577("IsRunning"));
        this.setSleeping(nbt.method_10577("Sleeping"));
        this.setVariant(UnicornVariants.byId(nbt.method_10550("Variant")));
        this.setHasSnowLayer(nbt.method_10577("HasSnowLayer"));
        this.snowTicks = nbt.method_10550("SnowTicks");
        this.snowMeltTimer = nbt.method_10550("SnowMeltTimer");
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        super.method_5943(world, difficulty, spawnReason, entityData);
        if (spawnReason == class_3730.field_16459 || spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16472) {
            UnicornVariants[] variants = UnicornVariants.values();
            UnicornVariants variant = variants[this.field_5974.method_43048(variants.length)];
            this.setVariant(variant);
        }
        return entityData;
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        long worldTime = this.method_37908().method_8510();
        if (!this.isTamed() && itemStack.method_31574(class_1802.field_8463)) {
            this.setTamed(true);
            this.setOwnerUuid(player.method_5667());
            this.method_5783(class_3417.field_15099, 1.0f, 1.0f);
            this.lastTrustFeedTime = this.method_37908().method_8510() - 12000L;
            if (!player.method_7337()) {
                itemStack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        if (this.isTamed() && this.method_6139() != null && player.method_5667().equals(this.method_6139()) && itemStack.method_31574(class_1802.field_8071) && this.getTrust() < 10) {
            if (worldTime - this.lastTrustFeedTime >= 12000L) {
                this.updateTrust(1);
                this.lastTrustFeedTime = worldTime;
                this.method_5783(class_3417.field_15099, 1.0f, 1.0f);
                if (!player.method_7337()) {
                    itemStack.method_7934(1);
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        if (itemStack.method_31574(class_1802.field_42716) && this.hasSnowLayer()) {
            if (!this.method_37908().field_9236) {
                this.setHasSnowLayer(false);
                this.snowMeltTimer = 0;
                int count = 3 + this.method_37908().field_9229.method_43048(2);
                this.method_5775(new class_1799((class_1935)class_1802.field_8543, count));
            }
            SnowLayerUtil.spawnSnowParticles((class_1309)this);
            this.method_5783(class_3417.field_15165, 1.0f, 1.0f);
            if (!player.method_7337()) {
                itemStack.method_7970(1, (class_1309)player, class_1304.field_6173);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1657 player;
        class_1297 attacker;
        boolean result = super.method_5643(source, amount);
        if (!this.method_37908().field_9236 && this.isTamed() && this.method_6139() != null && (attacker = source.method_5529()) instanceof class_1657 && (player = (class_1657)attacker).method_5667().equals(this.method_6139())) {
            this.updateTrust(-1);
        }
        return result;
    }

    public void method_5773() {
        super.method_5773();
        SnowLayerUtil.handleSnowLayerTick((class_1309)this, this);
        if (!this.method_37908().method_8608()) {
            boolean currentlyMovingFast;
            boolean bl = currentlyMovingFast = this.method_18798().method_37268() > 0.0025000000000000005;
            if (this.isRunning() != currentlyMovingFast) {
                this.setRunning(currentlyMovingFast);
            }
        }
        class_243 velocity = this.method_18798();
        if (this.method_37908().method_8608() && velocity.method_37268() > 0.0025000000000000005 && this.field_6012 % 2 == 0) {
            double offsetX = (this.field_5974.method_43058() - 0.5) * 0.6;
            double offsetZ = (this.field_5974.method_43058() - 0.5) * 0.6;
            this.method_37908().method_8406((class_2394)ModParticles.UNICORN_DUST, this.method_23317() + offsetX, this.method_23318() + 0.2, this.method_23321() + offsetZ, 0.0, 0.01, 0.0);
        }
        if (this.hornRubCooldown > 0) {
            --this.hornRubCooldown;
        }
    }

    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "water_controller", 5, this::waterPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "sleep_controller", 5, this::sleepPredicate));
    }

    private <P extends GeoAnimatable> PlayState landPredicate(AnimationState<P> state) {
        if (this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.isRunning()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.unicorn.run", Animation.LoopType.LOOP));
        } else if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.unicorn.walk", Animation.LoopType.LOOP));
        } else if (this.isRubbing()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.unicorn.rubbing", Animation.LoopType.LOOP));
        } else if (this.isEating()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.unicorn.eat", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.unicorn.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState waterPredicate(AnimationState<T> state) {
        if (!this.method_5799()) {
            return PlayState.STOP;
        }
        state.getController().setAnimation(RawAnimation.begin().then("animation.unicorn.swim", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState sleepPredicate(AnimationState<T> state) {
        if (this.method_6113()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.unicorn.sleep", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    public boolean method_5931() {
        return !this.method_6113();
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (state.method_26227().method_15767(class_3486.field_15517) || state.method_26227().method_15767(class_3486.field_15518)) {
            return;
        }
        if (this.isRunning()) {
            ++this.soundTicks;
            if (this.soundTicks % 3 == 0) {
                if (this.field_5974.method_43048(10) == 0) {
                    this.method_56078(class_3417.field_14556);
                }
                this.method_56078(class_3417.field_14987);
            }
        } else {
            this.method_56078(class_3417.field_14613);
        }
    }

    protected class_3414 method_5994() {
        if (this.method_6113()) {
            return null;
        }
        return class_3417.field_14947;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14923;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15166;
    }

    public static boolean canSpawn(class_1299<UnicornEntity> type, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        if (!(world instanceof class_5425)) {
            return false;
        }
        class_5425 serverAccess = (class_5425)world;
        class_3218 w = serverAccess.method_8410();
        if (w.method_8530()) {
            return false;
        }
        if (w.method_30273() != 0) {
            return false;
        }
        if (w.method_8419() || w.method_8546()) {
            return false;
        }
        return !(random.method_43057() >= 0.5f);
    }

    private boolean playerHasTrustedUnicornNearby(class_1657 player) {
        List unicorns = player.method_37908().method_8390(UnicornEntity.class, player.method_5829().method_1014(8.0), unicorn -> unicorn.isTamed() && unicorn.method_6139() != null && unicorn.method_6139().equals(player.method_5667()) && unicorn.getTrust() == 10);
        return !unicorns.isEmpty();
    }

    public static class RubHornOnLogGoal
    extends class_1352 {
        private final UnicornEntity unicorn;
        private final double range;
        private class_2338 logPos;
        private int rubTime = 0;
        private static final int MAX_RUB_TIME = 100;

        public RubHornOnLogGoal(UnicornEntity unicorn, double range) {
            this.unicorn = unicorn;
            this.range = range;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.unicorn.method_6109() || this.unicorn.method_5816() || this.unicorn.getHornRubCooldown() > 0 || this.unicorn.method_60953() || this.unicorn.method_6113() || this.unicorn.getTrust() < 1) {
                return false;
            }
            this.logPos = this.findNearbyLogAtEyeHeight();
            return this.logPos != null;
        }

        public boolean method_6266() {
            if (this.logPos == null) {
                return false;
            }
            if (!this.unicorn.method_37908().method_8320(this.logPos).method_26164(class_3481.field_15475)) {
                return false;
            }
            if (this.unicorn.method_60953()) {
                return false;
            }
            double dx = (double)this.logPos.method_10263() + 0.5 - this.unicorn.method_23317();
            double dz = (double)this.logPos.method_10260() + 0.5 - this.unicorn.method_23321();
            double horizontalDistSq = dx * dx + dz * dz;
            if (!this.unicorn.isRubbing()) {
                return horizontalDistSq > 0.25;
            }
            return this.rubTime < 100 && horizontalDistSq <= 4.0;
        }

        public void method_6269() {
            this.rubTime = 0;
            this.unicorn.setRubbing(false);
            if (this.logPos != null) {
                double dz;
                double dx = (double)this.logPos.method_10263() + 0.5 - this.unicorn.method_23317();
                double horizontalDistSq = dx * dx + (dz = (double)this.logPos.method_10260() + 0.5 - this.unicorn.method_23321()) * dz;
                if (horizontalDistSq > 0.25) {
                    this.unicorn.method_5942().method_6337((double)this.logPos.method_10263() + 0.5, this.unicorn.method_23318(), (double)this.logPos.method_10260() + 0.5, 1.0);
                } else {
                    this.unicorn.setRubbing(true);
                }
            }
        }

        public void method_6268() {
            if (this.logPos == null) {
                return;
            }
            double dx = (double)this.logPos.method_10263() + 0.5 - this.unicorn.method_23317();
            double dz = (double)this.logPos.method_10260() + 0.5 - this.unicorn.method_23321();
            float yaw = (float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            this.unicorn.method_36456(yaw);
            this.unicorn.method_5847(yaw);
            this.unicorn.field_6283 = yaw;
            double horizontalDistSq = dx * dx + dz * dz;
            if (!this.unicorn.isRubbing()) {
                if (horizontalDistSq > 0.25) {
                    this.unicorn.method_5942().method_6337((double)this.logPos.method_10263() + 0.5, this.unicorn.method_23318(), (double)this.logPos.method_10260() + 0.5, 1.0);
                }
                if (horizontalDistSq <= 4.0) {
                    this.unicorn.method_5942().method_6340();
                    this.unicorn.setRubbing(true);
                    this.rubTime = 0;
                }
                return;
            }
            ++this.rubTime;
            if (this.rubTime % 20 == 0) {
                this.unicorn.method_5783(class_3417.field_14808, 0.6f, 0.9f + this.unicorn.method_59922().method_43057() * 0.2f);
                class_1937 class_19372 = this.unicorn.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    class_243 lookDir = this.unicorn.method_5828(1.0f);
                    double forwardOffset = 1.3;
                    double verticalOffset = 2.0;
                    double sideOffset = 0.0;
                    double px = this.unicorn.method_23317() + lookDir.field_1352 * forwardOffset;
                    double py = this.unicorn.method_23318() + verticalOffset;
                    double pz = this.unicorn.method_23321() + lookDir.field_1350 * forwardOffset;
                    double spread = 0.05;
                    serverWorld.method_14199((class_2394)ModParticles.UNICORN_DUST, px, py, pz, 4, spread, spread, spread, 0.0);
                }
            }
            if (this.rubTime >= 100 && !this.unicorn.method_37908().method_8608()) {
                this.unicorn.resetHornRubCooldown();
                int trust = this.unicorn.getTrust();
                if (trust > 0) {
                    float dropChance = Math.min((float)trust * 0.2f, 1.0f);
                    if (this.unicorn.method_59922().method_43057() < dropChance) {
                        class_1799 dust = new class_1799((class_1935)ModItems.UNICORN_DUST);
                        double spawnX = this.unicorn.method_23317();
                        double spawnY = this.unicorn.method_23323(1.0);
                        double spawnZ = this.unicorn.method_23321();
                        class_1542 itemEntity = new class_1542(this.unicorn.method_37908(), spawnX, spawnY, spawnZ, dust);
                        itemEntity.method_18800((this.unicorn.method_59922().method_43058() - 0.5) * 0.1, 0.25 + this.unicorn.method_59922().method_43058() * 0.1, (this.unicorn.method_59922().method_43058() - 0.5) * 0.1);
                        this.unicorn.method_37908().method_8649((class_1297)itemEntity);
                    }
                }
            }
        }

        public void method_6270() {
            this.unicorn.method_5942().method_6340();
            this.logPos = null;
            this.rubTime = 0;
            this.unicorn.setRubbing(false);
        }

        private class_2338 findNearbyLogAtEyeHeight() {
            class_1937 world = this.unicorn.method_37908();
            class_5819 random = this.unicorn.method_59922();
            int rangeInt = (int)this.range;
            int eyeY = this.unicorn.method_31478() + (int)this.unicorn.method_5751();
            for (int i = 0; i < 20; ++i) {
                class_2338 candidate = this.unicorn.method_24515().method_10069(random.method_43048(rangeInt) - rangeInt / 2, 0, random.method_43048(rangeInt) - rangeInt / 2).method_33096(eyeY);
                if (!world.method_8320(candidate).method_26164(class_3481.field_15475)) continue;
                return candidate;
            }
            return null;
        }
    }

    static class FleeGoal
    extends class_1338<class_1657> {
        private final UnicornEntity unicorn;

        public FleeGoal(UnicornEntity unicorn, double distance, double slowSpeed, double fastSpeed) {
            super((class_1314)unicorn, class_1657.class, (float)distance, slowSpeed, fastSpeed, targetEntity -> {
                if (!(targetEntity instanceof class_1657)) {
                    return false;
                }
                class_1657 player = (class_1657)targetEntity;
                if (unicorn.playerHasTrustedUnicornNearby(player)) {
                    return false;
                }
                class_1799 stack = player.method_6047();
                return !player.method_5715() || !stack.method_7960() && stack.method_31573(class_3489.field_48305);
            });
            this.unicorn = unicorn;
        }

        public boolean method_6264() {
            if (this.unicorn.isTamed() || this.unicorn.method_6113()) {
                return false;
            }
            return super.method_6264();
        }

        public boolean method_6266() {
            if (this.unicorn.isTamed() || this.unicorn.method_6113()) {
                return false;
            }
            return super.method_6266();
        }

        public void method_6269() {
            super.method_6269();
            this.unicorn.setRunning(true);
        }

        public void method_6270() {
            super.method_6270();
            this.unicorn.setRunning(false);
        }
    }
}

