/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import net.domixcze.domixscreatures.block.ModBlocks;
import net.domixcze.domixscreatures.entity.ai.Beachable;
import net.domixcze.domixscreatures.entity.ai.BeachedGoal;
import net.domixcze.domixscreatures.entity.client.whale.WhaleVariants;
import net.domixcze.domixscreatures.sound.ModSounds;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1332;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1378;
import net.minecraft.class_1408;
import net.minecraft.class_1412;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_4017;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5757;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WhaleEntity
extends class_1480
implements GeoEntity,
Beachable {
    private static final class_2940<Integer> BARNACLE_COUNT = class_2945.method_12791(WhaleEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> BEACHED = class_2945.method_12791(WhaleEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(WhaleEntity.class, (class_2941)class_2943.field_13327);
    private static final int BARNACLE_REGEN_COOLDOWN = 12000;
    private int barnacleRegenTimer = 12000;
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public WhaleEntity(class_1299<? extends class_1480> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_5757((class_1308)this, 70, 5, 0.01f, 0.05f, true);
        this.field_6206 = new class_1332((class_1308)this, 8);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new BeachedGoal(this, (class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new WhaleJumpGoal(this, 10));
        this.field_6201.method_6277(2, (class_1352)new class_1378((class_1314)this, 0.8, 12));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1480.method_26828().method_26868(class_5134.field_23716, 100.0).method_26868(class_5134.field_23719, 2.0).method_26868(class_5134.field_23721, 10.0);
    }

    public void method_6005(double strength, double x, double z) {
        super.method_6005(strength * 0.1, x, z);
    }

    public boolean method_5810() {
        return false;
    }

    protected class_1408 method_5965(class_1937 world) {
        return new class_1412((class_1308)this, world);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        entityData = super.method_5943(world, difficulty, spawnReason, entityData);
        if (world.method_8409().method_43058() < 0.05) {
            this.setVariant(WhaleVariants.ALBINO);
        } else {
            this.setVariant(WhaleVariants.NORMAL);
        }
        return entityData;
    }

    public WhaleVariants getVariant() {
        return WhaleVariants.values()[(Integer)this.field_6011.method_12789(VARIANT)];
    }

    public void setVariant(WhaleVariants variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.ordinal());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "water_controller", 5, this::waterPredicate));
    }

    private <T extends GeoAnimatable> PlayState waterPredicate(AnimationState<T> state) {
        if (this.method_18798().method_37268() > 1.0E-9 && this.method_5799()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.whale.swim", Animation.LoopType.LOOP));
        } else if (this.isBeached()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.whale.beached", Animation.LoopType.HOLD_ON_LAST_FRAME));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.whale.idle_swim", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)WhaleVariants.NORMAL.ordinal());
        builder.method_56912(BEACHED, (Object)false);
        builder.method_56912(BARNACLE_COUNT, (Object)0);
    }

    @Override
    public boolean isBeached() {
        return (Boolean)this.field_6011.method_12789(BEACHED);
    }

    @Override
    public void setBeached(boolean beached) {
        this.field_6011.method_12778(BEACHED, (Object)beached);
    }

    public int getBarnacleCount() {
        return (Integer)this.field_6011.method_12789(BARNACLE_COUNT);
    }

    public void setBarnacleCount(int number) {
        this.field_6011.method_12778(BARNACLE_COUNT, (Object)number);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getVariant().ordinal());
        nbt.method_10556("Beached", this.isBeached());
        nbt.method_10569("BarnacleCount", this.getBarnacleCount());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(WhaleVariants.values()[nbt.method_10550("Variant")]);
        this.setBeached(nbt.method_10577("Beached"));
        this.setBarnacleCount(nbt.method_10550("BarnacleCount"));
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_8868)) {
            if (!this.method_37908().field_9236) {
                int currentNumber = this.getBarnacleCount();
                if (currentNumber > 0) {
                    this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14975, class_3419.field_15248, 1.0f, 1.0f);
                    this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
                    this.method_5706((class_1935)ModBlocks.BARNACLE_BLOCK);
                    this.setBarnacleCount(currentNumber - 1);
                    itemStack.method_7970(1, (class_1309)player, class_1304.field_6173);
                    return class_1269.field_5812;
                }
            } else {
                return class_1269.field_21466;
            }
        }
        return super.method_5992(player, hand);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236 && this.getBarnacleCount() < 9) {
            if (this.barnacleRegenTimer > 0) {
                --this.barnacleRegenTimer;
            } else {
                this.setBarnacleCount(this.getBarnacleCount() + 1);
                this.barnacleRegenTimer = 12000;
            }
        }
    }

    protected class_3414 method_5994() {
        if (this.isBeached()) {
            return null;
        }
        return ModSounds.WHALE_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.WHALE_HURT;
    }

    protected class_3414 method_6002() {
        return ModSounds.WHALE_DEATH;
    }

    private static class WhaleJumpGoal
    extends class_4017 {
        private static final int[] OFFSET_MULTIPLIERS = new int[]{0, 2, 6, 8, 10, 12};
        private final WhaleEntity whale;
        private final int chance;
        private boolean inWater;

        public WhaleJumpGoal(WhaleEntity whale, int chance) {
            this.whale = whale;
            this.chance = WhaleJumpGoal.method_38848((int)chance);
        }

        public boolean method_6264() {
            if (this.whale.method_59922().method_43048(this.chance) != 0) {
                return false;
            }
            class_2350 direction = this.whale.method_5755();
            int i = direction.method_10148();
            int j = direction.method_10165();
            class_2338 blockPos = this.whale.method_24515();
            for (int k : OFFSET_MULTIPLIERS) {
                if (this.isWater(blockPos, i, j, k) && this.isAirAbove(blockPos, i, j, k)) continue;
                return false;
            }
            return true;
        }

        private boolean isWater(class_2338 pos, int offsetX, int offsetZ, int multiplier) {
            class_2338 blockPos = pos.method_10069(offsetX * multiplier, 0, offsetZ * multiplier);
            return this.whale.method_37908().method_8316(blockPos).method_15767(class_3486.field_15517) && !this.whale.method_37908().method_8320(blockPos).method_51366();
        }

        private boolean isAirAbove(class_2338 pos, int offsetX, int offsetZ, int multiplier) {
            return this.whale.method_37908().method_8320(pos.method_10069(offsetX * multiplier, 1, offsetZ * multiplier)).method_26215() && this.whale.method_37908().method_8320(pos.method_10069(offsetX * multiplier, 2, offsetZ * multiplier)).method_26215();
        }

        public boolean method_6266() {
            double d = this.whale.method_18798().field_1351;
            return !(d * d < (double)0.03f && this.whale.method_36455() != 0.0f && Math.abs(this.whale.method_36455()) < 10.0f && this.whale.method_5799() || this.whale.method_24828());
        }

        public boolean method_6267() {
            return false;
        }

        public void method_6269() {
            class_2350 direction = this.whale.method_5755();
            this.whale.method_18799(this.whale.method_18798().method_1031((double)direction.method_10148() * 0.8, 0.9, (double)direction.method_10165() * 1.2));
            this.whale.method_5942().method_6340();
        }

        public void method_6270() {
            this.whale.method_36457(0.0f);
        }

        public void method_6268() {
            boolean bl = this.inWater;
            if (!bl) {
                class_3610 fluidState = this.whale.method_37908().method_8316(this.whale.method_24515());
                this.inWater = fluidState.method_15767(class_3486.field_15517);
            }
            if (this.inWater && !bl) {
                this.whale.method_5783(class_3417.field_14707, 1.0f, 1.0f);
            }
            class_243 vec3d = this.whale.method_18798();
            if (vec3d.field_1351 * vec3d.field_1351 < 0.05 && Math.abs(this.whale.method_36455()) > 0.5f) {
                this.whale.method_36457(class_3532.method_17821((float)0.1f, (float)this.whale.method_36455(), (float)0.0f));
            } else if (vec3d.method_1033() > (double)1.0E-5f) {
                double d = vec3d.method_37267();
                double e = Math.atan2(-vec3d.field_1351, d) * 57.2957763671875;
                this.whale.method_36457((float)e);
            }
        }
    }
}

