/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.item.guide;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.domixcze.domixscreatures.DomiXsCreatures;
import net.domixcze.domixscreatures.item.guide.GuideEntryJson;
import net.domixcze.domixscreatures.item.guide.GuideMainScreen;
import net.domixcze.domixscreatures.item.guide.ImageEntryJson;
import net.domixcze.domixscreatures.item.guide.PageContentJson;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_7923;

public class GuideDataLoader
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String GUIDE_ENTRIES_PATH = "guide_entries";
    private static final Map<GuideMainScreen.Category, List<List<GuideMainScreen.LightweightMenuEntry>>> LOADED_MENU_ENTRIES = new EnumMap<GuideMainScreen.Category, List<List<GuideMainScreen.LightweightMenuEntry>>>(GuideMainScreen.Category.class);
    private static final Map<class_2960, List<GuideMainScreen.PageContent>> CACHED_FULL_ENTRIES = new HashMap<class_2960, List<GuideMainScreen.PageContent>>();

    public static Map<GuideMainScreen.Category, List<List<GuideMainScreen.LightweightMenuEntry>>> getLoadedMenuEntries() {
        return LOADED_MENU_ENTRIES;
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"domixs-creatures", (String)"guide_data_loader");
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            prepareProfiler.method_15396("guide_data_prepare");
            this.loadAllGuideEntries(manager);
            prepareProfiler.method_15407();
            return null;
        }, prepareExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenAcceptAsync(object -> {
            applyProfiler.method_15396("guide_data_apply");
            applyProfiler.method_15407();
        }, applyExecutor);
    }

    private void loadAllGuideEntries(class_3300 manager) {
        CompletableFuture.runAsync(() -> {
            DomiXsCreatures.LOGGER.info("Loading guide book entries...");
            LOADED_MENU_ENTRIES.clear();
            CACHED_FULL_ENTRIES.clear();
            for (GuideMainScreen.Category category : GuideMainScreen.Category.values()) {
                LOADED_MENU_ENTRIES.put(category, new ArrayList());
            }
            Map resources = manager.method_14488(GUIDE_ENTRIES_PATH, path -> path.method_12832().endsWith(".json"));
            for (Map.Entry entry : resources.entrySet()) {
                class_2960 id = (class_2960)entry.getKey();
                class_3298 resource = (class_3298)entry.getValue();
                try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
                    GuideEntryJson json = (GuideEntryJson)GSON.fromJson((Reader)reader, GuideEntryJson.class);
                    if (json.entry_id == null || json.category == null || json.title == null || json.button_text == null) {
                        DomiXsCreatures.LOGGER.warn("Skipping malformed guide entry {}: Missing essential fields (entry_id, category, title, button_text).", (Object)id);
                        continue;
                    }
                    GuideMainScreen.Category category = GuideMainScreen.Category.fromString(json.category);
                    if (category == null) {
                        DomiXsCreatures.LOGGER.warn("Skipping guide entry {}: Unknown category '{}'.", (Object)id, (Object)json.category);
                        continue;
                    }
                    GuideMainScreen.LightweightMenuEntry lightweightEntry = new GuideMainScreen.LightweightMenuEntry(json.button_text, json.title, id, category);
                    List<List<GuideMainScreen.LightweightMenuEntry>> categoryPages = LOADED_MENU_ENTRIES.get((Object)category);
                    if (categoryPages.isEmpty() || categoryPages.getLast().size() >= 8) {
                        categoryPages.add(new ArrayList());
                    }
                    categoryPages.getLast().add(lightweightEntry);
                }
                catch (JsonSyntaxException e) {
                    DomiXsCreatures.LOGGER.error("Failed to parse guide entry JSON {}: {}", (Object)id, (Object)e.getMessage());
                }
                catch (IOException e) {
                    DomiXsCreatures.LOGGER.error("Failed to read guide entry file {}: {}", (Object)id, (Object)e.getMessage());
                }
                catch (Exception e) {
                    DomiXsCreatures.LOGGER.error("An unexpected error occurred while processing guide entry {}: {}", new Object[]{id, e.getMessage(), e});
                }
            }
            DomiXsCreatures.LOGGER.info("Loaded {} guide entries.", (Object)LOADED_MENU_ENTRIES.values().stream().flatMap(Collection::stream).mapToInt(List::size).sum());
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<GuideMainScreen.PageContent> getEntryContent(class_2960 entryJsonId) {
        if (CACHED_FULL_ENTRIES.containsKey(entryJsonId)) {
            return CACHED_FULL_ENTRIES.get(entryJsonId);
        }
        class_3300 manager = class_310.method_1551().method_1478();
        ArrayList<GuideMainScreen.PageContent> fullContent = new ArrayList<GuideMainScreen.PageContent>();
        Optional optionalResource = manager.method_14486(entryJsonId);
        if (optionalResource.isEmpty()) {
            DomiXsCreatures.LOGGER.error("Guide entry JSON file not found: {}", (Object)entryJsonId);
            return List.of();
        }
        try (InputStreamReader reader = new InputStreamReader(((class_3298)optionalResource.get()).method_14482());){
            GuideEntryJson json = (GuideEntryJson)GSON.fromJson((Reader)reader, GuideEntryJson.class);
            if (json == null || json.pages == null) {
                DomiXsCreatures.LOGGER.error("Parsed guide entry JSON is null or has no pages: {}", (Object)entryJsonId);
                List<GuideMainScreen.PageContent> list = List.of();
                return list;
            }
            for (PageContentJson pageJson : json.pages) {
                ArrayList<class_2561> textContent = new ArrayList<class_2561>();
                if (pageJson.text_content != null) {
                    for (String textLine : pageJson.text_content) {
                        textContent.add((class_2561)class_2561.method_43471((String)textLine));
                    }
                }
                ArrayList<GuideMainScreen.ImageEntry> images = new ArrayList<GuideMainScreen.ImageEntry>();
                if (pageJson.images != null) {
                    for (ImageEntryJson imgJson : pageJson.images) {
                        try {
                            GuideMainScreen.ImageEntry img = GuideDataLoader.convertImageEntry(imgJson);
                            if (img == null) continue;
                            images.add(img);
                        }
                        catch (Exception e) {
                            DomiXsCreatures.LOGGER.warn("Failed to convert image entry for {}: {} - {}", new Object[]{entryJsonId, imgJson.id, e.getMessage()});
                        }
                    }
                }
                fullContent.add(new GuideMainScreen.PageContent(textContent, images));
            }
            CACHED_FULL_ENTRIES.put(entryJsonId, fullContent);
            ArrayList<GuideMainScreen.PageContent> arrayList = fullContent;
            return arrayList;
        }
        catch (JsonSyntaxException e) {
            DomiXsCreatures.LOGGER.error("Failed to parse full guide entry JSON {}: {}", (Object)entryJsonId, (Object)e.getMessage());
        }
        catch (IOException e) {
            DomiXsCreatures.LOGGER.error("Failed to read full guide entry file {}: {}", (Object)entryJsonId, (Object)e.getMessage());
        }
        catch (Exception e) {
            DomiXsCreatures.LOGGER.error("An unexpected error occurred while loading full guide entry {}: {}", new Object[]{entryJsonId, e.getMessage(), e});
        }
        return List.of();
    }

    private static GuideMainScreen.ImageEntry convertImageEntry(ImageEntryJson json) {
        int frameDuration;
        if (json.type == null) {
            DomiXsCreatures.LOGGER.warn("Image entry is missing type in JSON: {}", (Object)json);
            return null;
        }
        int n = frameDuration = json.frame_duration_ticks > 0 ? json.frame_duration_ticks : 100;
        if ("item".equalsIgnoreCase(json.type)) {
            if (json.id == null) {
                DomiXsCreatures.LOGGER.warn("Item image entry missing 'id' in JSON: {}", (Object)json);
                return null;
            }
            class_2960 id = class_2960.method_60654((String)json.id);
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            if (item == class_1802.field_8162 && !id.equals((Object)class_2960.method_60655((String)"minecraft", (String)"air"))) {
                DomiXsCreatures.LOGGER.warn("Item not found for ID '{}' from JSON. Skipping.", (Object)json.id);
                return null;
            }
            return GuideMainScreen.ImageEntry.item(new class_1799((class_1935)item), json.x, json.y, json.width, json.height);
        }
        if ("texture".equalsIgnoreCase(json.type)) {
            if (json.id == null) {
                DomiXsCreatures.LOGGER.warn("Texture image entry missing 'id' in JSON: {}", (Object)json);
                return null;
            }
            class_2960 id = class_2960.method_60654((String)json.id);
            return GuideMainScreen.ImageEntry.texture(id, json.x, json.y, json.width, json.height);
        }
        if ("cycling_item".equalsIgnoreCase(json.type)) {
            if (json.ids == null || json.ids.isEmpty()) {
                DomiXsCreatures.LOGGER.warn("Cycling item entry missing 'ids' list in JSON: {}", (Object)json);
                return null;
            }
            ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
            for (String itemIdStr : json.ids) {
                class_2960 id = class_2960.method_60654((String)itemIdStr);
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
                if (item == class_1802.field_8162 && !id.equals((Object)class_2960.method_60655((String)"minecraft", (String)"air"))) {
                    DomiXsCreatures.LOGGER.warn("Item not found for ID '{}' in cycling list. Skipping this frame.", (Object)itemIdStr);
                    continue;
                }
                itemStacks.add(new class_1799((class_1935)item));
            }
            if (itemStacks.isEmpty()) {
                DomiXsCreatures.LOGGER.warn("No valid items found for cycling_item entry with ID(s): {}. Skipping this entry.", json.ids);
                return null;
            }
            return GuideMainScreen.ImageEntry.cyclingItem(itemStacks, frameDuration, json.x, json.y, json.width, json.height);
        }
        if ("cycling_texture".equalsIgnoreCase(json.type)) {
            if (json.ids == null || json.ids.isEmpty()) {
                DomiXsCreatures.LOGGER.warn("Cycling texture entry missing 'ids' list in JSON: {}", (Object)json);
                return null;
            }
            ArrayList<class_2960> identifiers = new ArrayList<class_2960>();
            for (String textureIdStr : json.ids) {
                identifiers.add(class_2960.method_60654((String)textureIdStr));
            }
            if (identifiers.isEmpty()) {
                DomiXsCreatures.LOGGER.warn("No valid textures found for cycling_texture entry with ID(s): {}. Skipping this entry.", json.ids);
                return null;
            }
            return GuideMainScreen.ImageEntry.cyclingTexture(identifiers, frameDuration, json.x, json.y, json.width, json.height);
        }
        DomiXsCreatures.LOGGER.warn("Unknown image type '{}' in JSON for ImageEntry with ID(s): {}. Skipping.", (Object)json.type, json.id != null ? json.id : json.ids);
        return null;
    }
}

