/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.world.tree.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.domixcze.domixscreatures.world.tree.ModFoliagePlacerTypes;
import net.minecraft.class_2338;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4648;
import net.minecraft.class_5819;
import net.minecraft.class_6017;

public class SpectralFoliagePlacer
extends class_4647 {
    public static final MapCodec<SpectralFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(spectralFoliagePlacerInstance -> SpectralFoliagePlacer.method_30411((RecordCodecBuilder.Instance)spectralFoliagePlacerInstance).and((App)Codec.intRange((int)0, (int)12).fieldOf("height").forGetter(instance -> instance.height)).apply((Applicative)spectralFoliagePlacerInstance, SpectralFoliagePlacer::new));
    private final int height;

    public SpectralFoliagePlacer(class_6017 radius, class_6017 offset, int height) {
        super(radius, offset);
        this.height = height;
    }

    protected class_4648<?> method_28843() {
        return ModFoliagePlacerTypes.SPECTRAL_FOLIAGE_PLACER;
    }

    protected void method_23448(class_3746 world, class_4647.class_8179 placer, class_5819 random, class_4643 config, int trunkHeight, class_4647.class_5208 treeNode, int foliageHeight, int radius, int offset) {
        int currentRadius;
        int y;
        class_2338 center = treeNode.method_27388();
        for (y = offset; y >= offset - foliageHeight; --y) {
            currentRadius = Math.max(radius + treeNode.method_27389() - 1 - y / 2, 0);
            this.method_23449(world, placer, random, config, center, currentRadius, y, treeNode.method_27390());
        }
        for (y = offset - foliageHeight; y <= offset; ++y) {
            currentRadius = Math.max(radius + treeNode.method_27389() - 1 - y / 2, 0);
            for (int dx = -currentRadius; dx <= currentRadius; ++dx) {
                for (int dz = -currentRadius; dz <= currentRadius; ++dz) {
                    if (!(random.method_43057() < 0.3f)) continue;
                    for (int dy = 1; dy <= 2; ++dy) {
                        class_2338 hangingPos = center.method_10069(dx, y - dy, dz);
                        this.placeLeavesBlock(world, placer, random, config, hangingPos);
                    }
                }
            }
        }
    }

    public int method_26989(class_5819 random, int trunkHeight, class_4643 config) {
        return this.height;
    }

    protected boolean method_23451(class_5819 random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return dx == radius && dz == radius && (random.method_43048(2) == 0 || y == 0);
    }

    private void placeLeavesBlock(class_3746 world, class_4647.class_8179 placer, class_5819 random, class_4643 config, class_2338 pos) {
        if (world.method_16358(pos, state -> state.method_26215())) {
            placer.method_49240(pos, config.field_29280.method_23455(random, pos));
        }
    }
}

