/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.world.tree.custom;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.domixcze.domixscreatures.world.tree.ModTrunkPlacerTypes;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4970;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;

public class SpectralTrunkPlacer
extends class_5141 {
    public static final MapCodec<SpectralTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(objectInstance -> SpectralTrunkPlacer.method_28904((RecordCodecBuilder.Instance)objectInstance).apply((Applicative)objectInstance, SpectralTrunkPlacer::new));

    public SpectralTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    protected class_5142<?> method_28903() {
        return ModTrunkPlacerTypes.SPECTRAL_TRUNK_PLACER;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        class_2350[] sideBranchDirections;
        class_2350[] mainBranchDirections;
        ArrayList<class_4647.class_5208> foliageNodes = new ArrayList<class_4647.class_5208>();
        height = Math.min(height, random.method_43048(2) + 4);
        for (int y = 0; y < height; ++y) {
            class_2338 currentPos = startPos.method_10086(y);
            this.placeLog(replacer, world, currentPos, class_2350.class_2351.field_11052, config, random);
        }
        class_2338 topPos = startPos.method_10086(height - 1);
        for (class_2350 direction : mainBranchDirections = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039}) {
            this.generateMainBranch(world, replacer, random, topPos, direction, config, foliageNodes);
        }
        class_2338 extendedTrunkPos = topPos.method_10086(5);
        for (int y = 0; y < 7; ++y) {
            class_2338 trunkPos = extendedTrunkPos.method_10087(6 - y);
            this.placeLog(replacer, world, trunkPos, class_2350.class_2351.field_11052, config, random);
        }
        foliageNodes.add(new class_4647.class_5208(extendedTrunkPos, 0, false));
        class_2338 branchBasePos = extendedTrunkPos.method_10087(2);
        for (class_2350 direction : sideBranchDirections = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039}) {
            this.generateSideBranch(world, replacer, random, branchBasePos, direction, config, foliageNodes);
        }
        return foliageNodes;
    }

    private void generateMainBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338 startPos, class_2350 direction, class_4643 config, List<class_4647.class_5208> foliageNodes) {
        int branchLength = random.method_43048(2) + 3;
        class_2338 branchPos = startPos;
        for (int i = 0; i < branchLength; ++i) {
            branchPos = branchPos.method_10093(direction);
            if (i % 2 == 0) {
                branchPos = branchPos.method_10086(1);
            }
            this.placeLog(replacer, world, branchPos, direction.method_10166(), config, random);
            if (i > 1 && random.method_43057() < 0.5f) {
                this.generateSubBranch(world, replacer, random, branchPos, direction, config, foliageNodes);
            }
            if (i != branchLength - 1) continue;
            foliageNodes.add(new class_4647.class_5208(branchPos, 0, false));
        }
    }

    private void generateSubBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338 startPos, class_2350 parentDirection, class_4643 config, List<class_4647.class_5208> foliageNodes) {
        int subBranchLength = random.method_43048(2) + 2;
        class_2350 direction = parentDirection.method_10170();
        class_2338 branchPos = startPos;
        for (int i = 0; i < subBranchLength; ++i) {
            branchPos = branchPos.method_10093(direction);
            if (i % 2 == 0) {
                branchPos = branchPos.method_10086(1);
            }
            this.placeLog(replacer, world, branchPos, direction.method_10166(), config, random);
            if (i != subBranchLength - 1) continue;
            foliageNodes.add(new class_4647.class_5208(branchPos, 0, false));
        }
    }

    private void generateSideBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338 startPos, class_2350 direction, class_4643 config, List<class_4647.class_5208> foliageNodes) {
        int sideBranchLength = 2;
        class_2338 branchPos = startPos;
        for (int i = 0; i < sideBranchLength; ++i) {
            branchPos = branchPos.method_10093(direction);
            this.placeLog(replacer, world, branchPos, direction.method_10166(), config, random);
            if (i != sideBranchLength - 1) continue;
            foliageNodes.add(new class_4647.class_5208(branchPos, 0, false));
        }
    }

    private void placeLog(BiConsumer<class_2338, class_2680> replacer, class_3746 world, class_2338 pos, class_2350.class_2351 axis, class_4643 config, class_5819 random) {
        if (this.isAir(world, pos)) {
            replacer.accept(pos, (class_2680)config.field_21288.method_23455(random, pos).method_11657((class_2769)class_2741.field_12496, (Comparable)axis));
        }
    }

    private boolean isAir(class_3746 world, class_2338 pos) {
        return world.method_16358(pos, class_4970.class_4971::method_26215);
    }
}

