/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.display.editor.node;

import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.context.ClickContext;
import me.m56738.easyarmorstands.api.editor.context.UpdateContext;
import me.m56738.easyarmorstands.api.editor.node.ElementNode;
import me.m56738.easyarmorstands.api.editor.node.ResettableNode;
import me.m56738.easyarmorstands.api.editor.util.ToolMenuManager;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.display.api.property.type.BlockDisplayPropertyTypes;
import me.m56738.easyarmorstands.display.api.property.type.DisplayPropertyTypes;
import me.m56738.easyarmorstands.display.editor.node.DisplayMenuNode;
import me.m56738.easyarmorstands.display.element.DisplayElement;
import me.m56738.easyarmorstands.editor.input.OpenElementMenuInput;
import me.m56738.easyarmorstands.editor.input.ReturnInput;
import me.m56738.easyarmorstands.editor.node.ToolMenuModeSwitcher;
import me.m56738.easyarmorstands.lib.joml.Quaternionf;
import me.m56738.easyarmorstands.lib.joml.Vector3f;
import me.m56738.easyarmorstands.message.Message;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DisplayRootNode
extends DisplayMenuNode
implements ElementNode,
ResettableNode {
    private final Session session;
    private final DisplayElement<?> element;
    private final Property<Location> locationProperty;
    private final Property<BlockData> blockDataProperty;
    private final ToolMenuManager toolManager;
    private final ToolMenuModeSwitcher toolSwitcher;
    private final boolean allowMenu;

    public DisplayRootNode(Session session, DisplayElement<?> element) {
        super(session, session.properties(element));
        this.session = session;
        this.element = element;
        this.locationProperty = this.properties().get(EntityPropertyTypes.LOCATION);
        this.blockDataProperty = this.properties().getOrNull(BlockDisplayPropertyTypes.BLOCK);
        this.toolManager = new ToolMenuManager(session, this, element.getTools(this.properties()));
        this.toolSwitcher = new ToolMenuModeSwitcher(this.toolManager);
        this.allowMenu = session.player().hasPermission("easyarmorstands.open");
    }

    @Override
    public boolean onClick(@NotNull ClickContext context) {
        BlockData blockData;
        Block block;
        if (super.onClick(context)) {
            return true;
        }
        Player player = this.session.player();
        if (this.blockDataProperty != null && context.type() == ClickContext.Type.LEFT_CLICK && player.isSneaking() && (block = context.block()) != null && this.blockDataProperty.setValue(blockData = block.getBlockData())) {
            this.properties().commit();
            new EasPlayer(player).sendMessage(Message.success("easyarmorstands.success.changed-block", this.blockDataProperty.getType().getValueComponent(blockData)));
            return true;
        }
        return false;
    }

    @Override
    public void onUpdate(@NotNull UpdateContext context) {
        context.setActionBar(this.toolSwitcher.getActionBar());
        this.toolSwitcher.onUpdate(context);
        if (this.allowMenu) {
            context.addInput(new OpenElementMenuInput(this.session, this.element));
        }
        super.onUpdate(context);
        context.addInput(new ReturnInput(this.session));
    }

    @Override
    @NotNull
    public Element getElement() {
        return this.element;
    }

    @Override
    public void reset() {
        this.properties().get(DisplayPropertyTypes.TRANSLATION).setValue(new Vector3f());
        this.properties().get(DisplayPropertyTypes.LEFT_ROTATION).setValue(new Quaternionf());
        this.properties().get(DisplayPropertyTypes.SCALE).setValue(new Vector3f(1.0f));
        this.properties().get(DisplayPropertyTypes.RIGHT_ROTATION).setValue(new Quaternionf());
        Location location = this.locationProperty.getValue();
        location.setYaw(0.0f);
        location.setPitch(0.0f);
        this.locationProperty.setValue(location);
        this.properties().commit();
    }
}

