/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.history;

import java.util.ArrayDeque;
import java.util.List;
import java.util.UUID;
import me.m56738.easyarmorstands.history.ChangeTracker;
import me.m56738.easyarmorstands.history.action.Action;
import me.m56738.easyarmorstands.history.action.GroupAction;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class History {
    private final ArrayDeque<Action> past = new ArrayDeque();
    private final ArrayDeque<Action> future = new ArrayDeque();
    private final ChangeTracker tracker = new ChangeTracker(this);

    public ArrayDeque<Action> getPast() {
        return this.past;
    }

    public ArrayDeque<Action> getFuture() {
        return this.future;
    }

    public ChangeTracker getTracker() {
        return this.tracker;
    }

    public void push(Action action) {
        this.past.push(action);
        this.future.clear();
        while (this.past.size() > 100) {
            this.past.removeLast();
        }
    }

    public void push(List<? extends Action> actions, @Nullable Component description) {
        if (actions.size() == 1) {
            this.push(actions.get(0));
        } else if (actions.size() > 1) {
            this.push(new GroupAction(actions, description));
        }
    }

    public Action takeUndoAction() {
        Action action = this.past.poll();
        if (action != null) {
            this.future.push(action);
        }
        return action;
    }

    public Action takeRedoAction() {
        Action action = this.future.poll();
        if (action != null) {
            this.past.push(action);
        }
        return action;
    }

    public void onEntityReplaced(@NotNull UUID oldId, @NotNull UUID newId) {
        for (Action action : this.past) {
            action.onEntityReplaced(oldId, newId);
        }
        for (Action action : this.future) {
            action.onEntityReplaced(oldId, newId);
        }
    }
}

