/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.cloud.bukkit;

import java.lang.reflect.Method;
import me.m56738.easyarmorstands.lib.cloud.CommandManager;
import me.m56738.easyarmorstands.lib.cloud.bukkit.BukkitParserParameters;
import me.m56738.easyarmorstands.lib.cloud.bukkit.CloudBukkitCapabilities;
import me.m56738.easyarmorstands.lib.cloud.bukkit.annotation.specifier.AllowEmptySelection;
import me.m56738.easyarmorstands.lib.cloud.bukkit.annotation.specifier.DefaultNamespace;
import me.m56738.easyarmorstands.lib.cloud.bukkit.annotation.specifier.RequireExplicitNamespace;
import me.m56738.easyarmorstands.lib.cloud.bukkit.data.MultipleEntitySelector;
import me.m56738.easyarmorstands.lib.cloud.bukkit.data.MultiplePlayerSelector;
import me.m56738.easyarmorstands.lib.cloud.bukkit.internal.CraftBukkitReflection;
import me.m56738.easyarmorstands.lib.cloud.bukkit.parser.BlockPredicateParser;
import me.m56738.easyarmorstands.lib.cloud.bukkit.parser.EnchantmentParser;
import me.m56738.easyarmorstands.lib.cloud.bukkit.parser.ItemStackParser;
import me.m56738.easyarmorstands.lib.cloud.bukkit.parser.ItemStackPredicateParser;
import me.m56738.easyarmorstands.lib.cloud.bukkit.parser.MaterialParser;
import me.m56738.easyarmorstands.lib.cloud.bukkit.parser.NamespacedKeyParser;
import me.m56738.easyarmorstands.lib.cloud.bukkit.parser.OfflinePlayerParser;
import me.m56738.easyarmorstands.lib.cloud.bukkit.parser.PlayerParser;
import me.m56738.easyarmorstands.lib.cloud.bukkit.parser.WorldParser;
import me.m56738.easyarmorstands.lib.cloud.bukkit.parser.location.Location2DParser;
import me.m56738.easyarmorstands.lib.cloud.bukkit.parser.location.LocationParser;
import me.m56738.easyarmorstands.lib.cloud.bukkit.parser.selector.MultipleEntitySelectorParser;
import me.m56738.easyarmorstands.lib.cloud.bukkit.parser.selector.MultiplePlayerSelectorParser;
import me.m56738.easyarmorstands.lib.cloud.bukkit.parser.selector.SingleEntitySelectorParser;
import me.m56738.easyarmorstands.lib.cloud.bukkit.parser.selector.SinglePlayerSelectorParser;
import me.m56738.easyarmorstands.lib.cloud.parser.ParserParameters;
import me.m56738.easyarmorstands.lib.geantyref.TypeToken;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL)
public final class BukkitParsers {
    private BukkitParsers() {
    }

    public static <C> void register(CommandManager<C> manager) {
        manager.parserRegistry().registerParser(WorldParser.worldParser()).registerParser(MaterialParser.materialParser()).registerParser(PlayerParser.playerParser()).registerParser(OfflinePlayerParser.offlinePlayerParser()).registerParser(EnchantmentParser.enchantmentParser()).registerParser(LocationParser.locationParser()).registerParser(Location2DParser.location2DParser()).registerParser(ItemStackParser.itemStackParser()).registerParser(SingleEntitySelectorParser.singleEntitySelectorParser()).registerParser(SinglePlayerSelectorParser.singlePlayerSelectorParser());
        manager.parserRegistry().registerAnnotationMapper(AllowEmptySelection.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, annotation.value()));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultipleEntitySelector.class), parserParameters -> new MultipleEntitySelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultiplePlayerSelector.class), parserParameters -> new MultiplePlayerSelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        if (CraftBukkitReflection.classExists("org.bukkit.NamespacedKey")) {
            BukkitParsers.registerParserSupplierFor(manager, NamespacedKeyParser.class);
            manager.parserRegistry().registerAnnotationMapper(RequireExplicitNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.REQUIRE_EXPLICIT_NAMESPACE, true));
            manager.parserRegistry().registerAnnotationMapper(DefaultNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.DEFAULT_NAMESPACE, annotation.value()));
        }
        if (manager.hasCapability(CloudBukkitCapabilities.BRIGADIER)) {
            BukkitParsers.registerParserSupplierFor(manager, ItemStackPredicateParser.class);
            BukkitParsers.registerParserSupplierFor(manager, BlockPredicateParser.class);
        }
    }

    private static void registerParserSupplierFor(CommandManager<?> manager, @NonNull Class<?> argumentClass) {
        try {
            Method registerParserSuppliers = argumentClass.getDeclaredMethod("registerParserSupplier", CommandManager.class);
            registerParserSuppliers.setAccessible(true);
            registerParserSuppliers.invoke(null, manager);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

