/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.cloud.paper;

import com.destroystokyo.paper.brigadier.BukkitBrigadierCommandSource;
import com.destroystokyo.paper.event.brigadier.CommandRegisteredEvent;
import java.util.regex.Pattern;
import me.m56738.easyarmorstands.lib.cloud.CommandTree;
import me.m56738.easyarmorstands.lib.cloud.SenderMapper;
import me.m56738.easyarmorstands.lib.cloud.brigadier.BrigadierManagerHolder;
import me.m56738.easyarmorstands.lib.cloud.brigadier.CloudBrigadierCommand;
import me.m56738.easyarmorstands.lib.cloud.brigadier.CloudBrigadierManager;
import me.m56738.easyarmorstands.lib.cloud.brigadier.node.LiteralBrigadierNodeFactory;
import me.m56738.easyarmorstands.lib.cloud.brigadier.permission.BrigadierPermissionChecker;
import me.m56738.easyarmorstands.lib.cloud.bukkit.internal.BukkitBackwardsBrigadierSenderMapper;
import me.m56738.easyarmorstands.lib.cloud.bukkit.internal.BukkitBrigadierMapper;
import me.m56738.easyarmorstands.lib.cloud.bukkit.internal.BukkitHelper;
import me.m56738.easyarmorstands.lib.cloud.internal.CommandNode;
import me.m56738.easyarmorstands.lib.cloud.paper.LegacyPaperCommandManager;
import me.m56738.easyarmorstands.lib.cloud.paper.PaperBrigadierMappings;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.checkerframework.checker.nullness.qual.NonNull;

class LegacyPaperBrigadier<C>
implements Listener,
BrigadierManagerHolder<C, BukkitBrigadierCommandSource> {
    private final CloudBrigadierManager<C, BukkitBrigadierCommandSource> brigadierManager;
    private final LegacyPaperCommandManager<C> paperCommandManager;

    LegacyPaperBrigadier(@NonNull LegacyPaperCommandManager<C> paperCommandManager) {
        this.paperCommandManager = paperCommandManager;
        this.brigadierManager = new CloudBrigadierManager<Object, BukkitBrigadierCommandSource>(this.paperCommandManager, SenderMapper.create(sender -> this.paperCommandManager.senderMapper().map(sender.getBukkitSender()), new BukkitBackwardsBrigadierSenderMapper(this.paperCommandManager.senderMapper())));
        BukkitBrigadierMapper<C> mapper = new BukkitBrigadierMapper<C>(this.paperCommandManager.owningPlugin().getLogger(), this.brigadierManager);
        mapper.registerBuiltInMappings();
        PaperBrigadierMappings.register(mapper);
    }

    @Override
    public final boolean hasBrigadierManager() {
        return true;
    }

    @Override
    public final @NonNull CloudBrigadierManager<C, BukkitBrigadierCommandSource> brigadierManager() {
        return this.brigadierManager;
    }

    @EventHandler
    public void onCommandRegister(@NonNull CommandRegisteredEvent<BukkitBrigadierCommandSource> event) {
        String label;
        if (!(event.getCommand() instanceof PluginIdentifiableCommand)) {
            return;
        }
        if (!((PluginIdentifiableCommand)event.getCommand()).getPlugin().equals((Object)this.paperCommandManager.owningPlugin())) {
            return;
        }
        CommandTree commandTree = this.paperCommandManager.commandTree();
        CommandNode node = commandTree.getNamedNode(label = event.getCommandLabel().contains(":") ? event.getCommandLabel().split(Pattern.quote(":"))[1] : event.getCommandLabel());
        if (node == null) {
            return;
        }
        BrigadierPermissionChecker<Object> permissionChecker = (sender, permission) -> {
            if (commandTree.getNamedNode(label) == null) {
                return false;
            }
            return this.paperCommandManager.testPermission(sender, permission).allowed();
        };
        LiteralBrigadierNodeFactory<Object, BukkitBrigadierCommandSource> literalFactory = this.brigadierManager.literalBrigadierNodeFactory();
        event.setLiteral(literalFactory.createNode(event.getLiteral().getLiteral(), node, new CloudBrigadierCommand<C, BukkitBrigadierCommandSource>(this.paperCommandManager, this.brigadierManager, command -> BukkitHelper.stripNamespace(this.paperCommandManager, command)), permissionChecker));
    }
}

