/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.cloud.services;

import java.util.function.Predicate;
import me.m56738.easyarmorstands.lib.cloud.services.PipelineException;
import me.m56738.easyarmorstands.lib.cloud.services.ServiceRepository;
import me.m56738.easyarmorstands.lib.cloud.services.type.Service;
import me.m56738.easyarmorstands.lib.geantyref.TypeToken;
import org.checkerframework.checker.nullness.qual.NonNull;

enum ServiceFilterHandler {
    INSTANCE;


    <Context> boolean passes(@NonNull ServiceRepository.ServiceWrapper<? extends Service<Context, ?>> service, @NonNull Context context) {
        if (!service.isDefaultImplementation()) {
            for (Predicate predicate : service.filters()) {
                try {
                    if (predicate.test(context)) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new PipelineException(String.format("Failed to evaluate filter '%s' for '%s'", TypeToken.get(predicate.getClass()).getType().getTypeName(), service), e);
                }
            }
        }
        return true;
    }
}

