/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.particle;

import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.particle.LineParticle;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.lib.gizmo.api.LineGizmo;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.particle.GizmoAdapter;
import me.m56738.easyarmorstands.particle.GizmoParticle;
import org.jetbrains.annotations.NotNull;

public class GizmoLineParticle
extends GizmoParticle
implements LineParticle {
    private final LineGizmo gizmo;
    private double offset = 0.0;
    private Axis axis = Axis.Y;
    private ParticleColor color = ParticleColor.WHITE;

    public GizmoLineParticle(LineGizmo gizmo) {
        super(gizmo);
        this.gizmo = gizmo;
    }

    @Override
    @NotNull
    public Vector3dc getCenter() {
        return this.gizmo.getPosition();
    }

    @Override
    public void setCenter(@NotNull Vector3dc center) {
        this.gizmo.setPosition(center);
    }

    @Override
    @NotNull
    public Axis getAxis() {
        return this.axis;
    }

    @Override
    public void setAxis(@NotNull Axis axis) {
        this.axis = axis;
        this.gizmo.setAxis(GizmoAdapter.convert(axis));
    }

    @Override
    public double getWidth() {
        return this.gizmo.getWidth();
    }

    @Override
    public void setWidth(double width) {
        this.gizmo.setWidth(width);
    }

    @Override
    @NotNull
    public Quaterniondc getRotation() {
        return this.gizmo.getRotation();
    }

    @Override
    public void setRotation(@NotNull Quaterniondc rotation) {
        this.gizmo.setRotation(rotation);
    }

    @Override
    public double getLength() {
        return this.gizmo.getLength();
    }

    @Override
    public void setLength(double length) {
        this.gizmo.setLength(length);
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(double offset) {
        this.offset = offset;
    }

    @Override
    @NotNull
    public ParticleColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(@NotNull ParticleColor color) {
        this.color = color;
        this.gizmo.setColor(GizmoAdapter.convert(color));
    }

    @Override
    public void showGizmo() {
        this.updateOffset();
        super.showGizmo();
    }

    @Override
    public void updateGizmo() {
        this.updateOffset();
        super.updateGizmo();
    }

    private void updateOffset() {
        this.gizmo.setOffset(this.getAxis().getDirection().mul(this.offset - this.getLength() / 2.0, new Vector3d()).rotate(this.getRotation()));
    }
}

