/*
 * Decompiled with CFR 0.152.
 */
package me.wyzebb.enemyGravePreview.events;

import de.jeff_media.angelchest.AngelChest;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import me.wyzebb.enemyGravePreview.EnemyGravePreview;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class OpenChestEvent
implements Listener {
    final File angelChestCfgFile = new File(Bukkit.getPluginManager().getPlugin("AngelChest").getDataFolder(), "config.yml");
    final FileConfiguration config = YamlConfiguration.loadConfiguration((File)this.angelChestCfgFile);

    @EventHandler
    public void onOpenChest(PlayerInteractEvent event) {
        Player chestOpener = event.getPlayer();
        if (event.getClickedBlock() == null) {
            return;
        }
        String mat = this.config.getString("material");
        mat = Objects.equals(mat, "head:player") ? "PLAYER_HEAD" : mat.toUpperCase();
        if (event.getClickedBlock().getType() != Material.valueOf((String)mat)) {
            return;
        }
        AngelChest chest = EnemyGravePreview.plugin.angelChestPlugin.getAngelChestAtBlock(event.getClickedBlock());
        if (chest == null) {
            return;
        }
        OfflinePlayer chestOwner = chest.getPlayer();
        if (chest.isProtected() && !Objects.equals(chestOwner.getName(), chestOpener.getName())) {
            String invName = chestOwner.getName() + "'s Grave";
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            itemStacks.addAll(Arrays.asList(chest.getStorageInv()));
            Inventory inv = Bukkit.createInventory((InventoryHolder)chestOpener, (int)45, (String)invName);
            for (ItemStack itemStack : itemStacks) {
                if (itemStack == null) continue;
                inv.addItem(new ItemStack[]{itemStack});
            }
            for (int i = 1; i <= Arrays.asList(chest.getArmorInv()).toArray().length; ++i) {
                inv.setItem(40 - i, Arrays.asList(chest.getArmorInv()).get(i - 1));
            }
            inv.setItem(44, chest.getOffhandItem());
            chestOpener.openInventory(inv);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().contains("'s Grave")) {
            return;
        }
        event.setCancelled(true);
    }
}

