/*
 * Decompiled with CFR 0.152.
 */
package com.xm666.rehurttime.handler;

import com.xm666.rehurttime.Config;
import com.xm666.rehurttime.ReHurtTime;
import com.xm666.rehurttime.util.Util;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingAttackEvent;

public class LogHandler {

    private static class LogHandlerConfig {
        private LogHandlerConfig() {
        }

        @SubscribeEvent
        static void onConfigLoading(ModConfigEvent.Loading event) {
            LogHandlerConfig.toggle();
        }

        @SubscribeEvent
        static void onConfigReloading(ModConfigEvent.Reloading event) {
            LogHandlerConfig.toggle();
        }

        static void toggle() {
            if (((Boolean)Config.LOG_ENABLED.get()).booleanValue()) {
                NeoForge.EVENT_BUS.register(LogHandlerClient.class);
            } else {
                NeoForge.EVENT_BUS.unregister(LogHandlerClient.class);
            }
        }
    }

    @EventBusSubscriber
    private static class LogHandlerClient {
        private LogHandlerClient() {
        }

        @SubscribeEvent
        static void onLivingIncomingDamage(LivingAttackEvent event) {
            if (!((Boolean)Config.LOG_ENABLED.get()).booleanValue()) {
                return;
            }
            Object result = Util.execute((String)Config.LOG_FUNCTION.get(), event.getEntity(), event.getSource());
            ReHurtTime.LOGGER.info(result.toString());
        }
    }
}

