/*
 * Decompiled with CFR 0.152.
 */
package com.xm666.rehurttime.util;

import com.xm666.rehurttime.util.PredicateUtil;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class Util {
    public static String getEntityType(Entity entity) {
        if (entity != null) {
            return BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString();
        }
        return "";
    }

    public static Set<String> getEntityTags(Entity entity) {
        if (entity != null) {
            return entity.getTags();
        }
        return Set.of();
    }

    public static String getItemType(ItemStack stack) {
        if (stack != null) {
            return BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        }
        return "";
    }

    public static Set<String> getItemTags(ItemStack stack) {
        if (stack != null) {
            return stack.getTags().map(TagKey::location).map(ResourceLocation::toString).collect(Collectors.toSet());
        }
        return Set.of();
    }

    public static String getHolderType(Holder<?> holder) {
        ResourceKey key;
        if (holder != null && (key = (ResourceKey)holder.unwrapKey().get()) != null) {
            return key.location().toString();
        }
        return "";
    }

    public static Set<String> getHolderTags(Holder<?> holder) {
        if (holder != null) {
            return holder.tags().map(TagKey::location).map(ResourceLocation::toString).collect(Collectors.toSet());
        }
        return Set.of();
    }

    public static String getSourceType(DamageSource source) {
        if (source != null) {
            return Util.getHolderType(source.typeHolder());
        }
        return "";
    }

    public static Set<String> getSourceTags(DamageSource source) {
        if (source != null) {
            return Util.getHolderTags(source.typeHolder());
        }
        return Set.of();
    }

    public static Object execute(String expression, LivingEntity entity, DamageSource source) {
        return PredicateUtil.execute(expression, "entity", entity, "source", source);
    }

    public static boolean test(String expression, LivingEntity entity, DamageSource source) {
        return (Boolean)Util.execute(expression, entity, source);
    }
}

