/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.kreidev.cbmnfieldlab.PokemonFieldLab;
import com.kreidev.cbmnfieldlab.data.fabric.ConditionDataLoaderImpl;
import com.kreidev.cbmnfieldlab.quest.ConditionManager;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class ConditionDataLoader
extends class_4309 {
    public static final Codec<Map<class_2960, Float>> CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)Codec.FLOAT);
    private static final Gson GSON = new Gson();
    public static final ConditionDataLoader INSTANCE = new ConditionDataLoader();

    public ConditionDataLoader() {
        super(GSON, "quest_condition");
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profilerFiller) {
        ConditionManager.clearAll();
        object.forEach((id, json) -> {
            try {
                if (id.equals((Object)PokemonFieldLab.resLoc("biome_quest", new Object[0]))) {
                    Map conditions = (Map)CODEC.parse((DynamicOps)JsonOps.INSTANCE, json).getOrThrow();
                    ConditionManager.addBiomeConditions(conditions);
                    PokemonFieldLab.LOGGER.info("Loaded biome quest conditions");
                }
            }
            catch (Exception e) {
                PokemonFieldLab.LOGGER.error("Failed to load biome quest conditions: " + String.valueOf(id));
                throw new RuntimeException("Failed to load biome quest conditions: " + String.valueOf(id), e);
            }
        });
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ConditionDataLoader getInstance() {
        return ConditionDataLoaderImpl.getInstance();
    }
}

