/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.gui;

import com.cobblemon.mod.common.api.storage.party.PartyPosition;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.gui.summary.widgets.SoundlessWidget;
import com.cobblemon.mod.common.client.storage.ClientParty;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.kreidev.cbmnfieldlab.gui.FieldLabMenu;
import com.kreidev.cbmnfieldlab.gui.FieldLabScreen;
import com.kreidev.cbmnfieldlab.gui.PartyPanelSlot;
import com.kreidev.cbmnfieldlab.gui.SubmitButton;
import com.kreidev.cbmnfieldlab.gui.SubmitConfirmButton;
import com.kreidev.cbmnfieldlab.network.SubmitPacket;
import com.kreidev.cbmnfieldlab.quest.PlayerQuestContainer;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_8710;

public class PartyPanelWidget
extends SoundlessWidget {
    public static final class_2960 PARTY_PANEL_RES = MiscUtilsKt.cobblemonResource((String)"textures/gui/pc/party_panel.png");
    public final List<PartyPanelSlot> partySlots = new ArrayList<PartyPanelSlot>();
    public final FieldLabScreen parent;
    public final ClientParty party;
    public final SubmitButton submitButton;
    public final SubmitConfirmButton submitYesButton;
    public final SubmitConfirmButton submitNoButton;
    public boolean displayConfirmSubmit = false;

    public PartyPanelWidget(int pX, int pY, FieldLabScreen parent, ClientParty party) {
        super(pX, pY, 263, 155, (class_2561)class_2561.method_43470((String)"PartyPanelOverlay"));
        this.parent = parent;
        this.party = party;
        this.setupPartySlot();
        this.submitButton = new SubmitButton(this.method_46426() + 194, this.method_46427() + 124, ignore -> {});
        this.addWidget((class_364)this.submitButton);
        this.submitYesButton = new SubmitConfirmButton(this.method_46426() + 190, this.method_46427() + 131, LocalizationUtilsKt.lang((String)"ui.generic.yes", (Object[])new Object[0]), ignore -> {});
        this.addWidget((class_364)this.submitYesButton);
        this.submitNoButton = new SubmitConfirmButton(this.method_46426() + 226, this.method_46427() + 131, LocalizationUtilsKt.lang((String)"ui.generic.no", (Object[])new Object[0]), ignore -> {});
        this.addWidget((class_364)this.submitNoButton);
    }

    private void setupPartySlot() {
        for (int partyIndex = 0; partyIndex < 6; ++partyIndex) {
            int partyX = this.method_46426() + 193;
            int partyY = this.method_46427() + 8;
            if (partyIndex > 0) {
                boolean isEven = partyIndex % 2 == 0;
                int offsetIndex = (partyIndex - (isEven ? 0 : 1)) / 2;
                int offsetX = isEven ? 0 : 31;
                int offsetY = isEven ? 0 : 8;
                partyX += offsetX;
                partyY += 31 * offsetIndex + offsetY;
            }
            PartyPanelSlot slot = new PartyPanelSlot(partyX, partyY, this, this.party, new PartyPosition(partyIndex), this::onSlotClicked);
            this.addWidget((class_364)slot);
            this.partySlots.add(slot);
        }
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        class_4587 matrices = guiGraphics.method_51448();
        FieldLabScreen.GuiUtilsKtExt.blitk(matrices, PARTY_PANEL_RES, this.method_46426() + 182, this.method_46427() - 19, 169, 82);
        FieldLabScreen.RenderHelperKtExt.drawScaledText(guiGraphics, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), TextKt.bold((class_5250)LocalizationUtilsKt.lang((String)"ui.party", (Object[])new Object[0])), this.method_46426() + 213, (double)this.method_46427() - 15.5, true, true);
        for (PartyPanelSlot slot : this.partySlots) {
            slot.method_25394(guiGraphics, mouseX, mouseY, delta);
        }
        PlayerQuestContainer container = ((FieldLabMenu)this.parent.method_17577()).questContainer;
        if (this.parent.previewPokemon != null && container.hasEligible(this.parent.previewPokemon)) {
            if (this.displayConfirmSubmit) {
                FieldLabScreen.RenderHelperKtExt.drawScaledText(guiGraphics, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), TextKt.bold((class_5250)class_2561.method_43471((String)"cbmnfieldlab.ui.field_lab.submit")), this.method_46426() + 223, this.method_46427() + 119, true, false);
                this.submitYesButton.method_25394(guiGraphics, mouseX, mouseY, delta);
                this.submitNoButton.method_25394(guiGraphics, mouseX, mouseY, delta);
            } else {
                this.submitButton.method_25394(guiGraphics, mouseX, mouseY, delta);
            }
        }
    }

    public void onSlotClicked(class_4185 button) {
        if (!(button instanceof PartyPanelSlot)) {
            return;
        }
        PartyPanelSlot slot = (PartyPanelSlot)button;
        Pokemon pokemon = slot.getPokemon();
        if (pokemon == this.parent.previewPokemon) {
            pokemon = null;
        }
        this.parent.setPreviewPokemon(pokemon);
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.displayConfirmSubmit) {
            if (this.submitYesButton.method_49606()) {
                this.onSubmit();
            }
            if (this.submitNoButton.method_49606()) {
                this.displayConfirmSubmit = false;
            }
        } else if (this.submitButton.method_49606()) {
            this.displayConfirmSubmit = true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    public void onSubmit() {
        this.displayConfirmSubmit = false;
        if (this.parent.previewPokemon == null) {
            return;
        }
        PartyPosition partyPosition = this.party.getPosition(this.parent.previewPokemon);
        if (partyPosition == null) {
            return;
        }
        NetworkManager.sendToServer((class_8710)new SubmitPacket(partyPosition.getSlot()));
    }
}

