/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest.type;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.quest.Quest;
import com.kreidev.cbmnfieldlab.quest.QuestType;
import com.kreidev.cbmnfieldlab.quest.QuestTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class SizeQuest
extends Quest {
    public static final MapCodec<SizeQuest> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("timestamp").forGetter(Quest::getTimeStamp), (App)class_1799.field_24671.fieldOf("reward").forGetter(Quest::getReward), (App)Codec.FLOAT.fieldOf("quest_size").forGetter(SizeQuest::getSize)).apply((Applicative)instance, SizeQuest::new));
    public final float size;

    public SizeQuest(class_3218 level) {
        super(level, CommonConfig.sizeQuestDifficulty);
        float lowerBound = CommonConfig.sizeQuestLowerBound;
        float upperBound = CommonConfig.sizeQuestUpperBound;
        this.size = level.method_8409().method_43057() * (upperBound - lowerBound) + lowerBound;
    }

    public SizeQuest(class_3218 level, float size) {
        super(level);
        this.size = size;
    }

    public SizeQuest(long timestamp, class_1799 reward, float size) {
        super(timestamp, reward);
        this.size = size;
    }

    @Override
    public boolean isEligible(@NotNull Pokemon pokemon) {
        return pokemon.getForm().getHeight() < this.size;
    }

    @Override
    public String getModifierString() {
        return String.format("%.2f", Float.valueOf(this.size));
    }

    public float getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public QuestType<?> getType() {
        return QuestTypes.SIZE;
    }
}

