/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.kreidev.cbmnfieldlab.PokemonFieldLab;
import com.kreidev.cbmnfieldlab.data.fabric.RewardDataLoaderImpl;
import com.kreidev.cbmnfieldlab.quest.QuestRewardEntry;
import com.kreidev.cbmnfieldlab.quest.RewardManager;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class RewardDataLoader
extends class_4309 {
    public static final Codec<List<QuestRewardEntry>> LIST_CODEC = QuestRewardEntry.CODEC.codec().listOf();
    private static final Gson GSON = new Gson();
    public static final RewardDataLoader INSTANCE = new RewardDataLoader();

    public RewardDataLoader() {
        super(GSON, "quest_reward");
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profilerFiller) {
        RewardManager.clearAll();
        object.forEach((id, json) -> {
            try {
                if (id.equals((Object)PokemonFieldLab.resLoc("individual_quest_rewards", new Object[0]))) {
                    List rewards = (List)LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, json).getOrThrow();
                    RewardManager.addIndivRewards(rewards);
                    PokemonFieldLab.LOGGER.info("Loaded individual quest rewards");
                } else if (id.equals((Object)PokemonFieldLab.resLoc("minor_quest_rewards", new Object[0]))) {
                    List rewards = (List)LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, json).getOrThrow();
                    RewardManager.addMinorRewards(rewards);
                    PokemonFieldLab.LOGGER.info("Loaded minor quest rewards");
                } else if (id.equals((Object)PokemonFieldLab.resLoc("major_quest_rewards", new Object[0]))) {
                    List rewards = (List)LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, json).getOrThrow();
                    RewardManager.addMajorRewards(rewards);
                    PokemonFieldLab.LOGGER.info("Loaded major quest rewards");
                }
            }
            catch (Exception e) {
                PokemonFieldLab.LOGGER.error("Failed to load quest rewards: " + String.valueOf(id));
                throw new RuntimeException("Failed to load quest rewards: " + String.valueOf(id), e);
            }
        });
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RewardDataLoader getInstance() {
        return RewardDataLoaderImpl.getInstance();
    }
}

