/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.PokemonFieldLab;
import com.kreidev.cbmnfieldlab.network.RefreshScreenPacket;
import com.kreidev.cbmnfieldlab.quest.PlayerQuestContainer;
import com.kreidev.cbmnfieldlab.quest.Quest;
import com.kreidev.cbmnfieldlab.quest.RewardManager;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

public class QuestManager
extends class_18 {
    public static final Codec<Map<UUID, PlayerQuestContainer>> CODEC = Codec.unboundedMap((Codec)class_4844.field_41525, (Codec)PlayerQuestContainer.CODEC.codec());
    public static QuestManager INSTANCE;
    private final Map<UUID, PlayerQuestContainer> playerQuests;

    public QuestManager() {
        this.playerQuests = new HashMap<UUID, PlayerQuestContainer>();
    }

    public QuestManager(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545("PlayerCobblemonQuests")) {
            DataResult result = CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("PlayerCobblemonQuests"));
            this.playerQuests = new HashMap<UUID, PlayerQuestContainer>(result.resultOrPartial(error -> PokemonFieldLab.LOGGER.error("Quest data was not loaded \n" + error)).orElse(Collections.emptyMap()));
        } else {
            this.playerQuests = new HashMap<UUID, PlayerQuestContainer>();
        }
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 tag, @NotNull class_7225.class_7874 provider) {
        DataResult result = CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.getPlayerQuests());
        result.resultOrPartial(error -> PokemonFieldLab.LOGGER.error("Quest data was not saved \n" + error)).ifPresent(nbt -> tag.method_10566("PlayerCobblemonQuests", nbt));
        return tag;
    }

    public Map<UUID, PlayerQuestContainer> getPlayerQuests() {
        return this.playerQuests;
    }

    @NotNull
    public static PlayerQuestContainer getQuestContainer(class_3222 player) {
        PlayerQuestContainer container = INSTANCE.getPlayerQuests().get(player.method_5667());
        if (container == null) {
            container = new PlayerQuestContainer((class_3218)player.method_37908());
            INSTANCE.getPlayerQuests().put(player.method_5667(), container);
            INSTANCE.method_80();
        }
        return container;
    }

    public static boolean rerollQuest(class_3222 player, Quest quest) {
        PlayerQuestContainer container = QuestManager.getQuestContainer(player);
        int index = container.getQuestIndex(quest);
        if (index == -1) {
            return false;
        }
        return QuestManager.rerollQuest(player, index);
    }

    public static boolean rerollQuest(class_3222 player, int index) {
        PlayerQuestContainer container = QuestManager.getQuestContainer(player);
        Quest quest = container.getQuest(index);
        if (quest == null) {
            return false;
        }
        if (quest.getTimeStamp() + (long)CommonConfig.rerollTimeSeconds > player.method_37908().method_8510()) {
            return false;
        }
        boolean success = container.replaceQuest(index, Quest.getRandomQuest((class_3218)player.method_37908()));
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new RefreshScreenPacket(container));
        INSTANCE.method_80();
        return success;
    }

    public static boolean hasQuest(class_3222 player, Quest quest) {
        PlayerQuestContainer container = QuestManager.getQuestContainer(player);
        return container.hasQuest(quest);
    }

    public static boolean submitPokemon(@NotNull class_3222 player, @NotNull Pokemon pokemon) {
        PlayerQuestContainer container = QuestManager.getQuestContainer(player);
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        int preFinishedQuests = container.getFinishedQuests();
        int completedQuests = 0;
        List<Quest> quests = container.getQuests();
        for (int i = 0; i < quests.size(); ++i) {
            if (!quests.get(i).isEligible(pokemon)) continue;
            ++completedQuests;
            container.incrementFinishedQuests();
            stacks.add(quests.get(i).getReward());
            container.replaceQuest(i, Quest.getRandomQuest((class_3218)player.method_37908()));
        }
        if (preFinishedQuests % 3 + completedQuests >= 9) {
            for (class_1799 stack : container.getNextMajorRewards()) {
                player.method_31548().method_7398(stack);
                PokemonFieldLab.LOGGER.info(String.valueOf(stack));
            }
            container.replaceMajorRewards(RewardManager.getMajorRewards(player.method_37908().method_8409()));
        }
        if (preFinishedQuests % 3 + completedQuests >= 3) {
            for (class_1799 stack : container.getNextMinorRewards()) {
                player.method_31548().method_7398(stack);
                PokemonFieldLab.LOGGER.info(String.valueOf(stack));
            }
            container.replaceMinorRewards(RewardManager.getMinorRewards(player.method_37908().method_8409()));
        }
        boolean submitted = false;
        if (completedQuests > 0) {
            PlayerExtensionsKt.party((class_3222)player).remove(pokemon);
            for (class_1799 stack : stacks) {
                player.method_31548().method_7398(stack);
            }
            INSTANCE.method_80();
            submitted = true;
        }
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new RefreshScreenPacket(container));
        return submitted;
    }
}

