/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest.type;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.quest.Quest;
import com.kreidev.cbmnfieldlab.quest.QuestType;
import com.kreidev.cbmnfieldlab.quest.QuestTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class EvoQuest
extends Quest {
    public static final MapCodec<EvoQuest> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("timestamp").forGetter(Quest::getTimeStamp), (App)class_1799.field_24671.fieldOf("reward").forGetter(Quest::getReward), (App)Codec.INT.fieldOf("evolution_stage").forGetter(EvoQuest::getStage)).apply((Applicative)instance, EvoQuest::new));
    public final int stage;

    public EvoQuest(class_3218 level) {
        super(level);
        this.stage = level.method_8409().method_43051(1, 2);
    }

    public EvoQuest(class_3218 level, int stage) {
        super(level, CommonConfig.evoQuestDifficulty);
        this.stage = stage;
    }

    public EvoQuest(long timestamp, class_1799 reward, int stage) {
        super(timestamp, reward);
        this.stage = stage;
    }

    @Override
    public boolean isEligible(@NotNull Pokemon pokemon) {
        return EvoQuest.getEvoStage(pokemon.getSpecies()) >= this.stage;
    }

    @Override
    public String getModifierString() {
        return EvoQuest.toBasicOrdinal(this.stage + 1);
    }

    public int getStage() {
        return this.stage;
    }

    @Override
    @NotNull
    public QuestType<?> getType() {
        return QuestTypes.EVO_STAGE;
    }

    public static int getEvoStage(Species species) {
        return EvoQuest.getEvoStage(species, 0);
    }

    private static int getEvoStage(Species species, int stage) {
        if (species.getPreEvolution() == null) {
            return stage;
        }
        return EvoQuest.getEvoStage(species.getPreEvolution().getSpecies(), stage + 1);
    }

    public static String toBasicOrdinal(int number) {
        if (number >= 11 && number <= 13) {
            return number + "th";
        }
        return switch (number % 10) {
            case 1 -> number + "st";
            case 2 -> number + "nd";
            case 3 -> number + "rd";
            default -> number + "th";
        };
    }
}

