/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab;

import com.kreidev.cbmnfieldlab.FieldLabBlock;
import com.kreidev.cbmnfieldlab.FieldLabBlockEntity;
import com.kreidev.cbmnfieldlab.gui.FieldLabMenu;
import com.kreidev.cbmnfieldlab.network.FieldLabNetworkManager;
import com.kreidev.cbmnfieldlab.quest.QuestManager;
import com.kreidev.cbmnfieldlab.quest.QuestTypes;
import com.mojang.logging.LogUtils;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class PokemonFieldLab {
    public static final String MOD_ID = "cbmnfieldlab";
    public static final String FIELD_LAB_NAME = "pokemon_field_lab";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"cbmnfieldlab", (ResourceKey)Registries.BLOCK);
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((String)"cbmnfieldlab", (ResourceKey)Registries.BLOCK_ENTITY_TYPE);
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"cbmnfieldlab", (ResourceKey)Registries.ITEM);
    private static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((String)"cbmnfieldlab", (ResourceKey)Registries.MENU);
    public static final RegistrySupplier<FieldLabBlock> FIELD_LAB_BLOCK = BLOCKS.register("pokemon_field_lab", () -> new FieldLabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).pushReaction(PushReaction.BLOCK).strength(2.0f).noOcclusion().lightLevel(state -> (Boolean)state.getValue((Property)FieldLabBlock.OPEN) != false && state.getValue(FieldLabBlock.HALF) == DoubleBlockHalf.UPPER ? 10 : 0)));
    public static final RegistrySupplier<BlockEntityType<FieldLabBlockEntity>> FIELD_LAB_BLOCK_ENTITY = BLOCK_ENTITIES.register("pokemon_field_lab", () -> BlockEntityType.Builder.of(FieldLabBlockEntity::new, (Block[])new Block[]{(Block)FIELD_LAB_BLOCK.get()}).build(null));
    public static final RegistrySupplier<BlockItem> FIELD_LAB_BLOCK_ITEM = ITEMS.register("pokemon_field_lab", () -> new BlockItem((Block)FIELD_LAB_BLOCK.get(), new Item.Properties()));
    public static final RegistrySupplier<MenuType<FieldLabMenu>> FIELD_LAB_MENU = MENUS.register("pokemon_field_lab", () -> MenuRegistry.ofExtended(FieldLabMenu::new));

    public static void init() {
        BLOCKS.register();
        BLOCK_ENTITIES.register();
        ITEMS.register();
        MENUS.register();
        PokemonFieldLab.registerToCreativeTab();
        LifecycleEvent.SERVER_STARTING.register(PokemonFieldLab::onServerStarting);
        PlayerEvent.DROP_ITEM.register((player, itemEntity) -> EventResult.pass());
        QuestTypes.init();
        FieldLabNetworkManager.registerPackets();
    }

    public static void initClient() {
    }

    public static void onServerStarting(MinecraftServer instance) {
        ServerLevel level = instance.getLevel(Level.OVERWORLD);
        if (level != null && !level.isClientSide()) {
            QuestManager.INSTANCE = (QuestManager)level.getDataStorage().computeIfAbsent(new SavedData.Factory(QuestManager::new, QuestManager::new, null), "cobblemon_field_lab_data");
        }
    }

    private static void registerToCreativeTab() {
    }

    public static ResourceLocation resLoc(String path, Object ... args) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)String.format(path, args));
    }
}

