/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.gui;

import com.kreidev.cbmnfieldlab.PokemonFieldLab;
import com.kreidev.cbmnfieldlab.quest.PlayerQuestContainer;
import com.kreidev.cbmnfieldlab.quest.QuestManager;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class FieldLabMenu
extends AbstractContainerMenu {
    public PlayerQuestContainer questContainer;
    private final ContainerLevelAccess access;

    public FieldLabMenu(int id, Inventory inventory, FriendlyByteBuf extraData) {
        super((MenuType)PokemonFieldLab.FIELD_LAB_MENU.get(), id);
        BlockPos blockPos = extraData.readBlockPos();
        CompoundTag tag = extraData.readNbt();
        if (tag == null) {
            throw new NbtException("NBT null for some reason");
        }
        this.access = ContainerLevelAccess.create((Level)inventory.player.level(), (BlockPos)blockPos);
        this.questContainer = PlayerQuestContainer.CODEC.codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("quest_container")).resultOrPartial(error -> PokemonFieldLab.LOGGER.error("Quest data was not loaded \n" + error)).orElse(null);
        if (this.questContainer == null) {
            throw new NbtException("");
        }
    }

    public FieldLabMenu(int id, Inventory inventory, BlockPos blockPos, ServerPlayer player) {
        super((MenuType)PokemonFieldLab.FIELD_LAB_MENU.get(), id);
        this.access = ContainerLevelAccess.create((Level)inventory.player.level(), (BlockPos)blockPos);
        this.questContainer = QuestManager.getQuestContainer(player);
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int i) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return FieldLabMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)PokemonFieldLab.FIELD_LAB_BLOCK.get()));
    }

    public void updateQuestContainer(PlayerQuestContainer container) {
        this.questContainer = container;
    }
}

