/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.gui;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.gui.ExitButton;
import com.cobblemon.mod.common.client.gui.TypeIcon;
import com.cobblemon.mod.common.client.gui.summary.Summary;
import com.cobblemon.mod.common.client.gui.summary.widgets.ModelWidget;
import com.cobblemon.mod.common.client.gui.summary.widgets.common.NatureInfoUtilsKt;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.client.storage.ClientParty;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.status.PersistentStatus;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.kreidev.cbmnfieldlab.gui.FieldLabMenu;
import com.kreidev.cbmnfieldlab.gui.PartyPanelWidget;
import com.kreidev.cbmnfieldlab.gui.QuestPanelWidget;
import com.kreidev.cbmnfieldlab.quest.PlayerQuestContainer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FieldLabScreen
extends AbstractContainerScreen<FieldLabMenu> {
    public static final ResourceLocation BASE_RES = MiscUtilsKt.cobblemonResource((String)"textures/gui/pc/pc_base.png");
    public static final ResourceLocation PORTRAIT_BACKGROUND_RES = MiscUtilsKt.cobblemonResource((String)"textures/gui/pc/portrait_background.png");
    public static final ResourceLocation TOP_SPACER_RES = MiscUtilsKt.cobblemonResource((String)"textures/gui/pc/pc_spacer_top.png");
    public static final ResourceLocation BOTTOM_SPACER_RES = MiscUtilsKt.cobblemonResource((String)"textures/gui/pc/pc_spacer_bottom.png");
    public static final ResourceLocation RIGHT_SPACER_RES = MiscUtilsKt.cobblemonResource((String)"textures/gui/pc/pc_spacer_right.png");
    public static final ResourceLocation TYPE_SPACER_RES = MiscUtilsKt.cobblemonResource((String)"textures/gui/pc/type_spacer.png");
    public static final ResourceLocation TYPE_SPACER_SINGLE_RES = MiscUtilsKt.cobblemonResource((String)"textures/gui/pc/type_spacer_single.png");
    public static final ResourceLocation TYPE_SPACER_DOUBLE_RES = MiscUtilsKt.cobblemonResource((String)"textures/gui/pc/type_spacer_double.png");
    public static final int TICKS_TO_LOAD = 10;
    @Nullable
    public QuestPanelWidget questPanelWidget;
    @Nullable
    public PartyPanelWidget partyPanelWidget;
    @Nullable
    public ModelWidget modelWidget = null;
    @Nullable
    public Pokemon previewPokemon = null;
    public ClientParty party = CobblemonClient.INSTANCE.getStorage().getMyParty();
    public int ticksElapsed = 0;
    public int selectPointerOffsetY = 0;
    public boolean selectPointerOffsetIncrement = false;

    public FieldLabScreen(FieldLabMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, (Component)Component.empty());
    }

    protected void init() {
        int x = (this.width - 349) / 2;
        int y = (this.height - 205) / 2;
        this.addRenderableWidget((GuiEventListener)new ExitButton(x + 320, y + 186, button -> this.closeNormally()));
        this.partyPanelWidget = new PartyPanelWidget(x + 85, y + 27, this, this.party);
        this.addRenderableWidget((GuiEventListener)this.partyPanelWidget);
        this.questPanelWidget = new QuestPanelWidget(x + 85, y + 10, this, this.party);
        this.addRenderableWidget((GuiEventListener)this.questPanelWidget);
        this.setPreviewPokemon(null);
        super.init();
    }

    protected void renderBg(GuiGraphics guiGraphics, float i, int j, int k) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        PoseStack matrices = guiGraphics.pose();
        int x = (this.width - 349) / 2;
        int y = (this.height - 205) / 2;
        GuiUtilsKt.blitk((PoseStack)matrices, (ResourceLocation)PORTRAIT_BACKGROUND_RES, (Number)(x + 6), (Number)(y + 27), (Number)66, (Number)66);
        if (this.modelWidget != null) {
            this.modelWidget.render(guiGraphics, mouseX, mouseY, delta);
        }
        GuiUtilsKt.blitk((PoseStack)matrices, (ResourceLocation)BASE_RES, (Number)x, (Number)y, (Number)205, (Number)349);
        RenderHelperKtExt.drawScaledText(guiGraphics, null, TextKt.bold((MutableComponent)LocalizationUtilsKt.lang((String)"ui.info.nature", (Object[])new Object[0])), x + 39, (double)y + 129.5, true, false, 0.5f);
        RenderHelperKtExt.drawScaledText(guiGraphics, null, TextKt.bold((MutableComponent)LocalizationUtilsKt.lang((String)"ui.info.ability", (Object[])new Object[0])), x + 39, (double)y + 146.5, true, false, 0.5f);
        RenderHelperKtExt.drawScaledText(guiGraphics, null, TextKt.bold((MutableComponent)LocalizationUtilsKt.lang((String)"ui.moves", (Object[])new Object[0])), x + 39, (double)y + 163.5, true, false, 0.5f);
        Pokemon pokemon = this.previewPokemon;
        if (pokemon != null) {
            PersistentStatus status;
            PersistentStatus persistentStatus = status = pokemon.getStatus() != null ? pokemon.getStatus().getStatus() : null;
            if (pokemon.isFainted() || status != null) {
                String statusName = pokemon.isFainted() ? "fnt" : status.getShowdownName();
                GuiUtilsKt.blitk((PoseStack)matrices, (ResourceLocation)MiscUtilsKt.cobblemonResource((String)String.format("textures/gui/battle/battle_status_%s.png", statusName)), (Number)(x + 34), (Number)(y + 1), (Number)7, (Number)39, (Number)35, (Number)0, (Number)74);
                GuiUtilsKt.blitk((PoseStack)matrices, (ResourceLocation)MiscUtilsKt.cobblemonResource((String)"textures/gui/summary/status_trim.png"), (Number)(x + 34), (Number)(y + 2), (Number)6, (Number)3);
                RenderHelperKt.drawScaledText((GuiGraphics)guiGraphics, (ResourceLocation)CobblemonResources.INSTANCE.getDEFAULT_LARGE(), (MutableComponent)TextKt.bold((MutableComponent)LocalizationUtilsKt.lang((String)String.format("ui.status.%s", statusName), (Object[])new Object[0])), (Number)(x + 39), (Number)y, (float)1.0f, (Number)Float.valueOf(1.0f), (int)Integer.MAX_VALUE, (int)-1, (boolean)false, (boolean)false, null, null);
            }
            RenderHelperKtExt.drawScaledText(guiGraphics, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), TextKt.bold((MutableComponent)LocalizationUtilsKt.lang((String)"ui.lv", (Object[])new Object[0])), x + 6, (double)y + 1.5, true);
            RenderHelperKtExt.drawScaledText(guiGraphics, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), TextKt.bold((MutableComponent)TextKt.text((Object[])new Object[]{pokemon.getLevel()})), x + 19, (double)y + 1.5, true);
            ResourceLocation ballResource = MiscUtilsKt.cobblemonResource((String)String.format("textures/item/poke_balls/%s.png", pokemon.getCaughtBall().getName().getPath()));
            GuiUtilsKtExt.blitk(matrices, ballResource, ((double)x + 3.5) / 0.5, Float.valueOf((float)(y + 12) / 0.5f), 16, 16, 0.5f);
            RenderHelperKtExt.drawScaledText(guiGraphics, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), TextKt.bold((MutableComponent)pokemon.getDisplayName()), x + 12, (double)y + 11.5, true);
            if (pokemon.getGender() != Gender.GENDERLESS) {
                boolean isMale = pokemon.getGender() == Gender.MALE;
                MutableComponent textSymbol = TextKt.bold((MutableComponent)TextKt.text((String)(isMale ? "\u2642" : "\u2640")));
                RenderHelperKt.drawScaledText((GuiGraphics)guiGraphics, (ResourceLocation)CobblemonResources.INSTANCE.getDEFAULT_LARGE(), (MutableComponent)textSymbol, (Number)(x + 69), (Number)((double)y + 11.5), (float)1.0f, (Number)Float.valueOf(1.0f), (int)Integer.MAX_VALUE, (int)(isMale ? 3329023 : 16536660), (boolean)false, (boolean)true, null, null);
            }
            ItemStack heldItem = pokemon.heldItemNoCopy$common();
            int itemX = x + 3;
            int itemY = y + 98;
            if (!heldItem.isEmpty()) {
                guiGraphics.renderItem(heldItem, itemX, itemY);
                guiGraphics.renderItemDecorations(Minecraft.getInstance().font, heldItem, itemX, itemY);
            }
            RenderHelperKtExt.drawScaledText(guiGraphics, null, LocalizationUtilsKt.lang((String)"held_item", (Object[])new Object[0]), x + 27, (double)y + 108.5, false, false, 0.5f);
            if (pokemon.getShiny()) {
                GuiUtilsKtExt.blitk(matrices, Summary.Companion.getIconShinyResource(), ((double)x + 62.5) / 0.5, ((double)y + 28.5) / 0.5, 16, 16, 0.5f);
            }
            GuiUtilsKtExt.blitk(matrices, pokemon.getSecondaryType() != null ? TYPE_SPACER_DOUBLE_RES : TYPE_SPACER_SINGLE_RES, Float.valueOf((float)(x + 7) / 0.5f), ((double)y + 118.5) / 0.5, 12, 128, 0.5f);
            new TypeIcon((Number)(x + 39), (Number)(y + 117), pokemon.getPrimaryType(), pokemon.getSecondaryType(), true, true, 10.0f, 5.0f, 1.0f).render(guiGraphics);
            MutableComponent natureText = NatureInfoUtilsKt.reformatNatureTextIfMinted((Pokemon)pokemon);
            RenderHelperKt.drawScaledText((GuiGraphics)guiGraphics, null, (MutableComponent)natureText, (Number)(x + 39), (Number)(y + 137), (float)0.5f, (Number)Float.valueOf(1.0f), (int)Integer.MAX_VALUE, (int)-1, (boolean)true, (boolean)true, (Integer)mouseX, (Integer)mouseY);
            RenderHelperKtExt.drawScaledText(guiGraphics, null, MiscUtilsKt.asTranslated((String)pokemon.getAbility().getDisplayName()), x + 39, y + 154, true, true, 0.5f);
            List moves = pokemon.getMoveSet().getMoves();
            for (int i = 0; i < moves.size(); ++i) {
                RenderHelperKtExt.drawScaledText(guiGraphics, null, ((Move)moves.get(i)).getDisplayName(), x + 39, (double)y + 170.5 + (double)(7 * i), true, true, 0.5f);
            }
        } else {
            GuiUtilsKtExt.blitk(matrices, TYPE_SPACER_RES, Float.valueOf((float)(x + 7) / 0.5f), ((double)y + 118.5) / 0.5, 12, 128, 0.5f);
        }
        RenderHelperKtExt.drawScaledText(guiGraphics, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), TextKt.bold((MutableComponent)Component.translatable((String)"cbmnfieldlab.ui.field_lab.title")), x + 172, y + 15, true, false);
        GuiUtilsKtExt.blitk(matrices, TOP_SPACER_RES, ((double)x + 86.5) / 0.5, Float.valueOf((float)(y + 13) / 0.5f), 14, 342, 0.5f);
        GuiUtilsKtExt.blitk(matrices, BOTTOM_SPACER_RES, ((double)x + 86.5) / 0.5, Float.valueOf((float)(y + 189) / 0.5f), 14, 342, 0.5f);
        GuiUtilsKtExt.blitk(matrices, RIGHT_SPACER_RES, ((double)x + 275.5) / 0.5, Float.valueOf((float)(y + 184) / 0.5f), 24, 64, 0.5f);
        super.render(guiGraphics, mouseX, mouseY, delta);
        if (pokemon != null && !pokemon.heldItemNoCopy$common().isEmpty()) {
            int itemX = x + 3;
            int itemY = y + 98;
            if (mouseX >= itemX && mouseX <= itemX + 16 && mouseY >= itemY && mouseY <= itemY + 16) {
                guiGraphics.renderTooltip(Minecraft.getInstance().font, pokemon.getHeldItem$common(), mouseX, mouseY);
            }
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    protected void containerTick() {
        ++this.ticksElapsed;
        int delayFactor = 3;
        if (this.ticksElapsed % (2 * delayFactor) == 0) {
            boolean bl = this.selectPointerOffsetIncrement = !this.selectPointerOffsetIncrement;
        }
        if (this.ticksElapsed % delayFactor == 0) {
            this.selectPointerOffsetY += this.selectPointerOffsetIncrement ? 1 : -1;
        }
    }

    public void setPreviewPokemon(@Nullable Pokemon pokemon) {
        if (pokemon != null) {
            this.previewPokemon = pokemon;
            int x = (this.width - 349) / 2;
            int y = (this.height - 205) / 2;
            this.modelWidget = new ModelWidget(x + 6, y + 27, 66, 66, pokemon.asRenderablePokemon(), 2.0f, 325.0f, -10.0, false);
        } else {
            this.previewPokemon = null;
            this.modelWidget = null;
        }
    }

    public void playSound(SoundEvent soundEvent) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)soundEvent, (float)1.0f));
    }

    public void closeNormally() {
        this.playSound(CobblemonSounds.PC_OFF);
        Minecraft.getInstance().setScreen(null);
    }

    public void onClose() {
        this.playSound(CobblemonSounds.PC_OFF);
        super.onClose();
    }

    public long getGameTime() {
        if (this.minecraft == null || this.minecraft.level == null) {
            return -1L;
        }
        return this.minecraft.level.getGameTime();
    }

    public void updateQuests(PlayerQuestContainer container) {
        ((FieldLabMenu)this.getMenu()).updateQuestContainer(container);
        if (this.questPanelWidget != null) {
            this.questPanelWidget.updateQuestContainer(container);
        }
        this.setPreviewPokemon(null);
    }

    static class RenderHelperKtExt {
        RenderHelperKtExt() {
        }

        static void drawScaledText(GuiGraphics context, ResourceLocation font, MutableComponent text, Number x, Number y, boolean shadow) {
            RenderHelperKtExt.drawScaledText(context, font, text, x, y, false, shadow);
        }

        static void drawScaledText(GuiGraphics context, ResourceLocation font, MutableComponent text, Number x, Number y, boolean centered, boolean shadow) {
            RenderHelperKtExt.drawScaledText(context, font, text, x, y, centered, shadow, 1.0f);
        }

        static void drawScaledText(GuiGraphics context, ResourceLocation font, MutableComponent text, Number x, Number y, boolean centered, boolean shadow, float scale) {
            RenderHelperKtExt.drawScaledText(context, font, text, x, y, centered, shadow, scale, 1.0f);
        }

        static void drawScaledText(GuiGraphics context, ResourceLocation font, MutableComponent text, Number x, Number y, boolean centered, boolean shadow, float scale, float opacity) {
            RenderHelperKt.drawScaledText((GuiGraphics)context, (ResourceLocation)font, (MutableComponent)text, (Number)x, (Number)y, (float)scale, (Number)Float.valueOf(opacity), (int)Integer.MAX_VALUE, (int)(0xFFFFFF + ((int)(opacity * 255.0f) << 24)), (boolean)centered, (boolean)shadow, null, null);
        }
    }

    static class GuiUtilsKtExt {
        GuiUtilsKtExt() {
        }

        static void blitk(PoseStack matrixStack, ResourceLocation texture, Number x, Number y, Number height, Number width, float alpha, float scale) {
            GuiUtilsKt.blitk((PoseStack)matrixStack, (ResourceLocation)texture, (Number)x, (Number)y, (Number)height, (Number)width, (Number)0, (Number)0, (Number)width, (Number)height, (Number)0, (Number)1, (Number)1, (Number)1, (Number)Float.valueOf(alpha), (boolean)true, (float)scale);
        }

        static void blitk(PoseStack matrixStack, ResourceLocation texture, Number x, Number y, Number height, Number width, float scale) {
            GuiUtilsKtExt.blitk(matrixStack, texture, x, y, height, width, 1.0f, scale);
        }

        static void blitk(PoseStack matrixStack, ResourceLocation texture, Number x, Number y, Number height, Number width) {
            GuiUtilsKtExt.blitk(matrixStack, texture, x, y, height, width, 1.0f);
        }
    }
}

