/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.gui;

import com.cobblemon.mod.common.api.storage.party.PartyPosition;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.gui.PokemonGuiUtilsKt;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.client.render.models.blockbench.FloatingState;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.client.storage.ClientParty;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.RenderablePokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.math.QuaternionUtilsKt;
import com.kreidev.cbmnfieldlab.PokemonFieldLab;
import com.kreidev.cbmnfieldlab.gui.FieldLabScreen;
import com.kreidev.cbmnfieldlab.gui.PartyPanelWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PartyPanelSlot
extends Button
implements CobblemonRenderable {
    public static final ResourceLocation GENDER_ICON_MALE = MiscUtilsKt.cobblemonResource((String)"textures/gui/pc/gender_icon_male.png");
    public static final ResourceLocation GENDER_ICON_FEMALE = MiscUtilsKt.cobblemonResource((String)"textures/gui/pc/gender_icon_female.png");
    public static final ResourceLocation SELECT_POINTER_RES = MiscUtilsKt.cobblemonResource((String)"textures/gui/pc/pc_pointer.png");
    public static final ResourceLocation SLOT_HOVER_OVERLAY_RES = PokemonFieldLab.resLoc("textures/gui/%s/party_panel_slot_hover.png", "pokemon_field_lab");
    public final PartyPanelWidget parent;
    public final ClientParty party;
    public final PartyPosition position;
    public final FloatingState state = new FloatingState();

    protected PartyPanelSlot(int x, int y, PartyPanelWidget parent, ClientParty party, PartyPosition position, Button.OnPress onPress) {
        super(x, y, 25, 25, (Component)Component.literal((String)"PartyPanelSlot"), onPress, DEFAULT_NARRATION);
        this.parent = parent;
        this.party = party;
        this.position = position;
    }

    @Nullable
    public Pokemon getPokemon() {
        return this.party.get(this.position);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderSlot(guiGraphics, this.getX(), this.getY(), delta);
    }

    public void renderSlot(GuiGraphics guiGraphics, int posX, int posY, float partialTicks) {
        ItemStack heldItem;
        Pokemon pokemon = this.getPokemon();
        if (pokemon == null) {
            return;
        }
        PoseStack matrices = guiGraphics.pose();
        guiGraphics.enableScissor(posX - 2, posY + 2, posX + 25 + 4, posY + 25 + 4);
        matrices.pushPose();
        matrices.translate((double)posX + 12.5, (double)posY + 1.0, 0.0);
        matrices.scale(2.5f, 2.5f, 1.0f);
        PokemonGuiUtilsKt.drawProfilePokemon((RenderablePokemon)pokemon.asRenderablePokemon(), (PoseStack)matrices, (Quaternionf)QuaternionUtilsKt.fromEulerXYZDegrees((Quaternionf)new Quaternionf(), (Vector3f)new Vector3f(13.0f, 35.0f, 0.0f)), (PoseType)PoseType.PROFILE, (PosableState)this.state, (float)partialTicks, (float)4.5f, (boolean)true, (boolean)true, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrices.popPose();
        guiGraphics.disableScissor();
        matrices.pushPose();
        matrices.translate(0.0, 0.0, 100.0);
        FieldLabScreen.RenderHelperKtExt.drawScaledText(guiGraphics, null, LocalizationUtilsKt.lang((String)"ui.lv.number", (Object[])new Object[]{pokemon.getLevel()}), posX + 1, posY + 1, false, true, 0.5f);
        if (pokemon.getGender() != Gender.GENDERLESS) {
            FieldLabScreen.GuiUtilsKtExt.blitk(matrices, pokemon.getGender() == Gender.MALE ? GENDER_ICON_MALE : GENDER_ICON_FEMALE, Float.valueOf((float)(posX + 21) / 0.5f), Float.valueOf((float)(posY + 1) / 0.5f), 8, 6, 0.5f);
        }
        if (!(heldItem = pokemon.getHeldItem$common()).isEmpty()) {
            RenderHelperKt.renderScaledGuiItemIcon((ItemStack)heldItem, (double)(posX + 16), (double)(posY + 16), (double)0.5, (float)100.0f, (PoseStack)matrices);
        }
        matrices.popPose();
        matrices.pushPose();
        matrices.translate(0.0, 0.0, 500.0);
        if (this.isHoveredOrFocused()) {
            FieldLabScreen.GuiUtilsKtExt.blitk(matrices, SELECT_POINTER_RES, Float.valueOf((float)(posX + 10) / 0.5f), Float.valueOf((float)(posY - 3) / 0.5f - (float)this.parent.parent.selectPointerOffsetY), 8, 11, 0.5f);
        }
        if (this.isHovered()) {
            FieldLabScreen.GuiUtilsKtExt.blitk(matrices, SLOT_HOVER_OVERLAY_RES, posX, posY, 25, 25);
        }
        matrices.popPose();
    }

    public boolean isHoveredOrFocused() {
        return this.getPokemon() == this.parent.parent.previewPokemon;
    }
}

