/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.gui;

import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.PokemonFieldLab;
import com.kreidev.cbmnfieldlab.gui.FieldLabScreen;
import com.kreidev.cbmnfieldlab.gui.QuestSlotWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class RerollButton
extends Button
implements CobblemonRenderable {
    public static final ResourceLocation REROLL_BUTTON_RES = PokemonFieldLab.resLoc("textures/gui/%s/reroll_button.png", "pokemon_field_lab");
    public static final ResourceLocation REROLL_ICON_RES = PokemonFieldLab.resLoc("textures/gui/%s/reroll_icon.png", "pokemon_field_lab");
    public static final ResourceLocation REROLL_BUTTON_HOVER_RES = PokemonFieldLab.resLoc("textures/gui/%s/reroll_button_hover.png", "pokemon_field_lab");
    public static final int WIDTH = 23;
    public static final int HEIGHT = 20;
    public final QuestSlotWidget parent;

    protected RerollButton(int x, int y, QuestSlotWidget parent, Button.OnPress onPress) {
        super(x, y, 21, 20, (Component)Component.literal((String)"Reroll"), onPress, DEFAULT_NARRATION);
        this.parent = parent;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        PoseStack matrices = guiGraphics.pose();
        float alpha = Math.min(1.0f, (float)this.parent.parent.parent.ticksElapsed / 10.0f);
        FieldLabScreen.GuiUtilsKtExt.blitk(matrices, REROLL_BUTTON_RES, this.getX(), this.getY(), 20, 23, alpha, 1.0f);
        float progress = Math.min(1.0f, (float)(this.parent.parent.parent.getGameTime() - this.parent.quest.getTimeStamp()) / ((float)CommonConfig.rerollTimeSeconds * 20.0f));
        int cropWidth = (int)(12.0f * progress);
        if (progress < 1.0f) {
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 0.7f * alpha);
        } else {
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        }
        guiGraphics.blit(REROLL_ICON_RES, this.getX() + 4, this.getY() + 3, 0.0f, 0.0f, cropWidth, 14, 12, 14);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        if (this.isHovered()) {
            FieldLabScreen.GuiUtilsKtExt.blitk(matrices, REROLL_BUTTON_HOVER_RES, this.getX(), this.getY(), 20, 23, alpha, 1.0f);
        }
    }

    public void playDownSound(SoundManager soundManager) {
    }
}

