/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.neoforge;

import com.kreidev.cbmnfieldlab.CommonConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CommonConfigNeoForge {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.IntValue REROLL_TIME_SECONDS = BUILDER.comment("Time before a quest reroll becomes available (seconds)").defineInRange("rerollTimeSeconds", 300, 1, 86400);
    private static final ModConfigSpec.DoubleValue INDIV_REWARD_VALUE_SCALE = BUILDER.comment("Scaling multiplier for individual quest reward value").defineInRange("indivRewardValueScale", 2.0, 0.01, 1000.0);
    private static final ModConfigSpec.DoubleValue MINOR_REWARD_VALUE = BUILDER.comment("Base reward value for minor quests").defineInRange("minorRewardValue", 4.0, 0.01, 1000.0);
    private static final ModConfigSpec.IntValue MINOR_REWARD_MIN_ITEMS = BUILDER.comment("Minimum number of items given for minor quest rewards").defineInRange("minorRewardMinItems", 1, 1, 100);
    private static final ModConfigSpec.IntValue MINOR_REWARD_MAX_ITEMS = BUILDER.comment("Maximum number of items given for minor quest rewards").defineInRange("minorRewardMaxItems", 2, 1, 100);
    private static final ModConfigSpec.DoubleValue MAJOR_REWARD_VALUE = BUILDER.comment("Base reward value for major quests").defineInRange("majorRewardValue", 8.0, 0.01, 1000.0);
    private static final ModConfigSpec.IntValue MAJOR_REWARD_MIN_ITEMS = BUILDER.comment("Minimum number of items given for major quest rewards").defineInRange("majorRewardMinItems", 3, 1, 100);
    private static final ModConfigSpec.IntValue MAJOR_REWARD_MAX_ITEMS = BUILDER.comment("Maximum number of items given for major quest rewards").defineInRange("majorRewardMaxItems", 6, 1, 100);
    private static final ModConfigSpec.BooleanValue ENABLE_ABILITY_QUEST = BUILDER.comment("Enable ability quests").define("enableAbilityQuest", true);
    private static final ModConfigSpec.BooleanValue ENABLE_SINGLE_TYPE_QUEST = BUILDER.comment("Enable single-type quests").define("enableSingleTypeQuest", true);
    private static final ModConfigSpec.BooleanValue ENABLE_DOUBLE_TYPE_QUEST = BUILDER.comment("Enable double-type quests").define("enableDoubleTypeQuest", true);
    private static final ModConfigSpec.BooleanValue ENABLE_NATURE_QUEST = BUILDER.comment("Enable nature quests").define("enableNatureQuest", true);
    private static final ModConfigSpec.BooleanValue ENABLE_MOVE_QUEST = BUILDER.comment("Enable move quests").define("enableMoveQuest", true);
    private static final ModConfigSpec.BooleanValue ENABLE_SIZE_QUEST = BUILDER.comment("Enable size quests").define("enableSizeQuest", true);
    private static final ModConfigSpec.BooleanValue ENABLE_BASE_STAT_QUEST = BUILDER.comment("Enable base stat total quests").define("enableBaseStatQuest", true);
    private static final ModConfigSpec.BooleanValue ENABLE_WEIGHT_QUEST = BUILDER.comment("Enable weight quests").define("enableWeightQuest", true);
    private static final ModConfigSpec.BooleanValue ENABLE_DEX_NAME_QUEST = BUILDER.comment("Enable pokedex name quests").define("enableMoveQuest", true);
    private static final ModConfigSpec.BooleanValue ENABLE_REGION_QUEST = BUILDER.comment("Enable region quests").define("enableSizeQuest", true);
    private static final ModConfigSpec.BooleanValue ENABLE_BIOME_QUEST = BUILDER.comment("Enable biome spawn quests").define("enableBaseStatQuest", true);
    private static final ModConfigSpec.BooleanValue ENABLE_EVO_STAGE_QUEST = BUILDER.comment("Enable evolution stage quests").define("enableWeightQuest", true);
    private static final ModConfigSpec.DoubleValue ABILITY_QUEST_DIFFICULTY = BUILDER.comment("Ability quest difficulty scale").defineInRange("abilityQuestDifficulty", 1.0, 0.01, 1000.0);
    private static final ModConfigSpec.DoubleValue SINGLE_TYPE_QUEST_DIFFICULTY = BUILDER.comment("Single-type quest difficulty scale").defineInRange("singleTypeQuestDifficulty", 1.0, 0.01, 1000.0);
    private static final ModConfigSpec.DoubleValue DOUBLE_TYPE_QUEST_DIFFICULTY = BUILDER.comment("Double-type quest difficulty scale").defineInRange("doubleTypeQuestDifficulty", 1.0, 0.01, 1000.0);
    private static final ModConfigSpec.DoubleValue NATURE_QUEST_DIFFICULTY = BUILDER.comment("Nature quest difficulty scale").defineInRange("natureQuestDifficulty", 1.0, 0.01, 1000.0);
    private static final ModConfigSpec.DoubleValue MOVE_QUEST_DIFFICULTY = BUILDER.comment("Move quest difficulty scale").defineInRange("moveQuestDifficulty", 1.0, 0.01, 1000.0);
    private static final ModConfigSpec.DoubleValue SIZE_QUEST_DIFFICULTY = BUILDER.comment("Size quest difficulty scale").defineInRange("sizeQuestDifficulty", 1.0, 0.01, 1000.0);
    private static final ModConfigSpec.DoubleValue BASE_STAT_QUEST_DIFFICULTY = BUILDER.comment("Base stat quest difficulty scale").defineInRange("baseStatQuestDifficulty", 1.0, 0.01, 1000.0);
    private static final ModConfigSpec.DoubleValue WEIGHT_QUEST_DIFFICULTY = BUILDER.comment("Weight quest difficulty scale").defineInRange("weightQuestDifficulty", 1.0, 0.01, 1000.0);
    private static final ModConfigSpec.DoubleValue DEX_NAME_QUEST_DIFFICULTY = BUILDER.comment("Dex name quest difficulty scale").defineInRange("dexNameQuestDifficulty", 1.0, 0.01, 1000.0);
    private static final ModConfigSpec.DoubleValue REGION_QUEST_DIFFICULTY = BUILDER.comment("Region quest difficulty scale").defineInRange("regionQuestDifficulty", 1.0, 0.01, 1000.0);
    private static final ModConfigSpec.DoubleValue BIOME_QUEST_DIFFICULTY = BUILDER.comment("Biome quest difficulty scale").defineInRange("biomeQuestDifficulty", 1.0, 0.01, 1000.0);
    private static final ModConfigSpec.DoubleValue EVO_QUEST_DIFFICULTY = BUILDER.comment("Evolution quest difficulty scale").defineInRange("evoQuestDifficulty", 1.0, 0.01, 1000.0);
    private static final ModConfigSpec.DoubleValue SIZE_QUEST_LOWER_BOUND = BUILDER.comment("Minimum size factor for size quests").defineInRange("sizeQuestLowerBound", 0.5, 0.0, 100.0);
    private static final ModConfigSpec.DoubleValue SIZE_QUEST_UPPER_BOUND = BUILDER.comment("Maximum size factor for size quests").defineInRange("sizeQuestUpperBound", 2.0, 0.0, 100.0);
    private static final ModConfigSpec.DoubleValue WEIGHT_QUEST_LOWER_BOUND = BUILDER.comment("Minimum weight factor for weight quests").defineInRange("weightQuestLowerBound", 0.5, 0.0, 100.0);
    private static final ModConfigSpec.DoubleValue WEIGHT_QUEST_UPPER_BOUND = BUILDER.comment("Maximum weight factor for weight quests").defineInRange("weightQuestUpperBound", 2.0, 0.0, 100.0);
    private static final ModConfigSpec.DoubleValue WEIGHT_QUEST_MIN_GAP = BUILDER.comment("Minimum gap between lower and upper weight bounds").defineInRange("weightQuestMinGap", 0.5, 0.0, 100.0);
    private static final ModConfigSpec.DoubleValue WEIGHT_QUEST_MAX_GAP = BUILDER.comment("Maximum gap between lower and upper weight bounds").defineInRange("weightQuestMaxGap", 1.0, 0.0, 100.0);
    private static final ModConfigSpec.IntValue BASE_STAT_QUEST_LOWER_BOUND = BUILDER.comment("Minimum total base stat value for base stat quests").defineInRange("baseStatQuestLowerBound", 200, 0, 2000);
    private static final ModConfigSpec.IntValue BASE_STAT_QUEST_UPPER_BOUND = BUILDER.comment("Maximum total base stat value for base stat quests").defineInRange("baseStatQuestUpperBound", 400, 0, 2000);
    private static final ModConfigSpec.IntValue BASE_STAT_QUEST_MIN_GAP = BUILDER.comment("Minimum difference between lower and upper base stat bounds").defineInRange("baseStatQuestMinGap", 30, 0, 2000);
    private static final ModConfigSpec.IntValue BASE_STAT_QUEST_MAX_GAP = BUILDER.comment("Maximum difference between lower and upper base stat bounds").defineInRange("baseStatQuestMaxGap", 80, 0, 2000);
    static final ModConfigSpec SPEC = BUILDER.build();

    private static void loadValues() {
        CommonConfig.rerollTimeSeconds = (Integer)REROLL_TIME_SECONDS.get();
        CommonConfig.indivRewardValueScale = ((Double)INDIV_REWARD_VALUE_SCALE.get()).floatValue();
        CommonConfig.minorRewardValue = ((Double)MINOR_REWARD_VALUE.get()).floatValue();
        CommonConfig.minorRewardMinItems = (Integer)MINOR_REWARD_MIN_ITEMS.get();
        CommonConfig.minorRewardMaxItems = (Integer)MINOR_REWARD_MAX_ITEMS.get();
        CommonConfig.majorRewardValue = ((Double)MAJOR_REWARD_VALUE.get()).floatValue();
        CommonConfig.majorRewardMinItems = (Integer)MAJOR_REWARD_MIN_ITEMS.get();
        CommonConfig.majorRewardMaxItems = (Integer)MAJOR_REWARD_MAX_ITEMS.get();
        CommonConfig.enableAbilityQuest = (Boolean)ENABLE_ABILITY_QUEST.get();
        CommonConfig.enableSingleTypeQuest = (Boolean)ENABLE_SINGLE_TYPE_QUEST.get();
        CommonConfig.enableDoubleTypeQuest = (Boolean)ENABLE_DOUBLE_TYPE_QUEST.get();
        CommonConfig.enableNatureQuest = (Boolean)ENABLE_NATURE_QUEST.get();
        CommonConfig.enableMoveQuest = (Boolean)ENABLE_MOVE_QUEST.get();
        CommonConfig.enableSizeQuest = (Boolean)ENABLE_SIZE_QUEST.get();
        CommonConfig.enableBaseStatQuest = (Boolean)ENABLE_BASE_STAT_QUEST.get();
        CommonConfig.enableWeightQuest = (Boolean)ENABLE_WEIGHT_QUEST.get();
        CommonConfig.enableDexNameQuest = (Boolean)ENABLE_DEX_NAME_QUEST.get();
        CommonConfig.enableRegionQuest = (Boolean)ENABLE_REGION_QUEST.get();
        CommonConfig.enableBiomeQuest = (Boolean)ENABLE_BIOME_QUEST.get();
        CommonConfig.enableEvoQuest = (Boolean)ENABLE_EVO_STAGE_QUEST.get();
        CommonConfig.abilityQuestDifficulty = ((Double)ABILITY_QUEST_DIFFICULTY.get()).floatValue();
        CommonConfig.singleTypeQuestDifficulty = ((Double)SINGLE_TYPE_QUEST_DIFFICULTY.get()).floatValue();
        CommonConfig.doubleTypeQuestDifficulty = ((Double)DOUBLE_TYPE_QUEST_DIFFICULTY.get()).floatValue();
        CommonConfig.natureQuestDifficulty = ((Double)NATURE_QUEST_DIFFICULTY.get()).floatValue();
        CommonConfig.moveQuestDifficulty = ((Double)MOVE_QUEST_DIFFICULTY.get()).floatValue();
        CommonConfig.sizeQuestDifficulty = ((Double)SIZE_QUEST_DIFFICULTY.get()).floatValue();
        CommonConfig.baseStatQuestDifficulty = ((Double)BASE_STAT_QUEST_DIFFICULTY.get()).floatValue();
        CommonConfig.weightQuestDifficulty = ((Double)WEIGHT_QUEST_DIFFICULTY.get()).floatValue();
        CommonConfig.dexNameQuestDifficulty = ((Double)DEX_NAME_QUEST_DIFFICULTY.get()).floatValue();
        CommonConfig.regionQuestDifficulty = ((Double)REGION_QUEST_DIFFICULTY.get()).floatValue();
        CommonConfig.biomeQuestDifficulty = ((Double)BIOME_QUEST_DIFFICULTY.get()).floatValue();
        CommonConfig.evoQuestDifficulty = ((Double)EVO_QUEST_DIFFICULTY.get()).floatValue();
        CommonConfig.sizeQuestLowerBound = ((Double)SIZE_QUEST_LOWER_BOUND.get()).floatValue();
        CommonConfig.sizeQuestUpperBound = ((Double)SIZE_QUEST_UPPER_BOUND.get()).floatValue();
        CommonConfig.weightQuestLowerBound = ((Double)WEIGHT_QUEST_LOWER_BOUND.get()).floatValue();
        CommonConfig.weightQuestUpperBound = ((Double)WEIGHT_QUEST_UPPER_BOUND.get()).floatValue();
        CommonConfig.weightQuestMinGap = ((Double)WEIGHT_QUEST_MIN_GAP.get()).floatValue();
        CommonConfig.weightQuestMaxGap = ((Double)WEIGHT_QUEST_MAX_GAP.get()).floatValue();
        CommonConfig.baseStatQuestLowerBound = (Integer)BASE_STAT_QUEST_LOWER_BOUND.get();
        CommonConfig.baseStatQuestUpperBound = (Integer)BASE_STAT_QUEST_UPPER_BOUND.get();
        CommonConfig.baseStatQuestMinGap = (Integer)BASE_STAT_QUEST_MIN_GAP.get();
        CommonConfig.baseStatQuestMaxGap = (Integer)BASE_STAT_QUEST_MAX_GAP.get();
    }

    static void onLoad(ModConfigEvent.Loading event) {
        CommonConfigNeoForge.loadValues();
    }

    static void onReload(ModConfigEvent.Loading event) {
        CommonConfigNeoForge.loadValues();
    }
}

