/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;

public class ConditionManager {
    private static final List<Pair<ResourceLocation, Float>> biomeConditions = new ArrayList<Pair<ResourceLocation, Float>>();

    public static void addBiomeConditions(Map<ResourceLocation, Float> conditions) {
        conditions.forEach((resourceLocation, difficulty) -> biomeConditions.add((Pair<ResourceLocation, Float>)new Pair(resourceLocation, difficulty)));
    }

    public static void clearAll() {
        biomeConditions.clear();
    }

    public static Pair<ResourceLocation, Float> getRandomBiomeCondition(ServerLevel level) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.BIOME);
        while (!biomeConditions.isEmpty()) {
            Pair<ResourceLocation, Float> rand = biomeConditions.get(level.getRandom().nextInt(biomeConditions.size()));
            if (registry.containsKey((ResourceLocation)rand.getFirst())) {
                return rand;
            }
            biomeConditions.remove(rand);
        }
        return new Pair((Object)registry.getKey((Object)((Biome)((Holder.Reference)registry.getRandom(level.getRandom()).orElseThrow()).value())), (Object)Float.valueOf(1.0f));
    }
}

