/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.quest.QuestType;
import com.kreidev.cbmnfieldlab.quest.QuestTypes;
import com.kreidev.cbmnfieldlab.quest.RewardManager;
import com.kreidev.cbmnfieldlab.quest.type.TypeQuest;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class Quest {
    public static final Codec<Quest> CODEC = QuestType.REGISTRY.byNameCodec().dispatch("type", Quest::getType, QuestType::codec);
    public final long timeStamp;
    @NotNull
    public final QuestType<?> type = this.getType();
    @NotNull
    public final ItemStack reward;

    public Quest(ServerLevel level) {
        this(level, 1.0f);
    }

    public Quest(ServerLevel level, float difficulty) {
        this.timeStamp = level.getGameTime();
        this.reward = RewardManager.getIndivReward(level.getRandom(), difficulty);
    }

    public Quest(ServerLevel level, @NotNull ItemStack reward) {
        this.timeStamp = level.getGameTime();
        this.reward = reward;
    }

    protected Quest(long timeStamp, @NotNull ItemStack reward) {
        this.timeStamp = timeStamp;
        this.reward = reward;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String toString() {
        return "Quest{timeStamp=" + this.timeStamp + ", type=" + String.valueOf(this.type) + ", modifier=" + this.getModifierString() + "}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Quest)) {
            return false;
        }
        Quest quest = (Quest)obj;
        return this.type == quest.type && this.timeStamp == quest.timeStamp;
    }

    public abstract boolean isEligible(@NotNull Pokemon var1);

    public abstract String getModifierString();

    public float getDifficulty() {
        return 1.0f;
    }

    @NotNull
    public abstract QuestType<?> getType();

    @NotNull
    public ItemStack getReward() {
        return this.reward;
    }

    public static Quest getRandomQuest(ServerLevel level) {
        ArrayList<QuestType<Quest>> enabledQuestTypes = new ArrayList<QuestType<Quest>>();
        if (CommonConfig.enableAbilityQuest) {
            enabledQuestTypes.add(QuestTypes.ABILITY);
        }
        if (CommonConfig.enableSingleTypeQuest) {
            enabledQuestTypes.add(QuestTypes.SINGLE_TYPE);
        }
        if (CommonConfig.enableDoubleTypeQuest) {
            enabledQuestTypes.add(QuestTypes.DOUBLE_TYPE);
        }
        if (CommonConfig.enableNatureQuest) {
            enabledQuestTypes.add(QuestTypes.NATURE);
        }
        if (CommonConfig.enableMoveQuest) {
            enabledQuestTypes.add(QuestTypes.MOVE);
        }
        if (CommonConfig.enableSizeQuest) {
            enabledQuestTypes.add(QuestTypes.SIZE);
        }
        if (CommonConfig.enableBaseStatQuest) {
            enabledQuestTypes.add(QuestTypes.BASE_STAT);
        }
        if (CommonConfig.enableWeightQuest) {
            enabledQuestTypes.add(QuestTypes.WEIGHT);
        }
        if (CommonConfig.enableDexNameQuest) {
            enabledQuestTypes.add(QuestTypes.DEX_NAME);
        }
        if (CommonConfig.enableRegionQuest) {
            enabledQuestTypes.add(QuestTypes.REGION);
        }
        if (CommonConfig.enableBiomeQuest) {
            enabledQuestTypes.add(QuestTypes.BIOME);
        }
        if (CommonConfig.enableEvoQuest) {
            enabledQuestTypes.add(QuestTypes.EVO_STAGE);
        }
        if (enabledQuestTypes.isEmpty()) {
            return new TypeQuest(level);
        }
        int randIndex = level.getRandom().nextInt(enabledQuestTypes.size());
        return ((QuestType)enabledQuestTypes.get(randIndex)).randomQuestFactory().apply(level);
    }
}

